/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.DoubleValues;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Scorable;
import guideme.internal.shaded.lucene.search.SegmentCacheable;
import java.io.IOException;

public abstract class DoubleValuesSource
implements SegmentCacheable {
    public static final DoubleValuesSource SCORES = new DoubleValuesSource(){

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            assert (scores != null);
            return scores;
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toString() {
            return "scores";
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) {
            return this;
        }
    };

    public abstract DoubleValues getValues(LeafReaderContext var1, DoubleValues var2) throws IOException;

    public abstract boolean needsScores();

    public abstract DoubleValuesSource rewrite(IndexSearcher var1) throws IOException;

    public abstract String toString();

    public static DoubleValues fromScorer(final Scorable scorer) {
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return scorer.score();
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                assert (scorer.docID() == doc);
                return true;
            }
        };
    }
}

