/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefArray;
import guideme.internal.shaded.lucene.util.BytesRefComparator;
import guideme.internal.shaded.lucene.util.BytesRefIterator;
import guideme.internal.shaded.lucene.util.Counter;
import guideme.internal.shaded.lucene.util.FixedBitSet;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.io.IOException;

final class FieldUpdatesBuffer {
    private static final long SELF_SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldUpdatesBuffer.class);
    private static final long STRING_SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(String.class);
    private final Counter bytesUsed;
    private int numUpdates;
    private final BytesRefArray termValues;
    private BytesRefArray.SortState termSortState;
    private final BytesRefArray byteValues;
    private int[] docsUpTo;
    private long[] numericValues;
    private FixedBitSet hasValues;
    private long maxNumeric;
    private long minNumeric;
    private String[] fields;
    private final boolean isNumeric;
    private boolean finished;

    long getMaxNumeric() {
        assert (this.isNumeric);
        if (this.minNumeric == Long.MAX_VALUE && this.maxNumeric == Long.MIN_VALUE) {
            return 0L;
        }
        return this.maxNumeric;
    }

    long getMinNumeric() {
        assert (this.isNumeric);
        if (this.minNumeric == Long.MAX_VALUE && this.maxNumeric == Long.MIN_VALUE) {
            return 0L;
        }
        return this.minNumeric;
    }

    void finish() {
        boolean sortedTerms;
        if (this.finished) {
            throw new IllegalStateException("buffer was finished already");
        }
        this.finished = true;
        boolean bl = sortedTerms = this.hasSingleValue() && this.hasValues == null && this.fields.length == 1;
        if (sortedTerms) {
            this.termSortState = this.termValues.sort(BytesRefComparator.NATURAL, true);
            assert (this.assertTermAndDocInOrder());
            this.bytesUsed.addAndGet(this.termSortState.ramBytesUsed());
        }
    }

    private boolean assertTermAndDocInOrder() {
        block6: {
            try {
                BytesRef current;
                BytesRefArray.IndexedBytesRefIterator iterator = this.termValues.iterator(this.termSortState);
                BytesRef last = null;
                int lastOrd = -1;
                while ((current = iterator.next()) != null) {
                    if (last != null) {
                        int cmp = current.compareTo(last);
                        assert (cmp >= 0) : "term in reverse order";
                        assert (cmp != 0 || this.docsUpTo[FieldUpdatesBuffer.getArrayIndex(this.docsUpTo.length, lastOrd)] <= this.docsUpTo[FieldUpdatesBuffer.getArrayIndex(this.docsUpTo.length, iterator.ord())]) : "doc id in reverse order";
                    }
                    last = BytesRef.deepCopyOf(current);
                    lastOrd = iterator.ord();
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)e.getMessage());
            }
        }
        return true;
    }

    BufferedUpdateIterator iterator() {
        if (!this.finished) {
            throw new IllegalStateException("buffer is not finished yet");
        }
        return new BufferedUpdateIterator();
    }

    boolean isNumeric() {
        assert (this.isNumeric || this.byteValues != null);
        return this.isNumeric;
    }

    boolean hasSingleValue() {
        return this.isNumeric && this.numericValues.length == 1;
    }

    long getNumericValue(int idx) {
        if (this.hasValues != null && !this.hasValues.get(idx)) {
            return 0L;
        }
        return this.numericValues[FieldUpdatesBuffer.getArrayIndex(this.numericValues.length, idx)];
    }

    private static int getArrayIndex(int arrayLength, int index) {
        assert (arrayLength == 1 || arrayLength > index) : "illegal array index length: " + arrayLength + " index: " + index;
        return Math.min(arrayLength - 1, index);
    }

    class BufferedUpdateIterator {
        private final BytesRefArray.IndexedBytesRefIterator termValuesIterator;
        private final BytesRefArray.IndexedBytesRefIterator lookAheadTermIterator;
        private final BytesRefIterator byteValuesIterator;
        private final BufferedUpdate bufferedUpdate = new BufferedUpdate();
        private final Bits updatesWithValue;

        BufferedUpdateIterator() {
            this.termValuesIterator = FieldUpdatesBuffer.this.termValues.iterator(FieldUpdatesBuffer.this.termSortState);
            this.lookAheadTermIterator = FieldUpdatesBuffer.this.termSortState != null ? FieldUpdatesBuffer.this.termValues.iterator(FieldUpdatesBuffer.this.termSortState) : null;
            this.byteValuesIterator = FieldUpdatesBuffer.this.isNumeric ? null : FieldUpdatesBuffer.this.byteValues.iterator();
            this.updatesWithValue = FieldUpdatesBuffer.this.hasValues == null ? new Bits.MatchAllBits(FieldUpdatesBuffer.this.numUpdates) : FieldUpdatesBuffer.this.hasValues;
        }

        boolean isSortedTerms() {
            return FieldUpdatesBuffer.this.termSortState != null;
        }

        BufferedUpdate next() throws IOException {
            BytesRef next = this.nextTerm();
            if (next != null) {
                int idx = this.termValuesIterator.ord();
                this.bufferedUpdate.termValue = next;
                this.bufferedUpdate.hasValue = this.updatesWithValue.get(idx);
                this.bufferedUpdate.termField = FieldUpdatesBuffer.this.fields[FieldUpdatesBuffer.getArrayIndex(FieldUpdatesBuffer.this.fields.length, idx)];
                this.bufferedUpdate.docUpTo = FieldUpdatesBuffer.this.docsUpTo[FieldUpdatesBuffer.getArrayIndex(FieldUpdatesBuffer.this.docsUpTo.length, idx)];
                if (this.bufferedUpdate.hasValue) {
                    if (FieldUpdatesBuffer.this.isNumeric) {
                        this.bufferedUpdate.numericValue = FieldUpdatesBuffer.this.numericValues[FieldUpdatesBuffer.getArrayIndex(FieldUpdatesBuffer.this.numericValues.length, idx)];
                        this.bufferedUpdate.binaryValue = null;
                    } else {
                        this.bufferedUpdate.binaryValue = this.byteValuesIterator.next();
                    }
                } else {
                    this.bufferedUpdate.binaryValue = null;
                    this.bufferedUpdate.numericValue = 0L;
                }
                return this.bufferedUpdate;
            }
            return null;
        }

        private BytesRef nextTerm() throws IOException {
            if (this.lookAheadTermIterator != null) {
                BytesRef lastTerm;
                BytesRef aheadTerm;
                if (this.bufferedUpdate.termValue == null) {
                    this.lookAheadTermIterator.next();
                }
                do {
                    aheadTerm = this.lookAheadTermIterator.next();
                    lastTerm = this.termValuesIterator.next();
                } while (aheadTerm != null && this.lookAheadTermIterator.ord() > this.termValuesIterator.ord() && aheadTerm.equals(lastTerm));
                return lastTerm;
            }
            return this.termValuesIterator.next();
        }
    }

    static class BufferedUpdate {
        int docUpTo;
        long numericValue;
        BytesRef binaryValue;
        boolean hasValue;
        String termField;
        BytesRef termValue;

        private BufferedUpdate() {
        }

        public int hashCode() {
            throw new UnsupportedOperationException("this struct should not be use in map or other data-structures that use hashCode / equals");
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException("this struct should not be use in map or other data-structures that use hashCode / equals");
        }
    }
}

