/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.interaction;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.internal.screen.IndepentScaleScreen;
import guideme.internal.screen.ScaledGuiGraphics;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import guideme.ui.GuideUiHost;
import guideme.ui.UiPoint;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;

public class LytWidget
extends LytBlock
implements InteractiveElement {
    private final AbstractWidget widget;

    public LytWidget(AbstractWidget widget) {
        this.widget = widget;
    }

    @Override
    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        return new LytRect(x, y, this.widget.getWidth(), this.widget.getHeight());
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
        this.widget.setX(this.widget.getX() + deltaX);
        this.widget.setY(this.widget.getY() + deltaY);
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
    }

    @Override
    public void render(RenderContext context) {
        this.updateWidgetPosition();
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (!(screen instanceof GuideUiHost)) {
            return;
        }
        GuideUiHost uiHost = (GuideUiHost)screen;
        MouseHandler mouseHandler = minecraft.mouseHandler;
        double xScale = (double)minecraft.screen.width / (double)minecraft.getWindow().getScreenWidth();
        double yScale = (double)minecraft.screen.height / (double)minecraft.getWindow().getScreenHeight();
        double mouseX = mouseHandler.xpos() * xScale;
        double mouseY = mouseHandler.ypos() * yScale;
        UiPoint mouseDocPos = uiHost.getDocumentPoint(mouseX, mouseY);
        GuiGraphics guiGraphics = context.guiGraphics();
        Screen screen2 = minecraft.screen;
        if (screen2 instanceof IndepentScaleScreen) {
            IndepentScaleScreen indepentScaleScreen = (IndepentScaleScreen)screen2;
            guiGraphics = new ScaledGuiGraphics(minecraft, context.guiGraphics().pose(), context.guiGraphics().bufferSource(), (float)indepentScaleScreen.getEffectiveScale());
        }
        this.widget.render(guiGraphics, mouseDocPos != null ? mouseDocPos.x() : -100, mouseDocPos != null ? mouseDocPos.y() : -100, minecraft.getDeltaFrameTime());
    }

    private void updateWidgetPosition() {
        this.widget.setPosition(this.bounds.x(), this.bounds.y());
    }

    @Override
    public boolean mouseMoved(GuideUiHost screen, int x, int y) {
        this.widget.mouseMoved((double)x, (double)y);
        return true;
    }

    @Override
    public boolean mouseClicked(GuideUiHost screen, int x, int y, int button) {
        return this.widget.mouseClicked((double)x, (double)y, button);
    }

    @Override
    public boolean mouseReleased(GuideUiHost screen, int x, int y, int button) {
        return this.widget.mouseReleased((double)x, (double)y, button);
    }

    @Override
    public Optional<GuideTooltip> getTooltip(float x, float y) {
        return Optional.empty();
    }

    public AbstractWidget getWidget() {
        return this.widget;
    }
}

