/*
 * Decompiled with CFR 0.152.
 */
package guideme.siteexport;

import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface ResourceExporter {
    default public void referenceItem(ItemLike item) {
        this.referenceItem(new ItemStack(item));
    }

    public void referenceItem(ItemStack var1);

    public void referenceFluid(Fluid var1);

    public String exportTexture(ResourceLocation var1);

    public Path copyResource(ResourceLocation var1);

    public Path getPathForWriting(ResourceLocation var1);

    public Path getPageSpecificPathForWriting(String var1);

    @Nullable
    public ResourceLocation getCurrentPageId();

    public Path getOutputFolder();

    default public String getPathRelativeFromOutputFolder(Path p) {
        return "/" + this.getOutputFolder().relativize(p).toString().replace('\\', '/');
    }

    public ResourceLocation getPageSpecificResourceLocation(String var1);

    public void referenceRecipe(Recipe<?> var1);
}

