/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.NormalizeIdentifier;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactoryDestination;
import guideme.libs.micromark.factory.FactoryLabel;
import guideme.libs.micromark.factory.FactorySpace;
import guideme.libs.micromark.factory.FactoryTitle;
import guideme.libs.micromark.factory.FactoryWhitespace;

public final class Definition {
    public static final Construct definition = new Construct();
    public static final Construct titleConstruct;

    static {
        Definition.definition.name = "definition";
        Definition.definition.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        titleConstruct = new Construct();
        Definition.titleConstruct.tokenize = (context, effects, ok, nok) -> new TitleStateMachine(context, effects, ok, nok)::start;
        Definition.titleConstruct.partial = true;
    }

    private static class TitleStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public TitleStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            return CharUtil.markdownLineEndingOrSpace(code) ? FactoryWhitespace.create(this.effects, this::before).step(code) : this.nok.step(code);
        }

        private State before(int code) {
            if (code == 34 || code == 39 || code == 40) {
                return FactoryTitle.create(this.effects, FactorySpace.create(this.effects, this::after, "whitespace"), this.nok, "definitionTitle", "definitionTitleMarker", "definitionTitleString").step(code);
            }
            return this.nok.step(code);
        }

        private State after(int code) {
            return code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code) ? this.ok.step(code) : this.nok.step(code);
        }
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        private String identifier;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 91, "expected `[`");
            this.effects.enter("definition");
            return FactoryLabel.create(this.context, this.effects, this::labelAfter, this.nok, "definitionLabel", "definitionLabelMarker", "definitionLabelString").step(code);
        }

        private State labelAfter(int code) {
            String lastTokenText = this.context.sliceSerialize(this.context.getLastEvent().token());
            this.identifier = NormalizeIdentifier.normalizeIdentifier(lastTokenText.substring(1, lastTokenText.length() - 1));
            if (code == 58) {
                this.effects.enter("definitionMarker");
                this.effects.consume(code);
                this.effects.exit("definitionMarker");
                return FactoryWhitespace.create(this.effects, FactoryDestination.create(this.effects, this.effects.attempt.hook(titleConstruct, FactorySpace.create(this.effects, this::after, "whitespace"), FactorySpace.create(this.effects, this::after, "whitespace")), this.nok, "definitionDestination", "definitionDestinationLiteral", "definitionDestinationLiteralMarker", "definitionDestinationRaw", "definitionDestinationString"));
            }
            return this.nok.step(code);
        }

        private State after(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                this.effects.exit("definition");
                if (!this.context.getParser().defined.contains(this.identifier)) {
                    this.context.getParser().defined.add(this.identifier);
                }
                return this.ok.step(code);
            }
            return this.nok.step(code);
        }
    }
}

