/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.mdast.model;

import com.google.gson.stream.JsonWriter;
import guideme.libs.unist.UnistPoint;
import guideme.libs.unist.UnistPosition;
import java.io.IOException;

public class MdAstPosition
implements UnistPosition {
    public UnistPoint start;
    public UnistPoint end;

    public MdAstPosition() {
    }

    public MdAstPosition(UnistPoint start, UnistPoint end) {
        this.start = start;
        this.end = end;
    }

    public static String stringify(UnistPoint point) {
        return point.line() + ":" + point.column();
    }

    public static String stringify(UnistPosition position) {
        return MdAstPosition.stringify(position.start(), position.end());
    }

    public static String stringify(UnistPoint start, UnistPoint end) {
        StringBuilder result = new StringBuilder();
        if (start != null) {
            result.append(start.line()).append(":").append(start.column());
        }
        if (end != null) {
            result.append("-").append(end.line()).append(":").append(end.column());
        }
        return result.toString();
    }

    @Override
    public UnistPoint start() {
        return this.start;
    }

    @Override
    public UnistPoint end() {
        return this.end;
    }

    public MdAstPosition withStart(UnistPoint point) {
        this.start = point;
        return this;
    }

    public MdAstPosition withEnd(UnistPoint point) {
        this.end = point;
        return this;
    }

    public void writeJson(JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name("start");
        this.start.writeJson(writer);
        writer.name("end");
        this.end.writeJson(writer);
        writer.endObject();
    }

    public String toString() {
        return MdAstPosition.stringify(this.start, this.end);
    }
}

