/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.DocValuesRewriteMethod;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MultiTermQueryConstantScoreBlendedWrapper;
import guideme.internal.shaded.lucene.search.MultiTermQueryConstantScoreWrapper;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.ScoringRewrite;
import guideme.internal.shaded.lucene.util.AttributeSource;
import java.io.IOException;
import java.util.Objects;

public abstract class MultiTermQuery
extends Query {
    protected final String field;
    protected RewriteMethod rewriteMethod;
    public static final RewriteMethod CONSTANT_SCORE_BLENDED_REWRITE = new RewriteMethod(){

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            return new MultiTermQueryConstantScoreBlendedWrapper<MultiTermQuery>(query);
        }
    };
    public static final RewriteMethod CONSTANT_SCORE_REWRITE = new RewriteMethod(){

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            return new MultiTermQueryConstantScoreWrapper<MultiTermQuery>(query);
        }
    };
    public static final RewriteMethod DOC_VALUES_REWRITE = new DocValuesRewriteMethod();
    public static final RewriteMethod SCORING_BOOLEAN_REWRITE = ScoringRewrite.SCORING_BOOLEAN_REWRITE;
    public static final RewriteMethod CONSTANT_SCORE_BOOLEAN_REWRITE = ScoringRewrite.CONSTANT_SCORE_BOOLEAN_REWRITE;

    public MultiTermQuery(String field, RewriteMethod rewriteMethod) {
        this.field = Objects.requireNonNull(field, "field must not be null");
        this.rewriteMethod = Objects.requireNonNull(rewriteMethod, "rewriteMethod must not be null");
    }

    public final String getField() {
        return this.field;
    }

    protected abstract TermsEnum getTermsEnum(Terms var1, AttributeSource var2) throws IOException;

    public final TermsEnum getTermsEnum(Terms terms) throws IOException {
        return this.getTermsEnum(terms, new AttributeSource());
    }

    public long getTermsCount() throws IOException {
        return -1L;
    }

    @Override
    public final Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return this.rewriteMethod.rewrite(indexSearcher.getIndexReader(), this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((MultiTermQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(MultiTermQuery other) {
        return this.rewriteMethod.equals(other.rewriteMethod) && this.field.equals(other.field);
    }

    public static abstract class RewriteMethod {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;

        protected TermsEnum getTermsEnum(MultiTermQuery query, Terms terms, AttributeSource atts) throws IOException {
            return query.getTermsEnum(terms, atts);
        }
    }
}

