/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs;

import guideme.internal.shaded.lucene.codecs.CompoundFormat;
import guideme.internal.shaded.lucene.codecs.DocValuesFormat;
import guideme.internal.shaded.lucene.codecs.FieldInfosFormat;
import guideme.internal.shaded.lucene.codecs.KnnVectorsFormat;
import guideme.internal.shaded.lucene.codecs.LiveDocsFormat;
import guideme.internal.shaded.lucene.codecs.NormsFormat;
import guideme.internal.shaded.lucene.codecs.PointsFormat;
import guideme.internal.shaded.lucene.codecs.PostingsFormat;
import guideme.internal.shaded.lucene.codecs.SegmentInfoFormat;
import guideme.internal.shaded.lucene.codecs.StoredFieldsFormat;
import guideme.internal.shaded.lucene.codecs.TermVectorsFormat;
import guideme.internal.shaded.lucene.util.NamedSPILoader;

public abstract class Codec
implements NamedSPILoader.NamedSPI {
    private final String name;

    protected Codec(String name) {
        NamedSPILoader.checkServiceName(name);
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public abstract PostingsFormat postingsFormat();

    public abstract DocValuesFormat docValuesFormat();

    public abstract StoredFieldsFormat storedFieldsFormat();

    public abstract TermVectorsFormat termVectorsFormat();

    public abstract FieldInfosFormat fieldInfosFormat();

    public abstract SegmentInfoFormat segmentInfoFormat();

    public abstract NormsFormat normsFormat();

    public abstract LiveDocsFormat liveDocsFormat();

    public abstract CompoundFormat compoundFormat();

    public abstract PointsFormat pointsFormat();

    public abstract KnnVectorsFormat knnVectorsFormat();

    public static Codec forName(String name) {
        return Holder.getLoader().lookup(name);
    }

    public static Codec getDefault() {
        if (Holder.defaultCodec == null) {
            throw new IllegalStateException("You tried to lookup the default Codec before all Codecs could be initialized. This likely happens if you try to get it from a Codec's ctor.");
        }
        return Holder.defaultCodec;
    }

    public String toString() {
        return this.name;
    }

    private static final class Holder {
        private static final NamedSPILoader<Codec> LOADER = new NamedSPILoader<Codec>(Codec.class);
        static Codec defaultCodec = LOADER.lookup("Lucene912");

        static NamedSPILoader<Codec> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a Codec by name before all Codecs could be initialized. This likely happens if you call Codec#forName from a Codec's ctor.");
            }
            return LOADER;
        }
    }
}

