/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.ga;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.StopFilter;
import guideme.internal.shaded.lucene.analysis.StopwordAnalyzerBase;
import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.WordlistLoader;
import guideme.internal.shaded.lucene.analysis.ga.IrishLowerCaseFilter;
import guideme.internal.shaded.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import guideme.internal.shaded.lucene.analysis.snowball.SnowballFilter;
import guideme.internal.shaded.lucene.analysis.standard.StandardTokenizer;
import guideme.internal.shaded.lucene.analysis.util.ElisionFilter;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.snowball.ext.IrishStemmer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;

public final class IrishAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    private static final CharArraySet DEFAULT_ARTICLES = CharArraySet.unmodifiableSet(new CharArraySet(Arrays.asList("d", "m", "b"), true));
    private static final CharArraySet HYPHENATIONS = CharArraySet.unmodifiableSet(new CharArraySet(Arrays.asList("h", "n", "t"), true));

    public IrishAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public IrishAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public IrishAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new StopFilter(source, HYPHENATIONS);
        result = new ElisionFilter(result, DEFAULT_ARTICLES);
        result = new IrishLowerCaseFilter(result);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new SnowballFilter(result, new IrishStemmer());
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new ElisionFilter(in, DEFAULT_ARTICLES);
        result = new IrishLowerCaseFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(IrishAnalyzer.class.getResourceAsStream("stopwords.txt"), "stopwords.txt"), "#");
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

