/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.item;

import guideme.internal.GuideME;
import guideme.internal.GuideMEProxy;
import guideme.internal.GuidebookText;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GuideItem
extends Item {
    public static final ResourceLocation ID = GuideME.makeId("guide");
    public static final ResourceLocation BASE_MODEL_ID = ID.m_246208_("item/").m_266382_("_base");
    public static final Item.Properties PROPERTIES = new Item.Properties();
    public static final String TAG_GUIDE_ID = "guideId";

    public GuideItem(Item.Properties properties) {
        super(properties);
    }

    public Component m_7626_(ItemStack stack) {
        Component name;
        ResourceLocation guideId = GuideItem.getGuideId(stack);
        if (guideId != null && (name = GuideMEProxy.instance().getGuideDisplayName(guideId)) != null) {
            return name;
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag tooltipFlag) {
        ResourceLocation guideId = GuideItem.getGuideId(stack);
        if (guideId != null) {
            GuideMEProxy.instance().addGuideTooltip(guideId, lines, tooltipFlag);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ResourceLocation guideId = GuideItem.getGuideId(player.m_21120_(hand));
        if (level.f_46443_) {
            if (guideId == null) {
                player.m_213846_((Component)GuidebookText.ItemNoGuideId.text());
            } else if (GuideMEProxy.instance().openGuide(player, guideId)) {
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Nullable
    public static ResourceLocation getGuideId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(TAG_GUIDE_ID, 8)) {
            return ResourceLocation.m_135820_((String)tag.m_128461_(TAG_GUIDE_ID));
        }
        return null;
    }
}

