/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.hotkey;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.InputConstants;
import guideme.Guide;
import guideme.PageAnchor;
import guideme.indices.ItemIndex;
import guideme.internal.GuideMEClient;
import guideme.internal.GuideRegistry;
import guideme.internal.GuidebookText;
import guideme.internal.screen.GuideScreen;
import guideme.ui.GuideUiHost;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public final class OpenGuideHotkey {
    private static final KeyMapping OPEN_GUIDE_MAPPING = new KeyMapping("key.guideme.guide", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 71, "key.guideme.category");
    private static boolean newTick = true;
    private static ResourceLocation previousItemId;
    private static final List<FoundPage> guidebookPages;
    private static int ticksKeyHeld;
    private static boolean holding;

    private OpenGuideHotkey() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.getEntity() != Minecraft.m_91087_().f_91074_) {
                return;
            }
            OpenGuideHotkey.handleTooltip(evt.getItemStack(), evt.getFlags(), evt.getToolTip());
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase == TickEvent.Phase.END) {
                newTick = true;
            }
        });
    }

    private static void handleTooltip(ItemStack itemStack, TooltipFlag tooltipFlag, List<Component> lines) {
        GuideScreen guideScreen;
        if (!OpenGuideHotkey.isKeyBound()) {
            holding = false;
            ticksKeyHeld = 0;
            return;
        }
        if (newTick) {
            newTick = false;
            OpenGuideHotkey.update(itemStack);
        }
        if (guidebookPages.isEmpty()) {
            return;
        }
        Guide guide = guidebookPages.get(0).guide();
        PageAnchor pageAnchor = guidebookPages.get(0).page();
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof GuideScreen && (guideScreen = (GuideScreen)screen).getGuide() == guide && guideScreen.getCurrentPageId().equals((Object)pageAnchor.pageId())) {
            return;
        }
        float progress = ticksKeyHeld;
        progress = holding ? (progress += minecraft.m_91297_()) : (progress -= minecraft.m_91297_());
        Component component = OpenGuideHotkey.makeProgressBar(Mth.m_14036_((float)(progress /= 10.0f), (float)0.0f, (float)1.0f));
        if (lines.isEmpty()) {
            lines.add(component);
        } else {
            lines.add(1, component);
        }
    }

    private static Component makeProgressBar(float progress) {
        Minecraft minecraft = Minecraft.m_91087_();
        MutableComponent holdW = GuidebookText.HoldToShow.text(OpenGuideHotkey.getHotkey().m_90863_().m_6881_().m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY);
        Font fontRenderer = minecraft.f_91062_;
        int charWidth = fontRenderer.m_92895_("|");
        int tipWidth = fontRenderer.m_92852_((FormattedText)holdW);
        int total = tipWidth / charWidth;
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            MutableComponent result = Component.m_237113_((String)Strings.repeat((String)"|", (int)current)).m_130940_(ChatFormatting.GRAY);
            if (progress < 1.0f) {
                result = result.m_7220_((Component)Component.m_237113_((String)Strings.repeat((String)"|", (int)(total - current))).m_130940_(ChatFormatting.DARK_GRAY));
            }
            return result;
        }
        return holdW;
    }

    private static void update(ItemStack itemStack) {
        ResourceLocation itemId = itemStack.m_220173_().m_203543_().map(ResourceKey::m_135782_).orElse(null);
        if (!Objects.equals(itemId, previousItemId)) {
            previousItemId = itemId;
            guidebookPages.clear();
            ticksKeyHeld = 0;
            if (itemId == null) {
                return;
            }
            for (Guide guide : GuideRegistry.getAll()) {
                ItemIndex itemIndex;
                PageAnchor page;
                if (!guide.isAvailableToOpenHotkey() || (page = (PageAnchor)(itemIndex = guide.getIndex(ItemIndex.class)).get(itemId)) == null) continue;
                guidebookPages.add(new FoundPage(guide, page));
            }
        }
        if (holding = OpenGuideHotkey.isKeyHeld()) {
            if (ticksKeyHeld < 10 && ++ticksKeyHeld == 10) {
                if (!guidebookPages.isEmpty()) {
                    GuideUiHost uiHost;
                    Guide guide;
                    FoundPage foundPage = guidebookPages.get(0);
                    guide = foundPage.guide();
                    Screen screen = Minecraft.m_91087_().f_91080_;
                    if (screen instanceof GuideUiHost && (uiHost = (GuideUiHost)screen).getGuide() == guide) {
                        uiHost.navigateTo(foundPage.page());
                    } else {
                        GuideMEClient.openGuideAtAnchor(guide, foundPage.page());
                    }
                    ticksKeyHeld = 0;
                    holding = false;
                }
            } else if (ticksKeyHeld > 10) {
                ticksKeyHeld = 10;
            }
        } else {
            ticksKeyHeld = Math.max(0, ticksKeyHeld - 2);
        }
    }

    private static boolean isKeyHeld() {
        int keyCode = OpenGuideHotkey.getHotkey().getKey().m_84873_();
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)window, (int)keyCode);
    }

    private static boolean isKeyBound() {
        return !OPEN_GUIDE_MAPPING.m_90862_();
    }

    public static KeyMapping getHotkey() {
        return OPEN_GUIDE_MAPPING;
    }

    static {
        guidebookPages = new ArrayList<FoundPage>();
    }

    private record FoundPage(Guide guide, PageAnchor page) {
    }
}

