/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.document.interaction.ItemTooltip;
import guideme.layout.LayoutContext;
import guideme.render.GuiAssets;
import guideme.render.GuiSprite;
import guideme.render.RenderContext;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class LytSlot
extends LytBlock
implements InteractiveElement {
    public static final int OUTER_SIZE = 18;
    public static final int OUTER_SIZE_LARGE = 26;
    private boolean largeSlot;
    private final ItemStack[] stacks;

    public LytSlot(Ingredient ingredient) {
        this.stacks = ingredient.m_43908_();
    }

    public LytSlot(ItemStack stack) {
        this.stacks = new ItemStack[]{stack};
    }

    public boolean isLargeSlot() {
        return this.largeSlot;
    }

    public void setLargeSlot(boolean largeSlot) {
        this.largeSlot = largeSlot;
    }

    @Override
    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        if (this.largeSlot) {
            return new LytRect(x, y, 26, 26);
        }
        return new LytRect(x, y, 18, 18);
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
    }

    @Override
    public void render(RenderContext context) {
        int x = this.bounds.x();
        int y = this.bounds.y();
        GuiSprite texture = this.largeSlot ? GuiAssets.LARGE_SLOT : GuiAssets.SLOT;
        context.fillIcon(this.bounds, texture);
        int padding = this.largeSlot ? 5 : 1;
        ItemStack stack = this.getDisplayedStack();
        if (!stack.m_41619_()) {
            context.renderItem(stack, x + padding, y + padding, 1, 16.0f, 16.0f);
        }
    }

    @Override
    public Optional<GuideTooltip> getTooltip(float x, float y) {
        ItemStack stack = this.getDisplayedStack();
        if (stack.m_41619_()) {
            return Optional.empty();
        }
        return Optional.of(new ItemTooltip(stack));
    }

    private ItemStack getDisplayedStack() {
        if (this.stacks.length == 0) {
            return ItemStack.f_41583_;
        }
        long cycle = System.nanoTime() / TimeUnit.MILLISECONDS.toNanos(2000L);
        return this.stacks[(int)(cycle % (long)this.stacks.length)];
    }
}

