/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.annotation;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import guideme.color.LightDarkMode;
import guideme.color.MutableColor;
import guideme.internal.GuideME;
import guideme.scene.annotation.InWorldAnnotation;
import guideme.scene.annotation.InWorldBoxAnnotation;
import guideme.scene.annotation.InWorldLineAnnotation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class InWorldAnnotationRenderer {
    private static final RenderType OCCLUDED = RenderType.create((String)"annotation_occluded", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x100000, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderType.LIGHTMAP).setShaderState(RenderType.RENDERTYPE_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.GREATER_DEPTH_TEST).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));

    private InWorldAnnotationRenderer() {
    }

    public static void render(MultiBufferSource.BufferSource buffers, Iterable<InWorldAnnotation> annotations, LightDarkMode lightDarkMode) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(GuideME.makeId((String)"block/noise"));
        VertexConsumer occludedConsumer = buffers.getBuffer(OCCLUDED);
        for (InWorldAnnotation annotation : annotations) {
            MutableColor color;
            if (annotation.isAlwaysOnTop()) continue;
            if (annotation instanceof InWorldBoxAnnotation) {
                InWorldBoxAnnotation boxAnnotation = (InWorldBoxAnnotation)annotation;
                color = MutableColor.of(boxAnnotation.color(), lightDarkMode);
                color.darker(50.0f).setAlpha(color.alpha() * 0.5f);
                if (boxAnnotation.isHovered()) {
                    color.lighter(50.0f);
                }
                InWorldAnnotationRenderer.render(occludedConsumer, boxAnnotation.min(), boxAnnotation.max(), color.toArgb32(), boxAnnotation.thickness(), sprite);
                continue;
            }
            if (!(annotation instanceof InWorldLineAnnotation)) continue;
            InWorldLineAnnotation lineAnnotation = (InWorldLineAnnotation)annotation;
            color = MutableColor.of(lineAnnotation.color(), lightDarkMode);
            color.darker(50.0f).setAlpha(color.alpha() * 0.5f);
            if (lineAnnotation.isHovered()) {
                color.lighter(50.0f);
            }
            InWorldAnnotationRenderer.strut(occludedConsumer, lineAnnotation.min(), lineAnnotation.max(), color.toArgb32(), lineAnnotation.thickness(), true, true, sprite);
        }
        buffers.endBatch(OCCLUDED);
        for (int pass = 1; pass <= 2; ++pass) {
            if (pass == 2) {
                RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
            }
            VertexConsumer consumer = buffers.getBuffer(RenderType.translucent());
            for (InWorldAnnotation annotation : annotations) {
                MutableColor color;
                if (annotation.isAlwaysOnTop() != (pass == 2)) continue;
                if (annotation instanceof InWorldBoxAnnotation) {
                    InWorldBoxAnnotation boxAnnotation = (InWorldBoxAnnotation)annotation;
                    color = MutableColor.of(boxAnnotation.color(), lightDarkMode);
                    if (boxAnnotation.isHovered()) {
                        color.lighter(50.0f);
                    }
                    InWorldAnnotationRenderer.render(consumer, boxAnnotation.min(), boxAnnotation.max(), color.toArgb32(), boxAnnotation.thickness(), sprite);
                    continue;
                }
                if (!(annotation instanceof InWorldLineAnnotation)) continue;
                InWorldLineAnnotation lineAnnotation = (InWorldLineAnnotation)annotation;
                color = MutableColor.of(lineAnnotation.color(), lightDarkMode);
                if (lineAnnotation.isHovered()) {
                    color.lighter(50.0f);
                }
                InWorldAnnotationRenderer.strut(consumer, lineAnnotation.min(), lineAnnotation.max(), color.toArgb32(), lineAnnotation.thickness(), true, true, sprite);
            }
            buffers.endBatch(RenderType.translucent());
        }
        buffers.endBatch();
    }

    public static void render(VertexConsumer consumer, Vector3f min, Vector3f max, int color, float thickness, TextureAtlasSprite sprite) {
        float thickHalf = thickness * 0.5f;
        Vector3f u = new Vector3f(max.x - min.x, 0.0f, 0.0f);
        Vector3f v = new Vector3f(0.0f, max.y - min.y, 0.0f);
        Vector3f t = new Vector3f(0.0f, 0.0f, max.z - min.z);
        Vector3f uNorm = new Vector3f((Vector3fc)u).normalize();
        Vector3f vNorm = new Vector3f((Vector3fc)v).normalize();
        Vector3f tNorm = new Vector3f((Vector3fc)t).normalize();
        Vector3f[] corners = new Vector3f[]{new Vector3f((Vector3fc)min), new Vector3f((Vector3fc)min).add((Vector3fc)u), new Vector3f((Vector3fc)min).add((Vector3fc)v), new Vector3f((Vector3fc)min).add((Vector3fc)t), new Vector3f((Vector3fc)max), new Vector3f((Vector3fc)max).sub((Vector3fc)u), new Vector3f((Vector3fc)max).sub((Vector3fc)v), new Vector3f((Vector3fc)max).sub((Vector3fc)t)};
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[0]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[1]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[2]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[7]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[3]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[6]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[5]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[4]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[0]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[2]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[1]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[7]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[3]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[5]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[6]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[4]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[0]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[3]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[1]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[6]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[2]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[5]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[7]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[4]), color, thickness, false, false, sprite);
    }

    private static void strut(VertexConsumer consumer, Vector3f from, Vector3f to, int color, float thickness, boolean startCap, boolean endCap, TextureAtlasSprite sprite) {
        Vector3f norm = new Vector3f((Vector3fc)to).sub((Vector3fc)from).normalize();
        Vector3f prefUp = Math.abs(from.x - to.x) < 0.01f && Math.abs(from.z - to.z) < 0.01f ? new Vector3f(1.0f, 0.0f, 0.0f) : new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f rightNorm = new Vector3f((Vector3fc)norm).cross((Vector3fc)prefUp).normalize();
        Vector3f leftNorm = new Vector3f((Vector3fc)rightNorm).negate();
        Vector3f upNorm = new Vector3f((Vector3fc)rightNorm).cross((Vector3fc)norm).normalize();
        Vector3f downNorm = new Vector3f((Vector3fc)upNorm).negate();
        Vector3f up = new Vector3f((Vector3fc)upNorm).mul(thickness * 0.5f);
        Vector3f right = new Vector3f((Vector3fc)rightNorm).mul(thickness * 0.5f);
        if (startCap) {
            InWorldAnnotationRenderer.quad(consumer, downNorm, color, new Vector3f((Vector3fc)from).add((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)from).add((Vector3fc)up).add((Vector3fc)right), sprite);
        }
        if (endCap) {
            InWorldAnnotationRenderer.quad(consumer, norm, color, new Vector3f((Vector3fc)to).add((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).sub((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)to).add((Vector3fc)up).sub((Vector3fc)right), sprite);
        }
        InWorldAnnotationRenderer.quad(consumer, leftNorm, color, new Vector3f((Vector3fc)from).sub((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)to).sub((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)to).sub((Vector3fc)right).sub((Vector3fc)up), new Vector3f((Vector3fc)from).sub((Vector3fc)right).sub((Vector3fc)up), sprite);
        InWorldAnnotationRenderer.quad(consumer, rightNorm, color, new Vector3f((Vector3fc)to).add((Vector3fc)right).sub((Vector3fc)up), new Vector3f((Vector3fc)to).add((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)from).add((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)from).add((Vector3fc)right).sub((Vector3fc)up), sprite);
        InWorldAnnotationRenderer.quad(consumer, upNorm, color, new Vector3f((Vector3fc)from).add((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)from).add((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).add((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).add((Vector3fc)up).sub((Vector3fc)right), sprite);
        InWorldAnnotationRenderer.quad(consumer, downNorm, color, new Vector3f((Vector3fc)to).sub((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)to).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).sub((Vector3fc)right), sprite);
    }

    private static void quad(VertexConsumer consumer, Vector3f faceNormal, int color, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, TextureAtlasSprite sprite) {
        Direction d = Direction.getNearest((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z);
        float shade = switch (d) {
            case Direction.DOWN -> 0.5f;
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
            default -> 1.0f;
        };
        color = FastColor.ARGB32.multiply((int)FastColor.ARGB32.color((int)255, (int)((int)(shade * 255.0f)), (int)((int)(shade * 255.0f)), (int)((int)(shade * 255.0f))), (int)color);
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v1, sprite.getU0(), sprite.getV1());
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v2, sprite.getU0(), sprite.getV0());
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v3, sprite.getU1(), sprite.getV0());
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v4, sprite.getU1(), sprite.getV1());
    }

    private static void vertex(VertexConsumer consumer, Vector3f faceNormal, int color, Vector3f bottomLeft, float u, float v) {
        consumer.vertex((double)bottomLeft.x, (double)bottomLeft.y, (double)bottomLeft.z).color(color).uv(u, v).uv2(0xF000F0).normal(faceNormal.x(), faceNormal.y(), faceNormal.z()).endVertex();
    }
}

