/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import guideme.color.LightDarkMode;
import guideme.internal.GuideMEClient;
import guideme.render.GuiSpriteScaling;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuiSprite {
    private static final Logger LOG = LoggerFactory.getLogger(GuiSprite.class);
    private final ResourceLocation id;
    private volatile CachedState cachedState;

    public GuiSprite(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation get(LightDarkMode mode) {
        CachedState state = this.getOrCreateCachedState();
        return mode == LightDarkMode.DARK_MODE ? state.darkId : this.id;
    }

    public GuiSpriteScaling spriteScaling() {
        CachedState state = this.getOrCreateCachedState();
        return state.spriteScaling;
    }

    public TextureAtlasSprite atlasSprite(LightDarkMode mode) {
        CachedState state = this.getOrCreateCachedState();
        return mode == LightDarkMode.LIGHT_MODE ? state.sprite : state.darkSprite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedState getOrCreateCachedState() {
        CachedState result = this.cachedState;
        if (result != null) {
            return result;
        }
        GuiSprite guiSprite = this;
        synchronized (guiSprite) {
            TextureAtlas guiSprites = GuideMEClient.instance().getGuiSpriteAtlas();
            TextureAtlasSprite sprite = guiSprites.getSprite(this.id);
            GuiSpriteScaling spriteScaling = this.getSpriteScaling(this.id);
            ResourceLocation darkId = this.id.withSuffix("_darkmode");
            TextureAtlasSprite darkSprite = guiSprites.getSprite(darkId);
            if (darkSprite.contents().name().equals((Object)MissingTextureAtlasSprite.getLocation())) {
                darkId = this.id;
                darkSprite = sprite;
            } else {
                GuiSpriteScaling darkScaling = this.getSpriteScaling(this.id);
                if (!darkScaling.equals(spriteScaling)) {
                    LOG.warn("Dark-mode sprite {} uses different sprite-scaling from the light-mode version. Please ensure the same .mcmeta file content is used.", (Object)darkId);
                }
            }
            this.cachedState = new CachedState(sprite, darkId, darkSprite, spriteScaling);
            return this.cachedState;
        }
    }

    private GuiSpriteScaling getSpriteScaling(ResourceLocation id) {
        ResourceMetadata metadata;
        Resource resource = Minecraft.getInstance().getResourceManager().getResource(id.withPrefix("textures/gui/sprites/").withSuffix(".png")).orElse(null);
        if (resource == null) {
            return GuiSpriteScaling.DEFAULT;
        }
        try {
            metadata = resource.metadata();
        }
        catch (IOException e) {
            LOG.error("Failed to load metadata for {}", (Object)id, (Object)e);
            return GuiSpriteScaling.DEFAULT;
        }
        try {
            return metadata.getSection(GuiSpriteScaling.SERIALIZER).orElse(GuiSpriteScaling.DEFAULT);
        }
        catch (Exception e) {
            LOG.error("Failed to read sprite scaling for {}", (Object)id, (Object)e);
            return GuiSpriteScaling.DEFAULT;
        }
    }

    void reset() {
        this.cachedState = null;
    }

    public String toString() {
        return this.id.toString();
    }

    private record CachedState(TextureAtlasSprite sprite, ResourceLocation darkId, TextureAtlasSprite darkSprite, GuiSpriteScaling spriteScaling) {
    }
}

