/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.mdast;

import guideme.libs.mdast.MdastContext;
import guideme.libs.mdast.MdastContextProperty;
import guideme.libs.mdast.MdastExtension;
import guideme.libs.mdast.MdastOptions;
import guideme.libs.mdast.model.MdAstAnyContent;
import guideme.libs.mdast.model.MdAstBlockquote;
import guideme.libs.mdast.model.MdAstBreak;
import guideme.libs.mdast.model.MdAstCode;
import guideme.libs.mdast.model.MdAstDefinition;
import guideme.libs.mdast.model.MdAstEmphasis;
import guideme.libs.mdast.model.MdAstHTML;
import guideme.libs.mdast.model.MdAstHeading;
import guideme.libs.mdast.model.MdAstImage;
import guideme.libs.mdast.model.MdAstImageReference;
import guideme.libs.mdast.model.MdAstInlineCode;
import guideme.libs.mdast.model.MdAstLink;
import guideme.libs.mdast.model.MdAstLinkReference;
import guideme.libs.mdast.model.MdAstList;
import guideme.libs.mdast.model.MdAstListItem;
import guideme.libs.mdast.model.MdAstLiteral;
import guideme.libs.mdast.model.MdAstNode;
import guideme.libs.mdast.model.MdAstParagraph;
import guideme.libs.mdast.model.MdAstParent;
import guideme.libs.mdast.model.MdAstPhrasingContent;
import guideme.libs.mdast.model.MdAstPosition;
import guideme.libs.mdast.model.MdAstReferenceType;
import guideme.libs.mdast.model.MdAstRoot;
import guideme.libs.mdast.model.MdAstStaticPhrasingContent;
import guideme.libs.mdast.model.MdAstStrong;
import guideme.libs.mdast.model.MdAstText;
import guideme.libs.mdast.model.MdAstThematicBreak;
import guideme.libs.micromark.Assert;
import guideme.libs.micromark.DecodeString;
import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.NamedCharacterEntities;
import guideme.libs.micromark.NormalizeIdentifier;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenProperty;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.html.NumericCharacterReference;
import guideme.libs.unist.UnistPoint;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

final class MdastCompiler
implements MdastContext {
    private static final TokenProperty<Boolean> SPREAD = new TokenProperty();
    private final MdastExtension extension;
    boolean expectingFirstListItemValue;
    boolean flowCodeInside;
    boolean setextHeadingSlurpLineEnding;
    boolean atHardBreak;
    MdAstReferenceType referenceType;
    boolean inReference;
    CharacterReferenceType characterReferenceType;
    private final Map<MdastContextProperty<?>, Object> extensionData = new IdentityHashMap();
    private List<MdAstNode> stack;
    private List<MdastContext.TokenStackEntry> tokenStack;
    @Nullable
    private TokenizeContext currentTokenContext;
    private final StringBuilder stringBuffer = new StringBuilder();
    private static final Pattern START_END_NEWLINE = Pattern.compile("^(\r?\n|\r)|(\r?\n|\r)\\z");

    MdastCompiler(MdastOptions options) {
        MdastExtension.Builder extensionBuilder = MdastExtension.builder().canContainEol("emphasis", "fragment", "heading", "paragraph", "strong").enter("autolink", this.opener(this::link)).enter("autolinkProtocol", this::onenterdata).enter("autolinkEmail", this::onenterdata).enter("atxHeading", this.opener(this::heading)).enter("blockQuote", this.opener(this::blockQuote)).enter("characterEscape", this::onenterdata).enter("characterReference", this::onenterdata).enter("codeFenced", this.opener(this::codeFlow)).enter("codeFencedFenceInfo", this::buffer).enter("codeFencedFenceMeta", this::buffer).enter("codeIndented", this.opener(this::codeFlow, this::buffer)).enter("codeText", this.opener(this::codeText, this::buffer)).enter("codeTextData", this::onenterdata).enter("data", this::onenterdata).enter("codeFlowValue", this::onenterdata).enter("definition", this.opener(this::definition)).enter("definitionDestinationString", this::buffer).enter("definitionLabelString", this::buffer).enter("definitionTitleString", this::buffer).enter("emphasis", this.opener(this::emphasis)).enter("hardBreakEscape", this.opener(this::hardBreak)).enter("hardBreakTrailing", this.opener(this::hardBreak)).enter("htmlFlow", this.opener(this::html, this::buffer)).enter("htmlFlowData", this::onenterdata).enter("htmlText", this.opener(this::html, this::buffer)).enter("htmlTextData", this::onenterdata).enter("image", this.opener(this::image)).enter("label", this::buffer).enter("link", this.opener(this::link)).enter("listItem", this.opener(this::listItem)).enter("listItemValue", this::onenterlistitemvalue).enter("listOrdered", this.opener(this::list, this::onenterlistordered)).enter("listUnordered", this.opener(this::list)).enter("paragraph", this.opener(this::paragraph)).enter("reference", this::onenterreference).enter("referenceString", this::buffer).enter("resourceDestinationString", this::buffer).enter("resourceTitleString", this::buffer).enter("setextHeading", this.opener(this::heading)).enter("strong", this.opener(this::strong)).enter("thematicBreak", this.opener(this::thematicBreak)).exit("atxHeading", this.closer()).exit("atxHeadingSequence", this::onexitatxheadingsequence).exit("autolink", this.closer()).exit("autolinkEmail", this::onexitautolinkemail).exit("autolinkProtocol", this::onexitautolinkprotocol).exit("blockQuote", this.closer()).exit("characterEscapeValue", this::onexitdata).exit("characterReferenceMarkerHexadecimal", this::onexitcharacterreferencemarker).exit("characterReferenceMarkerNumeric", this::onexitcharacterreferencemarker).exit("characterReferenceValue", this::onexitcharacterreferencevalue).exit("codeFenced", this.closer(this::onexitcodefenced)).exit("codeFencedFence", this::onexitcodefencedfence).exit("codeFencedFenceInfo", this::onexitcodefencedfenceinfo).exit("codeFencedFenceMeta", this::onexitcodefencedfencemeta).exit("codeFlowValue", this::onexitdata).exit("codeIndented", this.closer(this::onexitcodeindented)).exit("codeText", this.closer(this::onexitcodetext)).exit("codeTextData", this::onexitdata).exit("data", this::onexitdata).exit("definition", this.closer()).exit("definitionDestinationString", this::onexitdefinitiondestinationstring).exit("definitionLabelString", this::onexitdefinitionlabelstring).exit("definitionTitleString", this::onexitdefinitiontitlestring).exit("emphasis", this.closer()).exit("hardBreakEscape", this.closer(this::onexithardbreak)).exit("hardBreakTrailing", this.closer(this::onexithardbreak)).exit("htmlFlow", this.closer(this::onexithtmlflow)).exit("htmlFlowData", this::onexitdata).exit("htmlText", this.closer(this::onexithtmltext)).exit("htmlTextData", this::onexitdata).exit("image", this.closer(this::onexitimage)).exit("label", this::onexitlabel).exit("labelText", this::onexitlabeltext).exit("lineEnding", this::onexitlineending).exit("link", this.closer(this::onexitlink)).exit("listItem", this.closer()).exit("listOrdered", this.closer()).exit("listUnordered", this.closer()).exit("paragraph", this.closer()).exit("referenceString", this::onexitreferencestring).exit("resourceDestinationString", this::onexitresourcedestinationstring).exit("resourceTitleString", this::onexitresourcetitlestring).exit("resource", this::onexitresource).exit("setextHeading", this.closer(this::onexitsetextheading)).exit("setextHeadingLineSequence", this::onexitsetextheadinglinesequence).exit("setextHeadingText", this::onexitsetextheadingtext).exit("strong", this.closer()).exit("thematicBreak", this.closer());
        for (MdastExtension mdastExtension : options.mdastExtensions) {
            extensionBuilder.addAll(mdastExtension);
        }
        this.extension = extensionBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MdAstRoot compile(List<Tokenizer.Event> events) {
        Tokenizer.Event event;
        MdAstRoot tree = new MdAstRoot();
        this.stack = new ArrayList<MdAstNode>();
        this.stack.add(tree);
        this.tokenStack = new ArrayList<MdastContext.TokenStackEntry>();
        ArrayList<Integer> listStack = new ArrayList<Integer>();
        int index = -1;
        while (++index < events.size()) {
            event = events.get(index);
            if (!event.token().type.equals("listOrdered") && !event.token().type.equals("listUnordered")) continue;
            if (event.isEnter()) {
                listStack.add(index);
                continue;
            }
            Integer tail = (Integer)ListUtils.pop(listStack);
            Assert.check(tail != null, "expected list ot be open");
            index = MdastCompiler.prepareList(events, tail, index);
        }
        index = -1;
        while (++index < events.size()) {
            event = events.get(index);
            Map<String, MdastExtension.Handler> handlerMap = event.isEnter() ? this.extension.enter : this.extension.exit;
            MdastExtension.Handler handler = handlerMap.get(event.token().type);
            if (handler == null) continue;
            this.currentTokenContext = event.context();
            try {
                handler.handle(this, event.token());
                Assert.check(this.currentTokenContext == event.context(), "currentTokenContext changed while calling handler!");
            }
            catch (Throwable throwable) {
                Assert.check(this.currentTokenContext == event.context(), "currentTokenContext changed while calling handler!");
                this.currentTokenContext = null;
                throw throwable;
            }
            this.currentTokenContext = null;
        }
        if (!this.tokenStack.isEmpty()) {
            MdastContext.TokenStackEntry tail = this.tokenStack.get(this.tokenStack.size() - 1);
            MdastContext.OnEnterError handler = Objects.requireNonNullElse(tail.onError(), this::defaultOnError);
            handler.error(this, null, tail.token());
        }
        tree.position = new MdAstPosition().withStart(this.point(!events.isEmpty() ? events.get((int)0).token().start : MdastCompiler.makePoint(1, 1, 0))).withEnd(this.point(!events.isEmpty() ? events.get((int)(events.size() - 2)).token().end : MdastCompiler.makePoint(1, 1, 0)));
        for (MdastExtension.Transform transform : this.extension.transforms) {
            tree = transform.transform(tree);
        }
        return tree;
    }

    private static UnistPoint makePoint(int line, int column, int offset) {
        return new Point(line, column, offset, -1, -1);
    }

    private static int prepareList(List<Tokenizer.Event> events, int start, int length) {
        int index = start - 1;
        int containerBalance = -1;
        boolean listSpread = false;
        Token listItem = null;
        Integer lineIndex = null;
        Integer firstBlankLineIndex = null;
        boolean atMarker = false;
        while (++index <= length) {
            Tokenizer.Event event = events.get(index);
            String tokenType = event.token().type;
            if (tokenType.equals("listUnordered") || tokenType.equals("listOrdered") || tokenType.equals("blockQuote")) {
                containerBalance = event.isEnter() ? ++containerBalance : --containerBalance;
                atMarker = false;
            } else if (tokenType.equals("lineEndingBlank")) {
                if (event.isEnter()) {
                    if (!(listItem == null || atMarker || containerBalance != 0 || firstBlankLineIndex != null && firstBlankLineIndex != 0)) {
                        firstBlankLineIndex = index;
                    }
                    atMarker = false;
                }
            } else if (!(tokenType.equals("linePrefix") || tokenType.equals("listItemValue") || tokenType.equals("listItemMarker") || tokenType.equals("listItemPrefix") || tokenType.equals("listItemPrefixWhitespace"))) {
                atMarker = false;
            }
            if ((containerBalance != 0 || !event.isEnter() || !tokenType.equals("listItemPrefix")) && (containerBalance != -1 || !event.isExit() || !tokenType.equals("listUnordered") && !tokenType.equals("listOrdered"))) continue;
            if (listItem != null) {
                int tailIndex = index;
                lineIndex = null;
                while (tailIndex-- != 0) {
                    Tokenizer.Event tailEvent = events.get(tailIndex);
                    String tailEventTokenType = tailEvent.token().type;
                    if (tailEventTokenType.equals("lineEnding") || tailEventTokenType.equals("lineEndingBlank")) {
                        if (tailEvent.isExit()) continue;
                        if (lineIndex != null && lineIndex != 0) {
                            events.get((int)lineIndex.intValue()).token().type = "lineEndingBlank";
                            listSpread = true;
                        }
                        tailEvent.token().type = "lineEnding";
                        lineIndex = tailIndex;
                        continue;
                    }
                    if (tailEventTokenType.equals("linePrefix") || tailEventTokenType.equals("blockQuotePrefix") || tailEventTokenType.equals("blockQuotePrefixWhitespace") || tailEventTokenType.equals("blockQuoteMarker") || tailEventTokenType.equals("listItemIndent")) continue;
                }
                if (firstBlankLineIndex != null && firstBlankLineIndex != 0 && (lineIndex == null || lineIndex == 0 || firstBlankLineIndex < lineIndex)) {
                    listItem.set(SPREAD, true);
                }
                listItem.end = lineIndex != null && lineIndex != 0 ? events.get((int)lineIndex.intValue()).token().start : event.token().end;
                ListUtils.splice(events, Objects.requireNonNullElse(lineIndex, index), 0, List.of(Tokenizer.Event.exit(listItem, event.context())));
                ++index;
                ++length;
            }
            if (!tokenType.equals("listItemPrefix")) continue;
            listItem = new Token();
            listItem.type = "listItem";
            listItem.set(SPREAD, false);
            listItem.start = event.token().start;
            ListUtils.splice(events, index, 0, List.of(Tokenizer.Event.enter(listItem, event.context())));
            ++index;
            ++length;
            firstBlankLineIndex = null;
            atMarker = true;
        }
        events.get(start).token().set(SPREAD, listSpread);
        return length;
    }

    UnistPoint point(UnistPoint d) {
        return d;
    }

    MdastExtension.Handler opener(Supplier<MdAstNode> create) {
        return (ctx, token) -> this.enter((MdAstNode)create.get(), token);
    }

    MdastExtension.Handler opener(Function<Token, MdAstNode> create) {
        return (ctx, token) -> this.enter((MdAstNode)create.apply(token), token);
    }

    MdastExtension.Handler opener(Supplier<MdAstNode> create, MdastExtension.Handler and) {
        return this.opener((Token t) -> (MdAstNode)create.get(), and);
    }

    MdastExtension.Handler opener(Supplier<MdAstNode> create, Runnable and) {
        return this.opener((Token t) -> (MdAstNode)create.get(), (MdastContext context, Token token) -> and.run());
    }

    MdastExtension.Handler opener(Function<Token, MdAstNode> create, Runnable and) {
        return this.opener(create, (MdastContext context, Token token) -> and.run());
    }

    MdastExtension.Handler opener(Function<Token, MdAstNode> create, MdastExtension.Handler and) {
        return (ctx, token) -> {
            this.enter((MdAstNode)create.apply(token), token);
            if (and != null) {
                and.handle(this, token);
            }
        };
    }

    @Override
    public List<MdAstNode> getStack() {
        return this.stack;
    }

    @Override
    public List<MdastContext.TokenStackEntry> getTokenStack() {
        return this.tokenStack;
    }

    @Override
    public void buffer() {
        this.stack.add(new Fragment());
    }

    @Override
    @Nullable
    public <T> T get(MdastContextProperty<T> property) {
        return (T)this.extensionData.get(property);
    }

    @Override
    public <T> void set(MdastContextProperty<T> property, T value) {
        this.extensionData.put(property, value);
    }

    @Override
    public void remove(MdastContextProperty<?> property) {
        this.extensionData.remove(property);
    }

    @Override
    public <N extends MdAstNode> N enter(N node, Token token, MdastContext.OnEnterError errorHandler) {
        MdAstParent parent = (MdAstParent)this.stack.get(this.stack.size() - 1);
        Assert.check(parent != null, "expected `parent`");
        parent.addChild(node);
        this.stack.add(node);
        this.tokenStack.add(new MdastContext.TokenStackEntry(token, errorHandler));
        node.position = new MdAstPosition();
        node.position.start = token.start;
        return node;
    }

    private MdastExtension.Handler closer() {
        return (context, token) -> this.exit(token);
    }

    private MdastExtension.Handler closer(Runnable and) {
        return (context, token) -> {
            and.run();
            this.exit(token);
        };
    }

    private MdastExtension.Handler closer(@Nullable MdastExtension.Handler and) {
        return (context, token) -> {
            if (and != null) {
                and.handle(this, token);
            }
            this.exit(token);
        };
    }

    @Override
    public MdAstNode exit(Token token, MdastContext.OnExitError onExitError) {
        MdAstNode node = ListUtils.pop(this.stack);
        Assert.check(node != null, "expected `node`");
        MdastContext.TokenStackEntry open = ListUtils.pop(this.tokenStack);
        if (open == null) {
            throw new RuntimeException("Cannot close `" + token.type + "` (" + MdAstPosition.stringify(token.start, token.end) + "): it\u2019s not open");
        }
        if (!open.token().type.equals(token.type)) {
            if (onExitError != null) {
                onExitError.error(this, token, open.token());
            } else {
                MdastContext.OnEnterError handler = Objects.requireNonNullElse(open.onError(), this::defaultOnError);
                handler.error(this, token, open.token());
            }
        }
        Assert.check(!node.type().equals("fragment"), "unexpected fragment `exit`ed");
        Assert.check(node.position != null, "expected `position` to be defined");
        node.position.end = token.end;
        return node;
    }

    @Override
    public String sliceSerialize(Token token) {
        Assert.check(this.currentTokenContext != null, "missing current token context");
        return this.currentTokenContext.sliceSerialize(token);
    }

    @Override
    public MdastExtension getExtension() {
        return this.extension;
    }

    @Override
    public String resume() {
        this.stringBuffer.setLength(0);
        ListUtils.pop(this.stack).toText(this.stringBuffer);
        return this.stringBuffer.toString();
    }

    private void onenterlistordered() {
        this.expectingFirstListItemValue = true;
    }

    private void onenterlistitemvalue(MdastContext context, Token token) {
        if (this.expectingFirstListItemValue) {
            MdAstList ancestor = (MdAstList)this.stack.get(this.stack.size() - 2);
            ancestor.start = Integer.parseInt(this.sliceSerialize(token), 10);
            this.expectingFirstListItemValue = false;
        }
    }

    private void onexitcodefencedfenceinfo() {
        String data = this.resume();
        MdAstCode node = (MdAstCode)this.stack.get(this.stack.size() - 1);
        node.lang = data;
    }

    private void onexitcodefencedfencemeta() {
        String data = this.resume();
        MdAstCode node = (MdAstCode)this.stack.get(this.stack.size() - 1);
        node.meta = data;
    }

    private void onexitcodefencedfence() {
        if (this.flowCodeInside) {
            return;
        }
        this.buffer();
        this.flowCodeInside = true;
    }

    private void onexitcodefenced() {
        String data = this.resume();
        MdAstCode node = (MdAstCode)this.stack.get(this.stack.size() - 1);
        node.value = START_END_NEWLINE.matcher(data).replaceAll("");
        this.flowCodeInside = false;
    }

    private void onexitcodeindented() {
        String data = this.resume();
        MdAstCode node = (MdAstCode)this.stack.get(this.stack.size() - 1);
        node.value = data.replaceAll("(\\r?\\n|\\r)$", "");
    }

    private void onexitdefinitionlabelstring(MdastContext context, Token token) {
        String label = this.resume();
        MdAstDefinition node = (MdAstDefinition)this.stack.get(this.stack.size() - 1);
        node.label = label;
        node.identifier = NormalizeIdentifier.normalizeIdentifier(this.sliceSerialize(token)).toLowerCase();
    }

    private void onexitdefinitiontitlestring() {
        String data = this.resume();
        MdAstDefinition node = (MdAstDefinition)this.stack.get(this.stack.size() - 1);
        node.title = data;
    }

    private void onexitdefinitiondestinationstring() {
        String data = this.resume();
        MdAstDefinition node = (MdAstDefinition)this.stack.get(this.stack.size() - 1);
        node.url = data;
    }

    private void onexitatxheadingsequence(MdastContext context, Token token) {
        MdAstHeading node = (MdAstHeading)this.stack.get(this.stack.size() - 1);
        if (node.depth == 0) {
            int depth = this.sliceSerialize(token).length();
            Assert.check(depth == 1 || depth == 2 || depth == 3 || depth == 4 || depth == 5 || depth == 6, "expected `depth` between `1` and `6`");
            node.depth = depth;
        }
    }

    private void onexitsetextheadingtext() {
        this.setextHeadingSlurpLineEnding = true;
    }

    private void onexitsetextheadinglinesequence(MdastContext context, Token token) {
        MdAstHeading node = (MdAstHeading)this.stack.get(this.stack.size() - 1);
        node.depth = this.sliceSerialize(token).charAt(0) == '=' ? 1 : 2;
    }

    private void onexitsetextheading() {
        this.setextHeadingSlurpLineEnding = false;
    }

    private void onenterdata(MdastContext context, Token token) {
        MdAstParent parent = (MdAstParent)this.stack.get(this.stack.size() - 1);
        MdAstNode tail = null;
        if (!parent.children().isEmpty()) {
            tail = (MdAstNode)parent.children().get(parent.children().size() - 1);
        }
        if (tail == null || !tail.type().equals("text")) {
            tail = this.text();
            tail.position = new MdAstPosition().withStart(token.start);
            parent.addChild(tail);
        }
        this.stack.add(tail);
    }

    private void onexitdata(MdastContext context, Token token) {
        MdAstNode tail = ListUtils.pop(this.stack);
        Assert.check(tail != null, "expected a `node` to be on the stack");
        Assert.check(tail.position != null, "expected `node` to have an open position");
        if (!(tail instanceof MdAstLiteral)) {
            throw new IllegalStateException("expected a `literal` to be on the stack");
        }
        MdAstLiteral literal = (MdAstLiteral)tail;
        literal.value = literal.value + this.sliceSerialize(token);
        literal.position.end = this.point(token.end);
    }

    private void onexitlineending(MdastContext ignored, Token token) {
        MdAstNode context = this.stack.get(this.stack.size() - 1);
        Assert.check(context != null, "expected `node`");
        if (this.atHardBreak) {
            if (!(context instanceof MdAstParent)) {
                throw new IllegalStateException("expected `parent`");
            }
            MdAstParent parent = (MdAstParent)context;
            MdAstNode tail = (MdAstNode)parent.children().get(parent.children().size() - 1);
            Assert.check(tail.position != null, "expected tail to have a starting position");
            tail.position.end = this.point(token.end);
            this.atHardBreak = false;
            return;
        }
        if (!this.setextHeadingSlurpLineEnding && this.extension.canContainEols.contains(context.type())) {
            this.onenterdata(this, token);
            this.onexitdata(this, token);
        }
    }

    private void onexithardbreak() {
        this.atHardBreak = true;
    }

    private void onexithtmlflow() {
        String data = this.resume();
        MdAstHTML node = (MdAstHTML)this.stack.get(this.stack.size() - 1);
        node.value = data;
    }

    private void onexithtmltext() {
        String data = this.resume();
        MdAstHTML node = (MdAstHTML)this.stack.get(this.stack.size() - 1);
        node.value = data;
    }

    private void onexitcodetext() {
        String data = this.resume();
        MdAstInlineCode node = (MdAstInlineCode)this.stack.get(this.stack.size() - 1);
        node.value = data;
    }

    private void onexitlink() {
        MdAstParent replacement;
        MdAstNode mdAstNode = this.stack.get(this.stack.size() - 1);
        if (!(mdAstNode instanceof LinkOrLinkReference)) {
            return;
        }
        LinkOrLinkReference context = (LinkOrLinkReference)mdAstNode;
        if (this.inReference) {
            MdAstLinkReference ref = new MdAstLinkReference();
            ref.referenceType = Objects.requireNonNullElse(this.referenceType, MdAstReferenceType.SHORTCUT);
            ref.identifier = context.identifier;
            ref.label = context.label;
            replacement = ref;
        } else {
            MdAstLink link = new MdAstLink();
            link.url = context.url;
            link.title = context.title;
            replacement = link;
        }
        replacement.position = context.position;
        replacement.data = context.data;
        for (MdAstStaticPhrasingContent child : context.children()) {
            replacement.addChild((MdAstNode)((Object)child));
        }
        ((MdAstParent)this.stack.get(this.stack.size() - 2)).replaceChild(context, replacement);
        this.stack.set(this.stack.size() - 1, replacement);
        this.referenceType = null;
    }

    private void onexitimage() {
        MdAstNode replacement;
        MdAstNode context = this.stack.get(this.stack.size() - 1);
        if (!(context instanceof ImageOrImageReference)) {
            return;
        }
        ImageOrImageReference closedImageOrRef = (ImageOrImageReference)context;
        if (this.inReference) {
            MdAstImageReference imgRef = new MdAstImageReference();
            imgRef.referenceType = Objects.requireNonNullElse(this.referenceType, MdAstReferenceType.SHORTCUT);
            imgRef.identifier = closedImageOrRef.identifier;
            imgRef.label = closedImageOrRef.label;
            imgRef.alt = closedImageOrRef.alt;
            replacement = imgRef;
        } else {
            MdAstImage img = new MdAstImage();
            img.url = closedImageOrRef.url;
            img.title = closedImageOrRef.title;
            img.alt = closedImageOrRef.alt;
            replacement = img;
        }
        replacement.position = context.position;
        replacement.data = context.data;
        ((MdAstParent)this.stack.get(this.stack.size() - 2)).replaceChild(context, replacement);
        this.stack.set(this.stack.size() - 1, replacement);
        this.referenceType = null;
    }

    private void onexitlabeltext(MdastContext context, Token token) {
        String string = this.sliceSerialize(token);
        for (int i = this.stack.size() - 2; i >= 0; --i) {
            MdAstNode ancestor = this.stack.get(i);
            if (ancestor instanceof LinkOrLinkReference) {
                LinkOrLinkReference link = (LinkOrLinkReference)ancestor;
                link.label = DecodeString.decodeString(string);
                link.identifier = NormalizeIdentifier.normalizeIdentifier(string).toLowerCase();
                return;
            }
            if (!(ancestor instanceof ImageOrImageReference)) continue;
            ImageOrImageReference image = (ImageOrImageReference)ancestor;
            image.label = DecodeString.decodeString(string);
            image.identifier = NormalizeIdentifier.normalizeIdentifier(string).toLowerCase();
            return;
        }
        throw new IllegalStateException("Couldn't find reference on the stack to close");
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void onexitlabel() {
        MdAstNode fragment = this.stack.get(this.stack.size() - 1);
        String value = this.resume();
        MdAstNode node = this.stack.get(this.stack.size() - 1);
        this.inReference = true;
        if (node instanceof MdAstLink) {
            MdAstLink link = (MdAstLink)node;
            if (fragment instanceof MdAstParent) {
                MdAstParent container = (MdAstParent)fragment;
                Iterator iterator = container.children().iterator();
                while (iterator.hasNext()) {
                    MdAstAnyContent child = (MdAstAnyContent)iterator.next();
                    link.addChild((MdAstNode)((Object)child));
                }
                return;
            }
        }
        if (!(node instanceof MdAstImage)) return;
        MdAstImage image = (MdAstImage)node;
        image.alt = value;
    }

    private void onexitresourcedestinationstring() {
        String data = this.resume();
        MdAstNode node = this.stack.get(this.stack.size() - 1);
        if (node instanceof MdAstLink) {
            MdAstLink link = (MdAstLink)node;
            link.url = data;
        } else if (node instanceof MdAstImage) {
            MdAstImage image = (MdAstImage)node;
            image.url = data;
        }
    }

    private void onexitresourcetitlestring() {
        String data = this.resume();
        MdAstNode node = this.stack.get(this.stack.size() - 1);
        if (node instanceof MdAstLink) {
            MdAstLink link = (MdAstLink)node;
            link.title = data;
        } else if (node instanceof MdAstImage) {
            MdAstImage image = (MdAstImage)node;
            image.title = data;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void onexitresource() {
        this.inReference = false;
    }

    private void onenterreference() {
        this.referenceType = MdAstReferenceType.COLLAPSED;
    }

    private void onexitreferencestring(MdastContext context, Token token) {
        String label = this.resume();
        MdAstNode node = this.stack.get(this.stack.size() - 1);
        if (node instanceof LinkOrLinkReference) {
            LinkOrLinkReference ref = (LinkOrLinkReference)node;
            ref.label = label;
            ref.identifier = NormalizeIdentifier.normalizeIdentifier(this.sliceSerialize(token)).toLowerCase();
        } else if (node instanceof ImageOrImageReference) {
            ImageOrImageReference ref = (ImageOrImageReference)node;
            ref.label = label;
            ref.identifier = NormalizeIdentifier.normalizeIdentifier(this.sliceSerialize(token)).toLowerCase();
        } else {
            throw new IllegalStateException("Expected a link or image reference, but found: " + node);
        }
        this.referenceType = MdAstReferenceType.FULL;
    }

    private void onexitcharacterreferencemarker(MdastContext context, Token token) {
        this.characterReferenceType = switch (token.type) {
            case "characterReferenceMarkerHexadecimal" -> CharacterReferenceType.characterReferenceMarkerHexadecimal;
            case "characterReferenceMarkerNumeric" -> CharacterReferenceType.characterReferenceMarkerNumeric;
            default -> throw new IllegalStateException();
        };
    }

    private void onexitcharacterreferencevalue(MdastContext context, Token token) {
        String value;
        String data = this.sliceSerialize(token);
        CharacterReferenceType type = this.characterReferenceType;
        if (type != null) {
            value = NumericCharacterReference.decodeNumericCharacterReference(data, type == CharacterReferenceType.characterReferenceMarkerNumeric ? 10 : 16);
            this.characterReferenceType = null;
        } else {
            value = NamedCharacterEntities.decodeNamedCharacterReference(data);
        }
        MdAstNode tail = ListUtils.pop(this.stack);
        Assert.check(tail != null, "expected `node`");
        Assert.check(tail.position != null, "expected `node.position`");
        if (!(tail instanceof MdAstLiteral)) {
            throw new IllegalStateException("expected `node.value`");
        }
        MdAstLiteral literal = (MdAstLiteral)tail;
        literal.value = literal.value + value;
        literal.position.end = this.point(token.end);
    }

    private void onexitautolinkprotocol(MdastContext context, Token token) {
        this.onexitdata(this, token);
        MdAstLink node = (MdAstLink)this.stack.get(this.stack.size() - 1);
        node.url = this.sliceSerialize(token);
    }

    private void onexitautolinkemail(MdastContext context, Token token) {
        this.onexitdata(this, token);
        MdAstLink node = (MdAstLink)this.stack.get(this.stack.size() - 1);
        node.url = "mailto:" + this.sliceSerialize(token);
    }

    MdAstBlockquote blockQuote() {
        return new MdAstBlockquote();
    }

    MdAstCode codeFlow() {
        return new MdAstCode();
    }

    MdAstInlineCode codeText() {
        return new MdAstInlineCode();
    }

    MdAstDefinition definition() {
        return new MdAstDefinition();
    }

    MdAstEmphasis emphasis() {
        return new MdAstEmphasis();
    }

    MdAstHeading heading() {
        return new MdAstHeading();
    }

    MdAstBreak hardBreak() {
        return new MdAstBreak();
    }

    MdAstHTML html() {
        return new MdAstHTML();
    }

    MdAstImage image() {
        return new ImageOrImageReference();
    }

    MdAstLink link() {
        return new LinkOrLinkReference();
    }

    MdAstList list(Token token) {
        MdAstList list = new MdAstList();
        list.ordered = token.type.equals("listOrdered");
        list.spread = Boolean.TRUE.equals(token.get(SPREAD));
        return list;
    }

    MdAstListItem listItem(Token token) {
        MdAstListItem item = new MdAstListItem();
        item.spread = Boolean.TRUE.equals(token.get(SPREAD));
        return item;
    }

    MdAstParagraph paragraph() {
        return new MdAstParagraph();
    }

    MdAstStrong strong() {
        return new MdAstStrong();
    }

    MdAstText text() {
        return new MdAstText();
    }

    MdAstThematicBreak thematicBreak() {
        return new MdAstThematicBreak();
    }

    private void defaultOnError(MdastContext context, @Nullable Token left, Token right) {
        if (left != null) {
            throw new RuntimeException("Cannot close `" + left.type + "` (" + MdAstPosition.stringify(left.start, left.end) + "): a different token (`" + right.type + "`, " + MdAstPosition.stringify(right.start, right.end) + ") is open");
        }
        throw new RuntimeException("Cannot close document, a token (`" + right.type + "`, " + MdAstPosition.stringify(right.start, right.end) + ") is still open");
    }

    static class Fragment
    extends MdAstParent<MdAstPhrasingContent> {
        public Fragment() {
            super("fragment");
        }

        @Override
        protected Class<MdAstPhrasingContent> childClass() {
            return MdAstPhrasingContent.class;
        }
    }

    public static class LinkOrLinkReference
    extends MdAstLink {
        public String label;
        public String identifier;
    }

    public static class ImageOrImageReference
    extends MdAstImage {
        public String label;
        public String identifier;
    }

    static enum CharacterReferenceType {
        characterReferenceMarkerHexadecimal,
        characterReferenceMarkerNumeric;

    }
}

