/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.export;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

class SpriteFinder {
    private final Node root = new Node(0.5f, 0.5f, 0.25f);
    private final TextureAtlas spriteAtlasTexture;

    public SpriteFinder(Map<ResourceLocation, TextureAtlasSprite> sprites, TextureAtlas spriteAtlasTexture) {
        this.spriteAtlasTexture = spriteAtlasTexture;
        sprites.values().forEach(this.root::add);
    }

    public TextureAtlasSprite find(float u, float v) {
        return this.root.find(u, v);
    }

    private class Node {
        final float midU;
        final float midV;
        final float cellRadius;
        Object lowLow = null;
        Object lowHigh = null;
        Object highLow = null;
        Object highHigh = null;

        Node(float midU, float midV, float radius) {
            this.midU = midU;
            this.midV = midV;
            this.cellRadius = radius;
        }

        void add(TextureAtlasSprite sprite) {
            boolean highV;
            boolean lowU = sprite.m_118409_() < this.midU - 1.0E-5f;
            boolean highU = sprite.m_118410_() > this.midU + 1.0E-5f;
            boolean lowV = sprite.m_118411_() < this.midV - 1.0E-5f;
            boolean bl = highV = sprite.m_118412_() > this.midV + 1.0E-5f;
            if (lowU && lowV) {
                this.addInner(sprite, this.lowLow, -1, -1, q -> {
                    this.lowLow = q;
                });
            }
            if (lowU && highV) {
                this.addInner(sprite, this.lowHigh, -1, 1, q -> {
                    this.lowHigh = q;
                });
            }
            if (highU && lowV) {
                this.addInner(sprite, this.highLow, 1, -1, q -> {
                    this.highLow = q;
                });
            }
            if (highU && highV) {
                this.addInner(sprite, this.highHigh, 1, 1, q -> {
                    this.highHigh = q;
                });
            }
        }

        private void addInner(TextureAtlasSprite sprite, Object quadrant, int uStep, int vStep, Consumer<Object> setter) {
            if (quadrant == null) {
                setter.accept(sprite);
            } else if (quadrant instanceof Node) {
                Node node = (Node)quadrant;
                node.add(sprite);
            } else {
                Node n = new Node(this.midU + this.cellRadius * (float)uStep, this.midV + this.cellRadius * (float)vStep, this.cellRadius * 0.5f);
                if (quadrant instanceof TextureAtlasSprite) {
                    TextureAtlasSprite quadrantSprite = (TextureAtlasSprite)quadrant;
                    n.add(quadrantSprite);
                }
                n.add(sprite);
                setter.accept(n);
            }
        }

        private TextureAtlasSprite find(float u, float v) {
            if (u < this.midU) {
                return v < this.midV ? this.findInner(this.lowLow, u, v) : this.findInner(this.lowHigh, u, v);
            }
            return v < this.midV ? this.findInner(this.highLow, u, v) : this.findInner(this.highHigh, u, v);
        }

        private TextureAtlasSprite findInner(Object quadrant, float u, float v) {
            if (quadrant instanceof TextureAtlasSprite) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)quadrant;
                return sprite;
            }
            if (quadrant instanceof Node) {
                Node node = (Node)quadrant;
                return node.find(u, v);
            }
            return SpriteFinder.this.spriteAtlasTexture.m_118316_(MissingTextureAtlasSprite.m_118071_());
        }
    }
}

