/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;

public final class PagedBytes
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(PagedBytes.class);
    private byte[][] blocks = new byte[16][];
    private int numBlocks;
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private boolean didSkipBytes;
    private boolean frozen;
    private int upto;
    private byte[] currentBlock;
    private final long bytesUsedPerBlock;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public PagedBytes(int blockBits) {
        assert (blockBits > 0 && blockBits <= 31) : blockBits;
        this.blockSize = 1 << blockBits;
        this.blockBits = blockBits;
        this.blockMask = this.blockSize - 1;
        this.upto = this.blockSize;
        this.bytesUsedPerBlock = RamUsageEstimator.alignObjectSize(this.blockSize + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER);
        this.numBlocks = 0;
    }

    private void addBlock(byte[] block) {
        this.blocks = (byte[][])ArrayUtil.grow(this.blocks, this.numBlocks + 1);
        this.blocks[this.numBlocks++] = block;
    }

    public Reader freeze(boolean trim) {
        if (this.frozen) {
            throw new IllegalStateException("already frozen");
        }
        if (this.didSkipBytes) {
            throw new IllegalStateException("cannot freeze when copy(BytesRef, BytesRef) was used");
        }
        if (trim && this.upto < this.blockSize) {
            byte[] newBlock = new byte[this.upto];
            System.arraycopy(this.currentBlock, 0, newBlock, 0, this.upto);
            this.currentBlock = newBlock;
        }
        if (this.currentBlock == null) {
            this.currentBlock = EMPTY_BYTES;
        }
        this.addBlock(this.currentBlock);
        this.frozen = true;
        this.currentBlock = null;
        return new Reader(this);
    }

    @Override
    public long ramBytesUsed() {
        long size = BASE_RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf((Object[])this.blocks);
        if (this.numBlocks > 0) {
            size += (long)(this.numBlocks - 1) * this.bytesUsedPerBlock;
            size += RamUsageEstimator.sizeOf(this.blocks[this.numBlocks - 1]);
        }
        if (this.currentBlock != null) {
            size += RamUsageEstimator.sizeOf(this.currentBlock);
        }
        return size;
    }

    public PagedBytesDataInput getDataInput() {
        if (!this.frozen) {
            throw new IllegalStateException("must call freeze() before getDataInput");
        }
        return new PagedBytesDataInput();
    }

    public PagedBytesDataOutput getDataOutput() {
        if (this.frozen) {
            throw new IllegalStateException("cannot get DataOutput after freeze()");
        }
        return new PagedBytesDataOutput();
    }

    public final class PagedBytesDataOutput
    extends DataOutput {
        @Override
        public void writeByte(byte b) {
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    PagedBytes.this.addBlock(PagedBytes.this.currentBlock);
                }
                PagedBytes.this.currentBlock = new byte[PagedBytes.this.blockSize];
                PagedBytes.this.upto = 0;
            }
            PagedBytes.this.currentBlock[PagedBytes.this.upto++] = b;
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) {
            int left;
            int blockLeft;
            assert (b.length >= offset + length) : "b.length=" + b.length + " offset=" + offset + " length=" + length;
            if (length == 0) {
                return;
            }
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    PagedBytes.this.addBlock(PagedBytes.this.currentBlock);
                }
                PagedBytes.this.currentBlock = new byte[PagedBytes.this.blockSize];
                PagedBytes.this.upto = 0;
            }
            int offsetEnd = offset + length;
            while ((blockLeft = PagedBytes.this.blockSize - PagedBytes.this.upto) < (left = offsetEnd - offset)) {
                System.arraycopy(b, offset, PagedBytes.this.currentBlock, PagedBytes.this.upto, blockLeft);
                PagedBytes.this.addBlock(PagedBytes.this.currentBlock);
                PagedBytes.this.currentBlock = new byte[PagedBytes.this.blockSize];
                PagedBytes.this.upto = 0;
                offset += blockLeft;
            }
            System.arraycopy(b, offset, PagedBytes.this.currentBlock, PagedBytes.this.upto, left);
            PagedBytes.this.upto += left;
        }
    }

    public final class PagedBytesDataInput
    extends DataInput {
        private int currentBlockIndex;
        private int currentBlockUpto;
        private byte[] currentBlock;

        PagedBytesDataInput() {
            this.currentBlock = PagedBytes.this.blocks[0];
        }

        @Override
        public PagedBytesDataInput clone() {
            PagedBytesDataInput clone = PagedBytes.this.getDataInput();
            clone.setPosition(this.getPosition());
            return clone;
        }

        public long getPosition() {
            return (long)this.currentBlockIndex * (long)PagedBytes.this.blockSize + (long)this.currentBlockUpto;
        }

        public void setPosition(long pos) {
            this.currentBlockIndex = (int)(pos >> PagedBytes.this.blockBits);
            this.currentBlock = PagedBytes.this.blocks[this.currentBlockIndex];
            this.currentBlockUpto = (int)(pos & (long)PagedBytes.this.blockMask);
        }

        @Override
        public byte readByte() {
            if (this.currentBlockUpto == PagedBytes.this.blockSize) {
                this.nextBlock();
            }
            return this.currentBlock[this.currentBlockUpto++];
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) {
            int left;
            int blockLeft;
            assert (b.length >= offset + len);
            int offsetEnd = offset + len;
            while ((blockLeft = PagedBytes.this.blockSize - this.currentBlockUpto) < (left = offsetEnd - offset)) {
                System.arraycopy(this.currentBlock, this.currentBlockUpto, b, offset, blockLeft);
                this.nextBlock();
                offset += blockLeft;
            }
            System.arraycopy(this.currentBlock, this.currentBlockUpto, b, offset, left);
            this.currentBlockUpto += left;
        }

        @Override
        public void skipBytes(long numBytes) {
            if (numBytes < 0L) {
                throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
            }
            long skipTo = this.getPosition() + numBytes;
            this.setPosition(skipTo);
        }

        private void nextBlock() {
            ++this.currentBlockIndex;
            this.currentBlockUpto = 0;
            this.currentBlock = PagedBytes.this.blocks[this.currentBlockIndex];
        }
    }

    public static final class Reader
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Reader.class);
        private final byte[][] blocks;
        private final int blockBits;
        private final int blockMask;
        private final int blockSize;
        private final long bytesUsedPerBlock;

        private Reader(PagedBytes pagedBytes) {
            this.blocks = (byte[][])ArrayUtil.copyOfSubArray(pagedBytes.blocks, 0, pagedBytes.numBlocks);
            this.blockBits = pagedBytes.blockBits;
            this.blockMask = pagedBytes.blockMask;
            this.blockSize = pagedBytes.blockSize;
            this.bytesUsedPerBlock = pagedBytes.bytesUsedPerBlock;
        }

        public void fillSlice(BytesRef b, long start, int length) {
            assert (length >= 0) : "length=" + length;
            assert (length <= this.blockSize + 1) : "length=" + length;
            b.length = length;
            if (length == 0) {
                return;
            }
            int index = (int)(start >> this.blockBits);
            int offset = (int)(start & (long)this.blockMask);
            if (this.blockSize - offset >= length) {
                b.bytes = this.blocks[index];
                b.offset = offset;
            } else {
                b.bytes = new byte[length];
                b.offset = 0;
                System.arraycopy(this.blocks[index], offset, b.bytes, 0, this.blockSize - offset);
                System.arraycopy(this.blocks[1 + index], 0, b.bytes, this.blockSize - offset, length - (this.blockSize - offset));
            }
        }

        public byte getByte(long o) {
            int index = (int)(o >> this.blockBits);
            int offset = (int)(o & (long)this.blockMask);
            return this.blocks[index][offset];
        }

        @Override
        public long ramBytesUsed() {
            long size = BASE_RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf((Object[])this.blocks);
            if (this.blocks.length > 0) {
                size += (long)(this.blocks.length - 1) * this.bytesUsedPerBlock;
                size += RamUsageEstimator.sizeOf(this.blocks[this.blocks.length - 1]);
            }
            return size;
        }

        public String toString() {
            return "PagedBytes(blocksize=" + this.blockSize + ")";
        }
    }
}

