/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

public final class MathUtil {
    public static int log(long x, int base) {
        if (base == 2) {
            return x <= 0L ? 0 : 63 - Long.numberOfLeadingZeros(x);
        }
        if (base <= 1) {
            throw new IllegalArgumentException("base must be > 1");
        }
        int ret = 0;
        while (x >= (long)base) {
            x /= (long)base;
            ++ret;
        }
        return ret;
    }

    public static long gcd(long a, long b) {
        a = Math.abs(a);
        b = Math.abs(b);
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        int commonTrailingZeros = Long.numberOfTrailingZeros(a | b);
        a >>>= Long.numberOfTrailingZeros(a);
        while (a != (b >>>= Long.numberOfTrailingZeros(b))) {
            if (a > b || a == Long.MIN_VALUE) {
                long tmp = a;
                a = b;
                b = tmp;
            }
            if (a == 1L) break;
            b -= a;
        }
        return a << commonTrailingZeros;
    }

    public static double sumRelativeErrorBound(int numValues) {
        if (numValues <= 1) {
            return 0.0;
        }
        double u = Math.scalb(1.0, -52);
        return (double)(numValues - 1) * u;
    }

    public static double sumUpperBound(double sum, int numValues) {
        if (numValues <= 2) {
            return sum;
        }
        double b = MathUtil.sumRelativeErrorBound(numValues);
        return (1.0 + 2.0 * b) * sum;
    }
}

