/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.FilterDirectory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class TrackingDirectoryWrapper
extends FilterDirectory {
    private final Set<String> createdFileNames = Collections.synchronizedSet(new HashSet());

    public TrackingDirectoryWrapper(Directory in) {
        super(in);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.in.deleteFile(name);
        this.createdFileNames.remove(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        IndexOutput output = this.in.createOutput(name, context);
        this.createdFileNames.add(name);
        return output;
    }

    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        IndexOutput tempOutput = this.in.createTempOutput(prefix, suffix, context);
        this.createdFileNames.add(tempOutput.getName());
        return tempOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String source, String dest) throws IOException {
        this.in.rename(source, dest);
        Set<String> set = this.createdFileNames;
        synchronized (set) {
            this.createdFileNames.add(dest);
            this.createdFileNames.remove(source);
        }
    }

    public Set<String> getCreatedFiles() {
        return new HashSet<String>(this.createdFileNames);
    }

    public void clearCreatedFiles() {
        this.createdFileNames.clear();
    }
}

