/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.index.IndexFileNames;
import guideme.internal.shaded.lucene.store.FSDirectory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.MappedByteBufferIndexInputProvider;
import guideme.internal.shaded.lucene.util.Constants;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.Logger;

public class MMapDirectory
extends FSDirectory {
    private static final Logger LOG = Logger.getLogger(MMapDirectory.class.getName());
    public static final BiPredicate<String, IOContext> ALL_FILES = (filename, context) -> true;
    public static final BiPredicate<String, IOContext> NO_FILES = (filename, context) -> false;
    public static final Function<String, Optional<String>> NO_GROUPING = filename -> Optional.empty();
    public static final Function<String, Optional<String>> GROUP_BY_SEGMENT = filename -> {
        if (!IndexFileNames.CODEC_FILE_PATTERN.matcher((CharSequence)filename).matches()) {
            return Optional.empty();
        }
        Object groupKey = IndexFileNames.parseSegmentName(filename).substring(1);
        try {
            if (IndexFileNames.parseGeneration(filename) > 0L) {
                groupKey = (String)groupKey + "-g";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Optional.of(groupKey);
    };
    public static final BiPredicate<String, IOContext> BASED_ON_LOAD_IO_CONTEXT = (filename, context) -> context.load;
    private BiPredicate<String, IOContext> preload;
    public static final long DEFAULT_MAX_CHUNK_SIZE;
    final Object attachment;
    private Function<String, Optional<String>> groupingFunction;
    final int chunkSizePower;
    static final MMapIndexInputProvider<Object> PROVIDER;
    public static final boolean UNMAP_SUPPORTED;
    public static final String UNMAP_NOT_SUPPORTED_REASON;

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        this.ensureCanRead(name);
        Path path = this.directory.resolve(name);
        return PROVIDER.openInput(path, context, this.chunkSizePower, this.preload.test(name, context), this.groupingFunction.apply(name), this.attachment);
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    private static boolean checkMemorySegmentsSysprop() {
        try {
            return Optional.ofNullable(System.getProperty("guideme.internal.shaded.lucene.store.MMapDirectory.enableMemorySegments")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        }
        catch (SecurityException ignored) {
            LOG.warning("Cannot read sysprop org.apache.lucene.store.MMapDirectory.enableMemorySegments, so MemorySegments will be enabled by default, if possible.");
            return true;
        }
    }

    private static int getSharedArenaMaxPermitsSysprop() {
        int ret = 1024;
        try {
            String str = System.getProperty("guideme.internal.shaded.lucene.store.MMapDirectory.sharedArenaMaxPermits");
            if (str != null) {
                ret = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException | SecurityException ignored) {
            Logger.getLogger(MMapDirectory.class.getName()).warning("Cannot read sysprop org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits, so the default value will be used.");
        }
        return ret;
    }

    private static <A> MMapIndexInputProvider<A> lookupProvider() {
        if (!MMapDirectory.checkMemorySegmentsSysprop()) {
            return new MappedByteBufferIndexInputProvider();
        }
        int maxPermits = MMapDirectory.getSharedArenaMaxPermitsSysprop();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        int runtimeVersion = Runtime.version().feature();
        if (runtimeVersion >= 19) {
            try {
                Class<?> cls = lookup.findClass("guideme.internal.shaded.lucene.store.MemorySegmentIndexInputProvider");
                MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Integer.TYPE));
                try {
                    return constr.invoke(maxPermits);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new AssertionError((Object)th);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new LinkageError("MemorySegmentIndexInputProvider is missing correctly typed constructor", e);
            }
            catch (ClassNotFoundException cnfe) {
                throw new LinkageError("MemorySegmentIndexInputProvider is missing in Lucene JAR file", cnfe);
            }
        }
        return new MappedByteBufferIndexInputProvider();
    }

    static {
        PROVIDER = MMapDirectory.doPrivileged(MMapDirectory::lookupProvider);
        DEFAULT_MAX_CHUNK_SIZE = PROVIDER.getDefaultMaxChunkSize();
        UNMAP_SUPPORTED = PROVIDER.isUnmapSupported();
        UNMAP_NOT_SUPPORTED_REASON = PROVIDER.getUnmapNotSupportedReason();
    }

    static interface MMapIndexInputProvider<A> {
        public IndexInput openInput(Path var1, IOContext var2, int var3, boolean var4, Optional<String> var5, A var6) throws IOException;

        public long getDefaultMaxChunkSize();

        public boolean isUnmapSupported();

        public String getUnmapNotSupportedReason();

        default public IOException convertMapFailedIOException(IOException ioe, String resourceDescription, long bufSize) {
            Throwable originalCause;
            String originalMessage;
            if (ioe.getCause() instanceof OutOfMemoryError) {
                originalMessage = "Map failed";
                originalCause = null;
            } else {
                originalMessage = ioe.getMessage();
                originalCause = ioe.getCause();
            }
            String moreInfo = !Constants.JRE_IS_64BIT ? "MMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.WINDOWS ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.LINUX ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
            IOException newIoe = new IOException(String.format(Locale.ENGLISH, "%s: %s [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of %d bytes. %sMore information: https://blog.thetaphi.de/2012/07/use-lucenes-mmapdirectory-on-64bit.html]", originalMessage, resourceDescription, bufSize, moreInfo), originalCause);
            newIoe.setStackTrace(ioe.getStackTrace());
            return newIoe;
        }
    }
}

