/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.IndexReaderContext;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.ReaderUtil;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreQuery;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreWeight;
import guideme.internal.shaded.lucene.search.DocIdSet;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.LeafCollector;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryCache;
import guideme.internal.shaded.lucene.search.QueryCachingPolicy;
import guideme.internal.shaded.lucene.search.Scorable;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.BitDocIdSet;
import guideme.internal.shaded.lucene.util.FixedBitSet;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.RoaringDocIdSet;
import java.io.IOException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;

public class LRUQueryCache
implements QueryCache,
Accountable {
    private final int maxSize;
    private final long maxRamBytesUsed;
    private final Predicate<LeafReaderContext> leavesToCache;
    private final Map<Query, Query> uniqueQueries;
    private final Set<Query> mostRecentlyUsedQueries;
    private final Map<IndexReader.CacheKey, LeafCache> cache;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final float skipCacheFactor;
    private final LongAdder hitCount;
    private final LongAdder missCount;
    private volatile long ramBytesUsed;
    private volatile long cacheCount;
    private volatile long cacheSize;

    public LRUQueryCache(int maxSize, long maxRamBytesUsed, Predicate<LeafReaderContext> leavesToCache, float skipCacheFactor) {
        this.maxSize = maxSize;
        this.maxRamBytesUsed = maxRamBytesUsed;
        this.leavesToCache = leavesToCache;
        if (!(skipCacheFactor >= 1.0f)) {
            throw new IllegalArgumentException("skipCacheFactor must be no less than 1, get " + skipCacheFactor);
        }
        this.skipCacheFactor = skipCacheFactor;
        this.uniqueQueries = Collections.synchronizedMap(new LinkedHashMap(16, 0.75f, true));
        this.mostRecentlyUsedQueries = this.uniqueQueries.keySet();
        this.cache = new IdentityHashMap<IndexReader.CacheKey, LeafCache>();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.writeLock = lock.writeLock();
        this.readLock = lock.readLock();
        this.ramBytesUsed = 0L;
        this.hitCount = new LongAdder();
        this.missCount = new LongAdder();
    }

    public LRUQueryCache(int maxSize, long maxRamBytesUsed) {
        this(maxSize, maxRamBytesUsed, new MinSegmentSizePredicate(10000), 10.0f);
    }

    protected void onHit(Object readerCoreKey, Query query) {
        this.hitCount.add(1L);
    }

    protected void onMiss(Object readerCoreKey, Query query) {
        assert (query != null);
        this.missCount.add(1L);
    }

    protected void onQueryCache(Query query, long ramBytesUsed) {
        assert (this.writeLock.isHeldByCurrentThread());
        this.ramBytesUsed += ramBytesUsed;
    }

    protected void onQueryEviction(Query query, long ramBytesUsed) {
        assert (this.writeLock.isHeldByCurrentThread());
        this.ramBytesUsed -= ramBytesUsed;
    }

    protected void onDocIdSetCache(Object readerCoreKey, long ramBytesUsed) {
        assert (this.writeLock.isHeldByCurrentThread());
        ++this.cacheSize;
        ++this.cacheCount;
        this.ramBytesUsed += ramBytesUsed;
    }

    protected void onDocIdSetEviction(Object readerCoreKey, int numEntries, long sumRamBytesUsed) {
        assert (this.writeLock.isHeldByCurrentThread());
        this.ramBytesUsed -= sumRamBytesUsed;
        this.cacheSize -= (long)numEntries;
    }

    boolean requiresEviction() {
        assert (this.writeLock.isHeldByCurrentThread());
        int size = this.mostRecentlyUsedQueries.size();
        if (size == 0) {
            return false;
        }
        return size > this.maxSize || this.ramBytesUsed() > this.maxRamBytesUsed;
    }

    CacheAndCount get(Query key, IndexReader.CacheHelper cacheHelper) {
        assert (!(key instanceof BoostQuery));
        assert (!(key instanceof ConstantScoreQuery));
        IndexReader.CacheKey readerKey = cacheHelper.getKey();
        LeafCache leafCache = this.cache.get(readerKey);
        if (leafCache == null) {
            this.onMiss(readerKey, key);
            return null;
        }
        Query singleton = this.uniqueQueries.get(key);
        if (singleton == null) {
            this.onMiss(readerKey, key);
            return null;
        }
        CacheAndCount cached = leafCache.get(singleton);
        if (cached == null) {
            this.onMiss(readerKey, singleton);
        } else {
            this.onHit(readerKey, singleton);
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIfAbsent(Query query, CacheAndCount cached, IndexReader.CacheHelper cacheHelper) {
        assert (!(query instanceof BoostQuery));
        assert (!(query instanceof ConstantScoreQuery));
        this.writeLock.lock();
        try {
            Query singleton = this.uniqueQueries.putIfAbsent(query, query);
            if (singleton == null) {
                this.onQueryCache(query, LRUQueryCache.getRamBytesUsed(query));
            } else {
                query = singleton;
            }
            IndexReader.CacheKey key = cacheHelper.getKey();
            LeafCache leafCache = this.cache.get(key);
            if (leafCache == null) {
                leafCache = new LeafCache(key);
                LeafCache previous = this.cache.put(key, leafCache);
                this.ramBytesUsed += RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
                assert (previous == null);
                cacheHelper.addClosedListener(this::clearCoreCacheKey);
            }
            leafCache.putIfAbsent(query, cached);
            this.evictIfNecessary();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void evictIfNecessary() {
        assert (this.writeLock.isHeldByCurrentThread());
        if (this.requiresEviction()) {
            Iterator<Query> iterator = this.mostRecentlyUsedQueries.iterator();
            do {
                Query query = iterator.next();
                int size = this.mostRecentlyUsedQueries.size();
                iterator.remove();
                if (size == this.mostRecentlyUsedQueries.size()) {
                    throw new ConcurrentModificationException("Removal from the cache failed! This is probably due to a query which has been modified after having been put into  the cache or a badly implemented clone(). Query class: [" + query.getClass() + "], query: [" + query + "]");
                }
                this.onEviction(query);
            } while (iterator.hasNext() && this.requiresEviction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCoreCacheKey(Object coreKey) {
        this.writeLock.lock();
        try {
            LeafCache leafCache = this.cache.remove(coreKey);
            if (leafCache != null) {
                this.ramBytesUsed -= RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
                int numEntries = leafCache.cache.size();
                if (numEntries > 0) {
                    this.onDocIdSetEviction(coreKey, numEntries, leafCache.ramBytesUsed);
                } else {
                    assert (numEntries == 0);
                    assert (leafCache.ramBytesUsed == 0L);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void onEviction(Query singleton) {
        assert (this.writeLock.isHeldByCurrentThread());
        this.onQueryEviction(singleton, LRUQueryCache.getRamBytesUsed(singleton));
        for (LeafCache leafCache : this.cache.values()) {
            leafCache.remove(singleton);
        }
    }

    private static long getRamBytesUsed(Query query) {
        if (query instanceof Accountable) {
            return RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY + ((Accountable)((Object)query)).ramBytesUsed();
        }
        return RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY + 1024L;
    }

    @Override
    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        while (weight instanceof CachingWrapperWeight) {
            weight = ((CachingWrapperWeight)weight).in;
        }
        return new CachingWrapperWeight(weight, policy);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    protected CacheAndCount cacheImpl(BulkScorer scorer, int maxDoc) throws IOException {
        if (scorer.cost() * 100L >= (long)maxDoc) {
            return LRUQueryCache.cacheIntoBitSet(scorer, maxDoc);
        }
        return LRUQueryCache.cacheIntoRoaringDocIdSet(scorer, maxDoc);
    }

    private static CacheAndCount cacheIntoBitSet(BulkScorer scorer, int maxDoc) throws IOException {
        final FixedBitSet bitSet = new FixedBitSet(maxDoc);
        final int[] count = new int[1];
        scorer.score(new LeafCollector(){

            @Override
            public void setScorer(Scorable scorer) throws IOException {
            }

            @Override
            public void collect(int doc) throws IOException {
                count[0] = count[0] + 1;
                bitSet.set(doc);
            }
        }, null);
        return new CacheAndCount(new BitDocIdSet(bitSet, count[0]), count[0]);
    }

    private static CacheAndCount cacheIntoRoaringDocIdSet(BulkScorer scorer, int maxDoc) throws IOException {
        final RoaringDocIdSet.Builder builder = new RoaringDocIdSet.Builder(maxDoc);
        scorer.score(new LeafCollector(){

            @Override
            public void setScorer(Scorable scorer) throws IOException {
            }

            @Override
            public void collect(int doc) throws IOException {
                builder.add(doc);
            }
        }, null);
        RoaringDocIdSet cache = builder.build();
        return new CacheAndCount(cache, cache.cardinality());
    }

    protected static class CacheAndCount
    implements Accountable {
        protected static final CacheAndCount EMPTY = new CacheAndCount(DocIdSet.EMPTY, 0);
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CacheAndCount.class);
        private final DocIdSet cache;
        private final int count;

        public CacheAndCount(DocIdSet cache, int count) {
            this.cache = cache;
            this.count = count;
        }

        public DocIdSetIterator iterator() throws IOException {
            return this.cache.iterator();
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + this.cache.ramBytesUsed();
        }
    }

    private class CachingWrapperWeight
    extends ConstantScoreWeight {
        private final Weight in;
        private final QueryCachingPolicy policy;
        private final AtomicBoolean used;

        CachingWrapperWeight(Weight in, QueryCachingPolicy policy) {
            super(in.getQuery(), 1.0f);
            this.in = in;
            this.policy = policy;
            this.used = new AtomicBoolean(false);
        }

        private boolean cacheEntryHasReasonableWorstCaseSize(int maxDoc) {
            long worstCaseRamUsage = maxDoc / 8;
            long totalRamAvailable = LRUQueryCache.this.maxRamBytesUsed;
            return worstCaseRamUsage * 5L < totalRamAvailable;
        }

        private CacheAndCount cache(LeafReaderContext context) throws IOException {
            BulkScorer scorer = this.in.bulkScorer(context);
            if (scorer == null) {
                return CacheAndCount.EMPTY;
            }
            return LRUQueryCache.this.cacheImpl(scorer, context.reader().maxDoc());
        }

        private boolean shouldCache(LeafReaderContext context) throws IOException {
            return this.cacheEntryHasReasonableWorstCaseSize(ReaderUtil.getTopLevelContext(context).reader().maxDoc()) && LRUQueryCache.this.leavesToCache.test(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
            CacheAndCount cached;
            if (this.used.compareAndSet(false, true)) {
                this.policy.onUse(this.getQuery());
            }
            if (!this.in.isCacheable(context)) {
                return this.in.scorerSupplier(context);
            }
            if (!this.shouldCache(context)) {
                return this.in.scorerSupplier(context);
            }
            final IndexReader.CacheHelper cacheHelper = context.reader().getCoreCacheHelper();
            if (cacheHelper == null) {
                return this.in.scorerSupplier(context);
            }
            if (!LRUQueryCache.this.readLock.tryLock()) {
                return this.in.scorerSupplier(context);
            }
            try {
                cached = LRUQueryCache.this.get(this.in.getQuery(), cacheHelper);
            }
            finally {
                LRUQueryCache.this.readLock.unlock();
            }
            if (cached == null) {
                if (this.policy.shouldCache(this.in.getQuery())) {
                    final ScorerSupplier supplier = this.in.scorerSupplier(context);
                    if (supplier == null) {
                        LRUQueryCache.this.putIfAbsent(this.in.getQuery(), CacheAndCount.EMPTY, cacheHelper);
                        return null;
                    }
                    final long cost = supplier.cost();
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            if ((float)cost / LRUQueryCache.this.skipCacheFactor > (float)leadCost) {
                                return supplier.get(leadCost);
                            }
                            Scorer scorer = supplier.get(Long.MAX_VALUE);
                            CacheAndCount cached = LRUQueryCache.this.cacheImpl(new Weight.DefaultBulkScorer(scorer), context.reader().maxDoc());
                            LRUQueryCache.this.putIfAbsent(CachingWrapperWeight.this.in.getQuery(), cached, cacheHelper);
                            DocIdSetIterator disi = cached.iterator();
                            if (disi == null) {
                                disi = DocIdSetIterator.empty();
                            }
                            return new ConstantScoreScorer((Weight)CachingWrapperWeight.this, 0.0f, ScoreMode.COMPLETE_NO_SCORES, disi);
                        }

                        @Override
                        public long cost() {
                            return cost;
                        }
                    };
                }
                return this.in.scorerSupplier(context);
            }
            assert (cached != null);
            if (cached == CacheAndCount.EMPTY) {
                return null;
            }
            final DocIdSetIterator disi = cached.iterator();
            if (disi == null) {
                return null;
            }
            return new ScorerSupplier(){

                @Override
                public Scorer get(long LeadCost) throws IOException {
                    return new ConstantScoreScorer((Weight)CachingWrapperWeight.this, 0.0f, ScoreMode.COMPLETE_NO_SCORES, disi);
                }

                @Override
                public long cost() {
                    return disi.cost();
                }
            };
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            ScorerSupplier scorerSupplier = this.scorerSupplier(context);
            if (scorerSupplier == null) {
                return null;
            }
            return scorerSupplier.get(Long.MAX_VALUE);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.in.isCacheable(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
            CacheAndCount cached;
            if (this.used.compareAndSet(false, true)) {
                this.policy.onUse(this.getQuery());
            }
            if (!this.in.isCacheable(context)) {
                return this.in.bulkScorer(context);
            }
            if (!this.shouldCache(context)) {
                return this.in.bulkScorer(context);
            }
            IndexReader.CacheHelper cacheHelper = context.reader().getCoreCacheHelper();
            if (cacheHelper == null) {
                return this.in.bulkScorer(context);
            }
            if (!LRUQueryCache.this.readLock.tryLock()) {
                return this.in.bulkScorer(context);
            }
            try {
                cached = LRUQueryCache.this.get(this.in.getQuery(), cacheHelper);
            }
            finally {
                LRUQueryCache.this.readLock.unlock();
            }
            if (cached == null) {
                if (this.policy.shouldCache(this.in.getQuery())) {
                    cached = this.cache(context);
                    LRUQueryCache.this.putIfAbsent(this.in.getQuery(), cached, cacheHelper);
                } else {
                    return this.in.bulkScorer(context);
                }
            }
            assert (cached != null);
            if (cached == CacheAndCount.EMPTY) {
                return null;
            }
            DocIdSetIterator disi = cached.iterator();
            if (disi == null) {
                return null;
            }
            return new Weight.DefaultBulkScorer(new ConstantScoreScorer((Weight)this, 0.0f, ScoreMode.COMPLETE_NO_SCORES, disi));
        }
    }

    private class LeafCache
    implements Accountable {
        private final Object key;
        private final Map<Query, CacheAndCount> cache;
        private volatile long ramBytesUsed;

        LeafCache(Object key) {
            this.key = key;
            this.cache = new IdentityHashMap<Query, CacheAndCount>();
            this.ramBytesUsed = 0L;
        }

        private void onDocIdSetCache(long ramBytesUsed) {
            assert (LRUQueryCache.this.writeLock.isHeldByCurrentThread());
            this.ramBytesUsed += ramBytesUsed;
            LRUQueryCache.this.onDocIdSetCache(this.key, ramBytesUsed);
        }

        private void onDocIdSetEviction(long ramBytesUsed) {
            assert (LRUQueryCache.this.writeLock.isHeldByCurrentThread());
            this.ramBytesUsed -= ramBytesUsed;
            LRUQueryCache.this.onDocIdSetEviction(this.key, 1, ramBytesUsed);
        }

        CacheAndCount get(Query query) {
            assert (!(query instanceof BoostQuery));
            assert (!(query instanceof ConstantScoreQuery));
            return this.cache.get(query);
        }

        void putIfAbsent(Query query, CacheAndCount cached) {
            assert (LRUQueryCache.this.writeLock.isHeldByCurrentThread());
            assert (!(query instanceof BoostQuery));
            assert (!(query instanceof ConstantScoreQuery));
            if (this.cache.putIfAbsent(query, cached) == null) {
                this.onDocIdSetCache(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + cached.ramBytesUsed());
            }
        }

        void remove(Query query) {
            assert (LRUQueryCache.this.writeLock.isHeldByCurrentThread());
            assert (!(query instanceof BoostQuery));
            assert (!(query instanceof ConstantScoreQuery));
            CacheAndCount removed = this.cache.remove(query);
            if (removed != null) {
                this.onDocIdSetEviction(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + removed.ramBytesUsed());
            }
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }
    }

    static class MinSegmentSizePredicate
    implements Predicate<LeafReaderContext> {
        private final int minSize;

        MinSegmentSizePredicate(int minSize) {
            this.minSize = minSize;
        }

        @Override
        public boolean test(LeafReaderContext context) {
            int maxDoc = context.reader().maxDoc();
            if (maxDoc < this.minSize) {
                return false;
            }
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(context);
            int averageTotalDocs = topLevelContext.reader().maxDoc() / topLevelContext.leaves().size();
            return maxDoc * 2 > averageTotalDocs;
        }
    }
}

