/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.Impact;
import guideme.internal.shaded.lucene.index.Impacts;
import guideme.internal.shaded.lucene.index.ImpactsEnum;
import guideme.internal.shaded.lucene.index.ImpactsSource;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.search.ConjunctionUtils;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.ImpactsDISI;
import guideme.internal.shaded.lucene.search.MaxScoreCache;
import guideme.internal.shaded.lucene.search.PhraseMatcher;
import guideme.internal.shaded.lucene.search.PhraseQuery;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class ExactPhraseMatcher
extends PhraseMatcher {
    private final PostingsAndPosition[] postings;
    private final DocIdSetIterator approximation;
    private final ImpactsDISI impactsApproximation;

    public ExactPhraseMatcher(PhraseQuery.PostingsAndFreq[] postings, ScoreMode scoreMode, Similarity.SimScorer scorer, float matchCost) {
        super(matchCost);
        DocIdSetIterator approximation = ConjunctionUtils.intersectIterators(Arrays.stream(postings).map(p -> p.postings).collect(Collectors.toList()));
        ImpactsSource impactsSource = ExactPhraseMatcher.mergeImpacts((ImpactsEnum[])Arrays.stream(postings).map(p -> p.impacts).toArray(ImpactsEnum[]::new));
        this.impactsApproximation = new ImpactsDISI(approximation, new MaxScoreCache(impactsSource, scorer));
        this.approximation = scoreMode == ScoreMode.TOP_SCORES ? this.impactsApproximation : approximation;
        ArrayList<PostingsAndPosition> postingsAndPositions = new ArrayList<PostingsAndPosition>();
        for (PhraseQuery.PostingsAndFreq posting : postings) {
            postingsAndPositions.add(new PostingsAndPosition(posting.postings, posting.position));
        }
        this.postings = postingsAndPositions.toArray(new PostingsAndPosition[postingsAndPositions.size()]);
    }

    @Override
    DocIdSetIterator approximation() {
        return this.approximation;
    }

    @Override
    ImpactsDISI impactsApproximation() {
        return this.impactsApproximation;
    }

    @Override
    float maxFreq() {
        int minFreq = this.postings[0].freq;
        for (int i = 1; i < this.postings.length; ++i) {
            minFreq = Math.min(minFreq, this.postings[i].freq);
        }
        return minFreq;
    }

    private static boolean advancePosition(PostingsAndPosition posting, int target) throws IOException {
        while (posting.pos < target) {
            if (posting.upTo == posting.freq) {
                return false;
            }
            posting.pos = posting.postings.nextPosition();
            ++posting.upTo;
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        for (PostingsAndPosition posting : this.postings) {
            posting.freq = posting.postings.freq();
            posting.pos = -1;
            posting.upTo = 0;
        }
    }

    @Override
    public boolean nextMatch() throws IOException {
        block6: {
            PostingsAndPosition lead = this.postings[0];
            if (lead.upTo < lead.freq) {
                lead.pos = lead.postings.nextPosition();
                ++lead.upTo;
            } else {
                return false;
            }
            block0: while (true) {
                int phrasePos = lead.pos - lead.offset;
                for (int j = 1; j < this.postings.length; ++j) {
                    PostingsAndPosition posting = this.postings[j];
                    int expectedPos = phrasePos + posting.offset;
                    if (ExactPhraseMatcher.advancePosition(posting, expectedPos)) {
                        if (posting.pos == expectedPos) continue;
                        if (ExactPhraseMatcher.advancePosition(lead, posting.pos - posting.offset + lead.offset)) {
                            continue block0;
                        }
                    }
                    break block6;
                }
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    float sloppyWeight() {
        return 1.0f;
    }

    static ImpactsSource mergeImpacts(final ImpactsEnum[] impactsEnums) {
        int tmpLeadIndex = -1;
        for (int i = 0; i < impactsEnums.length; ++i) {
            if (tmpLeadIndex != -1 && impactsEnums[i].cost() >= impactsEnums[tmpLeadIndex].cost()) continue;
            tmpLeadIndex = i;
        }
        final int leadIndex = tmpLeadIndex;
        return new ImpactsSource(){

            @Override
            public Impacts getImpacts() throws IOException {
                final Impacts[] impacts = new Impacts[impactsEnums.length];
                for (int i = 0; i < impactsEnums.length; ++i) {
                    impacts[i] = impactsEnums[i].getImpacts();
                }
                final Impacts lead = impacts[leadIndex];
                return new Impacts(){

                    @Override
                    public int numLevels() {
                        return lead.numLevels();
                    }

                    @Override
                    public int getDocIdUpTo(int level) {
                        return lead.getDocIdUpTo(level);
                    }

                    private int getLevel(Impacts impacts2, int docIdUpTo) {
                        int numLevels = impacts2.numLevels();
                        for (int level = 0; level < numLevels; ++level) {
                            if (impacts2.getDocIdUpTo(level) < docIdUpTo) continue;
                            return level;
                        }
                        return -1;
                    }

                    @Override
                    public List<Impact> getImpacts(int level) {
                        int docIdUpTo = this.getDocIdUpTo(level);
                        PriorityQueue<SubIterator> pq = new PriorityQueue<SubIterator>(impacts.length){

                            @Override
                            protected boolean lessThan(SubIterator a, SubIterator b) {
                                return a.current.freq < b.current.freq;
                            }
                        };
                        boolean hasImpacts = false;
                        List<Impact> onlyImpactList = null;
                        ArrayList<SubIterator> subIterators = new ArrayList<SubIterator>(impacts.length);
                        for (int i = 0; i < impacts.length; ++i) {
                            int impactsLevel = this.getLevel(impacts[i], docIdUpTo);
                            if (impactsLevel == -1) continue;
                            List<Impact> impactList = impacts[i].getImpacts(impactsLevel);
                            Impact firstImpact = impactList.get(0);
                            if (firstImpact.freq == Integer.MAX_VALUE && firstImpact.norm == 1L) continue;
                            SubIterator subIterator = new SubIterator(impactList);
                            subIterators.add(subIterator);
                            if (!hasImpacts) {
                                hasImpacts = true;
                                onlyImpactList = impactList;
                                continue;
                            }
                            onlyImpactList = null;
                        }
                        if (!hasImpacts) {
                            return Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L));
                        }
                        if (onlyImpactList != null) {
                            return onlyImpactList;
                        }
                        pq.addAll(subIterators);
                        ArrayList<Impact> mergedImpacts = new ArrayList<Impact>();
                        SubIterator top = (SubIterator)pq.top();
                        int currentFreq = top.current.freq;
                        long currentNorm = 0L;
                        for (SubIterator it : pq) {
                            if (Long.compareUnsigned(it.current.norm, currentNorm) <= 0) continue;
                            currentNorm = it.current.norm;
                        }
                        block2: while (true) {
                            if (mergedImpacts.size() > 0 && ((Impact)mergedImpacts.get((int)(mergedImpacts.size() - 1))).norm == currentNorm) {
                                ((Impact)mergedImpacts.get((int)(mergedImpacts.size() - 1))).freq = currentFreq;
                            } else {
                                mergedImpacts.add(new Impact(currentFreq, currentNorm));
                            }
                            while (top.next()) {
                                if (Long.compareUnsigned(top.current.norm, currentNorm) > 0) {
                                    currentNorm = top.current.norm;
                                }
                                top = (SubIterator)pq.updateTop();
                                if (top.current.freq == currentFreq) continue;
                                currentFreq = top.current.freq;
                                continue block2;
                            }
                            break;
                        }
                        return mergedImpacts;
                    }
                };
            }

            @Override
            public void advanceShallow(int target) throws IOException {
                for (ImpactsEnum impactsEnum : impactsEnums) {
                    impactsEnum.advanceShallow(target);
                }
            }

            class SubIterator {
                final Iterator<Impact> iterator;
                Impact current;

                SubIterator(List<Impact> impacts) {
                    this.iterator = impacts.iterator();
                    this.current = this.iterator.next();
                }

                boolean next() {
                    if (!this.iterator.hasNext()) {
                        this.current = null;
                        return false;
                    }
                    this.current = this.iterator.next();
                    return true;
                }
            }
        };
    }

    private static class PostingsAndPosition {
        private final PostingsEnum postings;
        private final int offset;
        private int freq;
        private int upTo;
        private int pos;

        public PostingsAndPosition(PostingsEnum postings, int offset) {
            this.postings = postings;
            this.offset = offset;
        }
    }
}

