/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.BlockMaxConjunctionBulkScorer;
import guideme.internal.shaded.lucene.search.BlockMaxConjunctionScorer;
import guideme.internal.shaded.lucene.search.Boolean2ScorerSupplier;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.BooleanScorer;
import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.ConjunctionBulkScorer;
import guideme.internal.shaded.lucene.search.ConjunctionScorer;
import guideme.internal.shaded.lucene.search.DisjunctionSumScorer;
import guideme.internal.shaded.lucene.search.FilterScorer;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.LeafCollector;
import guideme.internal.shaded.lucene.search.MaxScoreBulkScorer;
import guideme.internal.shaded.lucene.search.ReqExclBulkScorer;
import guideme.internal.shaded.lucene.search.Scorable;
import guideme.internal.shaded.lucene.search.ScoreAndDoc;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.Bits;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;

final class BooleanWeight
extends Weight {
    final Similarity similarity;
    final BooleanQuery query;
    final ArrayList<WeightedBooleanClause> weightedClauses;
    final ScoreMode scoreMode;

    BooleanWeight(BooleanQuery query, IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        super(query);
        this.query = query;
        this.scoreMode = scoreMode;
        this.similarity = searcher.getSimilarity();
        this.weightedClauses = new ArrayList();
        for (BooleanClause c : query) {
            Weight w = searcher.createWeight(c.getQuery(), c.isScoring() ? scoreMode : ScoreMode.COMPLETE_NO_SCORES, boost);
            this.weightedClauses.add(new WeightedBooleanClause(c, w));
        }
    }

    static BulkScorer disableScoring(final BulkScorer scorer) {
        Objects.requireNonNull(scorer);
        return new BulkScorer(){

            @Override
            public int score(final LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
                LeafCollector noScoreCollector = new LeafCollector(){
                    ScoreAndDoc fake = new ScoreAndDoc();

                    @Override
                    public void setScorer(Scorable scorer) throws IOException {
                        collector.setScorer(this.fake);
                    }

                    @Override
                    public void collect(int doc) throws IOException {
                        this.fake.doc = doc;
                        collector.collect(doc);
                    }
                };
                return scorer.score(noScoreCollector, acceptDocs, min, max);
            }

            @Override
            public long cost() {
                return scorer.cost();
            }
        };
    }

    BulkScorer optionalBulkScorer(LeafReaderContext context) throws IOException {
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            if (!this.query.isPureDisjunction()) {
                return null;
            }
            ArrayList<ScorerSupplier> optional = new ArrayList<ScorerSupplier>();
            for (WeightedBooleanClause weightedBooleanClause : this.weightedClauses) {
                ScorerSupplier scorer;
                Weight w = weightedBooleanClause.weight;
                BooleanClause c = weightedBooleanClause.clause;
                if (c.getOccur() != BooleanClause.Occur.SHOULD || (scorer = w.scorerSupplier(context)) == null) continue;
                optional.add(scorer);
            }
            if (optional.size() <= 1) {
                return null;
            }
            ArrayList<Scorer> optionalScorers = new ArrayList<Scorer>();
            for (ScorerSupplier ss : optional) {
                optionalScorers.add(ss.get(Long.MAX_VALUE));
            }
            return new MaxScoreBulkScorer(context.reader().maxDoc(), optionalScorers);
        }
        ArrayList<BulkScorer> optional = new ArrayList<BulkScorer>();
        for (WeightedBooleanClause weightedBooleanClause : this.weightedClauses) {
            BulkScorer subScorer;
            Weight w = weightedBooleanClause.weight;
            BooleanClause c = weightedBooleanClause.clause;
            if (c.getOccur() != BooleanClause.Occur.SHOULD || (subScorer = w.bulkScorer(context)) == null) continue;
            optional.add(subScorer);
        }
        if (optional.size() == 0) {
            return null;
        }
        if (this.query.getMinimumNumberShouldMatch() > optional.size()) {
            return null;
        }
        if (optional.size() == 1) {
            return (BulkScorer)optional.get(0);
        }
        return new BooleanScorer(this, optional, Math.max(1, this.query.getMinimumNumberShouldMatch()), this.scoreMode.needsScores());
    }

    /*
     * WARNING - void declaration
     */
    private BulkScorer requiredBulkScorer(LeafReaderContext context) throws IOException {
        void var9_20;
        void var8_11;
        ArrayList<WeightedBooleanClause> requiredClauses = new ArrayList<WeightedBooleanClause>();
        for (WeightedBooleanClause wc : this.weightedClauses) {
            if (!wc.clause.isRequired()) continue;
            requiredClauses.add(wc);
        }
        if (requiredClauses.isEmpty()) {
            return null;
        }
        if (requiredClauses.size() == 1) {
            WeightedBooleanClause clause = (WeightedBooleanClause)requiredClauses.get(0);
            BulkScorer scorer = clause.weight.bulkScorer(context);
            if (scorer == null) {
                return null;
            }
            if (!clause.clause.isScoring() && this.scoreMode.needsScores()) {
                scorer = BooleanWeight.disableScoring(scorer);
            }
            return scorer;
        }
        ArrayList<ScorerSupplier> requiredNoScoringSupplier = new ArrayList<ScorerSupplier>();
        ArrayList<ScorerSupplier> requiredScoringSupplier = new ArrayList<ScorerSupplier>();
        long leadCost = Long.MAX_VALUE;
        for (WeightedBooleanClause weightedBooleanClause : requiredClauses) {
            Weight weight = weightedBooleanClause.weight;
            BooleanClause c = weightedBooleanClause.clause;
            ScorerSupplier scorerSupplier = weight.scorerSupplier(context);
            if (scorerSupplier == null) {
                return null;
            }
            leadCost = Math.min(leadCost, scorerSupplier.cost());
            if (c.isScoring() && this.scoreMode.needsScores()) {
                requiredScoringSupplier.add(scorerSupplier);
                continue;
            }
            requiredNoScoringSupplier.add(scorerSupplier);
        }
        ArrayList<Scorer> requiredNoScoring = new ArrayList<Scorer>();
        for (ScorerSupplier scorerSupplier : requiredNoScoringSupplier) {
            requiredNoScoring.add(scorerSupplier.get(leadCost));
        }
        ArrayList<Scorer> arrayList = new ArrayList<Scorer>();
        for (ScorerSupplier ss : requiredScoringSupplier) {
            if (requiredScoringSupplier.size() == 1) {
                ss.setTopLevelScoringClause();
            }
            arrayList.add(ss.get(leadCost));
        }
        if (this.scoreMode == ScoreMode.TOP_SCORES && requiredNoScoringSupplier.isEmpty() && arrayList.size() > 1 && arrayList.stream().map(Scorer::twoPhaseIterator).allMatch(Objects::isNull)) {
            return new BlockMaxConjunctionBulkScorer(context.reader().maxDoc(), arrayList);
        }
        if (this.scoreMode != ScoreMode.TOP_SCORES && arrayList.size() + requiredNoScoring.size() >= 2 && arrayList.stream().map(Scorer::twoPhaseIterator).allMatch(Objects::isNull) && requiredNoScoring.stream().map(Scorer::twoPhaseIterator).allMatch(Objects::isNull)) {
            return new ConjunctionBulkScorer(arrayList, requiredNoScoring);
        }
        if (this.scoreMode == ScoreMode.TOP_SCORES && arrayList.size() > 1) {
            List<BlockMaxConjunctionScorer> list = Collections.singletonList(new BlockMaxConjunctionScorer(this, arrayList));
        }
        if (requiredNoScoring.size() + var8_11.size() == 1) {
            if (var8_11.size() == 1) {
                Scorer scorer = (Scorer)var8_11.get(0);
            } else {
                Scorer scorer = (Scorer)requiredNoScoring.get(0);
                if (this.scoreMode.needsScores()) {
                    Scorer inner = scorer;
                    FilterScorer filterScorer = new FilterScorer(inner){

                        @Override
                        public float score() throws IOException {
                            return 0.0f;
                        }

                        @Override
                        public float getMaxScore(int upTo) throws IOException {
                            return 0.0f;
                        }
                    };
                }
            }
        } else {
            ArrayList<Scorer> required = new ArrayList<Scorer>();
            required.addAll((Collection<Scorer>)var8_11);
            required.addAll(requiredNoScoring);
            ConjunctionScorer conjunctionScorer = new ConjunctionScorer(this, required, (Collection<Scorer>)var8_11);
        }
        return new Weight.DefaultBulkScorer((Scorer)var9_20);
    }

    BulkScorer booleanScorer(LeafReaderContext context) throws IOException {
        Scorer prohibitedScorer;
        BulkScorer positiveScorer;
        int numOptionalClauses = this.query.getClauses(BooleanClause.Occur.SHOULD).size();
        int numRequiredClauses = this.query.getClauses(BooleanClause.Occur.MUST).size() + this.query.getClauses(BooleanClause.Occur.FILTER).size();
        if (numRequiredClauses == 0) {
            positiveScorer = this.optionalBulkScorer(context);
            if (positiveScorer == null) {
                return null;
            }
            long costThreshold = this.query.getMinimumNumberShouldMatch() <= 1 ? -1L : (long)(context.reader().maxDoc() / 3);
            if (positiveScorer.cost() < costThreshold) {
                return null;
            }
        } else if (numRequiredClauses > 0 && numOptionalClauses == 0 && this.query.getMinimumNumberShouldMatch() == 0) {
            positiveScorer = this.requiredBulkScorer(context);
        } else {
            return null;
        }
        if (positiveScorer == null) {
            return null;
        }
        ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Scorer scorer;
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            if (!c.isProhibited() || (scorer = w.scorer(context)) == null) continue;
            prohibited.add(scorer);
        }
        if (prohibited.isEmpty()) {
            return positiveScorer;
        }
        Scorer scorer = prohibitedScorer = prohibited.size() == 1 ? (Scorer)prohibited.get(0) : new DisjunctionSumScorer(this, prohibited, ScoreMode.COMPLETE_NO_SCORES);
        if (prohibitedScorer.twoPhaseIterator() != null) {
            return null;
        }
        return new ReqExclBulkScorer(positiveScorer, prohibitedScorer.iterator());
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer bulkScorer = this.booleanScorer(context);
        if (bulkScorer != null) {
            return bulkScorer;
        }
        return super.bulkScorer(context);
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context);
        if (scorerSupplier == null) {
            return null;
        }
        return scorerSupplier.get(Long.MAX_VALUE);
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        if (this.query.clauses().size() > 16) {
            return false;
        }
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            if (w.isCacheable(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>> scorers = new EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>>(BooleanClause.Occur.class);
        for (BooleanClause.Occur occur : BooleanClause.Occur.values()) {
            scorers.put(occur, new ArrayList());
        }
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            ScorerSupplier subScorer = w.scorerSupplier(context);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            ((Collection)scorers.get((Object)c.getOccur())).add(subScorer);
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() == minShouldMatch) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).addAll((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD));
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
            minShouldMatch = 0;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).isEmpty()) {
            return null;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() < minShouldMatch) {
            return null;
        }
        if (!this.scoreMode.needsScores() && minShouldMatch == 0 && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).size() + ((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).size() > 0) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
        }
        return new Boolean2ScorerSupplier(this, scorers, this.scoreMode, minShouldMatch);
    }

    protected static class WeightedBooleanClause {
        final BooleanClause clause;
        final Weight weight;

        WeightedBooleanClause(BooleanClause clause, Weight weight) {
            this.clause = clause;
            this.weight = weight;
        }
    }
}

