/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.BooleanWeight;
import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.CheckedIntConsumer;
import guideme.internal.shaded.lucene.search.DocIdStream;
import guideme.internal.shaded.lucene.search.LeafCollector;
import guideme.internal.shaded.lucene.search.Scorable;
import guideme.internal.shaded.lucene.search.ScoreAndDoc;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

final class BooleanScorer
extends BulkScorer {
    final Bucket[] buckets;
    final long[] matching = new long[64];
    final BulkScorerAndDoc[] leads;
    final HeadPriorityQueue head;
    final TailPriorityQueue tail;
    final ScoreAndDoc scoreAndDoc = new ScoreAndDoc();
    final int minShouldMatch;
    final long cost;
    final boolean needsScores;
    final OrCollector orCollector = new OrCollector();
    private final DocIdStreamView docIdStreamView = new DocIdStreamView();

    private static long cost(Collection<BulkScorer> scorers, int minShouldMatch) {
        PriorityQueue<BulkScorer> pq = new PriorityQueue<BulkScorer>(scorers.size() - minShouldMatch + 1){

            @Override
            protected boolean lessThan(BulkScorer a, BulkScorer b) {
                return a.cost() > b.cost();
            }
        };
        for (BulkScorer scorer : scorers) {
            pq.insertWithOverflow(scorer);
        }
        long cost = 0L;
        BulkScorer scorer = (BulkScorer)pq.pop();
        while (scorer != null) {
            cost += scorer.cost();
            scorer = (BulkScorer)pq.pop();
        }
        return cost;
    }

    BooleanScorer(BooleanWeight weight, Collection<BulkScorer> scorers, int minShouldMatch, boolean needsScores) {
        if (minShouldMatch < 1 || minShouldMatch > scorers.size()) {
            throw new IllegalArgumentException("minShouldMatch should be within 1..num_scorers. Got " + minShouldMatch);
        }
        if (scorers.size() <= 1) {
            throw new IllegalArgumentException("This scorer can only be used with two scorers or more, got " + scorers.size());
        }
        if (needsScores || minShouldMatch > 1) {
            this.buckets = new Bucket[4096];
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i] = new Bucket();
            }
        } else {
            this.buckets = null;
        }
        this.leads = new BulkScorerAndDoc[scorers.size()];
        this.head = new HeadPriorityQueue(scorers.size() - minShouldMatch + 1);
        this.tail = new TailPriorityQueue(minShouldMatch - 1);
        this.minShouldMatch = minShouldMatch;
        this.needsScores = needsScores;
        for (BulkScorer scorer : scorers) {
            BulkScorerAndDoc evicted = this.tail.insertWithOverflow(new BulkScorerAndDoc(scorer));
            if (evicted == null) continue;
            this.head.add(evicted);
        }
        this.cost = BooleanScorer.cost(scorers, minShouldMatch);
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private void scoreWindowIntoBitSetAndReplay(LeafCollector collector, Bits acceptDocs, int base, int min, int max, BulkScorerAndDoc[] scorers, int numScorers) throws IOException {
        for (int i = 0; i < numScorers; ++i) {
            BulkScorerAndDoc scorer = scorers[i];
            assert (scorer.next < max);
            scorer.score(this.orCollector, acceptDocs, min, max);
        }
        this.docIdStreamView.base = base;
        collector.collect(this.docIdStreamView);
        Arrays.fill(this.matching, 0L);
    }

    private BulkScorerAndDoc advance(int min) throws IOException {
        assert (this.tail.size() == this.minShouldMatch - 1);
        HeadPriorityQueue head = this.head;
        TailPriorityQueue tail = this.tail;
        BulkScorerAndDoc headTop = (BulkScorerAndDoc)head.top();
        BulkScorerAndDoc tailTop = (BulkScorerAndDoc)tail.top();
        while (headTop.next < min) {
            if (tailTop == null || headTop.cost <= tailTop.cost) {
                headTop.advance(min);
                headTop = (BulkScorerAndDoc)head.updateTop();
                continue;
            }
            BulkScorerAndDoc previousHeadTop = headTop;
            tailTop.advance(min);
            headTop = head.updateTop(tailTop);
            tailTop = tail.updateTop(previousHeadTop);
        }
        return headTop;
    }

    private void scoreWindowMultipleScorers(LeafCollector collector, Bits acceptDocs, int windowBase, int windowMin, int windowMax, int maxFreq) throws IOException {
        while (maxFreq < this.minShouldMatch && maxFreq + this.tail.size() >= this.minShouldMatch) {
            BulkScorerAndDoc candidate = (BulkScorerAndDoc)this.tail.pop();
            candidate.advance(windowMin);
            if (candidate.next < windowMax) {
                this.leads[maxFreq++] = candidate;
                continue;
            }
            this.head.add(candidate);
        }
        if (maxFreq >= this.minShouldMatch) {
            for (int i = 0; i < this.tail.size(); ++i) {
                this.leads[maxFreq++] = this.tail.get(i);
            }
            this.tail.clear();
            this.scoreWindowIntoBitSetAndReplay(collector, acceptDocs, windowBase, windowMin, windowMax, this.leads, maxFreq);
        }
        for (int i = 0; i < maxFreq; ++i) {
            BulkScorerAndDoc evicted = this.head.insertWithOverflow(this.leads[i]);
            if (evicted == null) continue;
            this.tail.add(evicted);
        }
    }

    private void scoreWindowSingleScorer(BulkScorerAndDoc bulkScorer, LeafCollector collector, Bits acceptDocs, int windowMin, int windowMax, int max) throws IOException {
        assert (this.tail.size() == 0);
        int nextWindowBase = ((BulkScorerAndDoc)this.head.top()).next & 0xFFFFF000;
        int end = Math.max(windowMax, Math.min(max, nextWindowBase));
        bulkScorer.score(collector, acceptDocs, windowMin, end);
        collector.setScorer(this.scoreAndDoc);
    }

    private BulkScorerAndDoc scoreWindow(BulkScorerAndDoc top, LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int windowBase = top.next & 0xFFFFF000;
        int windowMin = Math.max(min, windowBase);
        int windowMax = Math.min(max, windowBase + 4096);
        this.leads[0] = (BulkScorerAndDoc)this.head.pop();
        int maxFreq = 1;
        while (this.head.size() > 0 && ((BulkScorerAndDoc)this.head.top()).next < windowMax) {
            this.leads[maxFreq++] = (BulkScorerAndDoc)this.head.pop();
        }
        if (this.minShouldMatch == 1 && maxFreq == 1) {
            BulkScorerAndDoc bulkScorer = this.leads[0];
            this.scoreWindowSingleScorer(bulkScorer, collector, acceptDocs, windowMin, windowMax, max);
            return this.head.add(bulkScorer);
        }
        this.scoreWindowMultipleScorers(collector, acceptDocs, windowBase, windowMin, windowMax, maxFreq);
        return (BulkScorerAndDoc)this.head.top();
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        this.scoreAndDoc.doc = -1;
        collector.setScorer(this.scoreAndDoc);
        BulkScorerAndDoc top = this.advance(min);
        while (top.next < max) {
            top = this.scoreWindow(top, collector, acceptDocs, min, max);
        }
        return top.next;
    }

    final class DocIdStreamView
    extends DocIdStream {
        int base;

        DocIdStreamView() {
        }

        @Override
        public void forEach(CheckedIntConsumer<IOException> consumer) throws IOException {
            long[] matching = BooleanScorer.this.matching;
            Bucket[] buckets = BooleanScorer.this.buckets;
            int base = this.base;
            for (int idx = 0; idx < matching.length; ++idx) {
                int ntz;
                for (long bits = matching[idx]; bits != 0L; bits ^= 1L << ntz) {
                    int doc;
                    ntz = Long.numberOfTrailingZeros(bits);
                    if (buckets != null) {
                        int indexInWindow = idx << 6 | ntz;
                        Bucket bucket = buckets[indexInWindow];
                        if (bucket.freq >= BooleanScorer.this.minShouldMatch) {
                            int doc2;
                            BooleanScorer.this.scoreAndDoc.doc = doc2 = base | indexInWindow;
                            BooleanScorer.this.scoreAndDoc.score = (float)bucket.score;
                            consumer.accept(doc2);
                        }
                        bucket.freq = 0;
                        bucket.score = 0.0;
                        continue;
                    }
                    BooleanScorer.this.scoreAndDoc.doc = doc = base | idx << 6 | ntz;
                    consumer.accept(doc);
                }
            }
        }
    }

    final class OrCollector
    implements LeafCollector {
        Scorable scorer;

        OrCollector() {
        }

        @Override
        public void setScorer(Scorable scorer) {
            this.scorer = scorer;
        }

        @Override
        public void collect(int doc) throws IOException {
            int idx;
            int i = doc & 0xFFF;
            int n = idx = i >>> 6;
            BooleanScorer.this.matching[n] = BooleanScorer.this.matching[n] | 1L << i;
            if (BooleanScorer.this.buckets != null) {
                Bucket bucket = BooleanScorer.this.buckets[i];
                ++bucket.freq;
                if (BooleanScorer.this.needsScores) {
                    bucket.score += (double)this.scorer.score();
                }
            }
        }
    }

    static final class TailPriorityQueue
    extends PriorityQueue<BulkScorerAndDoc> {
        public TailPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(BulkScorerAndDoc a, BulkScorerAndDoc b) {
            return a.cost < b.cost;
        }

        public BulkScorerAndDoc get(int i) {
            Objects.checkIndex(i, this.size());
            return (BulkScorerAndDoc)this.getHeapArray()[1 + i];
        }
    }

    static final class HeadPriorityQueue
    extends PriorityQueue<BulkScorerAndDoc> {
        public HeadPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(BulkScorerAndDoc a, BulkScorerAndDoc b) {
            return a.next < b.next;
        }
    }

    private class BulkScorerAndDoc {
        final BulkScorer scorer;
        final long cost;
        int next;

        BulkScorerAndDoc(BulkScorer scorer) {
            this.scorer = scorer;
            this.cost = scorer.cost();
            this.next = -1;
        }

        void advance(int min) throws IOException {
            this.score(BooleanScorer.this.orCollector, null, min, min);
        }

        void score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
            this.next = this.scorer.score(collector, acceptDocs, min, max);
        }
    }

    static class Bucket {
        double score;
        int freq;

        Bucket() {
        }
    }
}

