/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.DoubleValues;
import guideme.internal.shaded.lucene.search.DoubleValuesSource;
import guideme.internal.shaded.lucene.search.FilterScorer;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.Objects;

public final class FunctionScoreQuery
extends Query {
    private final Query in;
    private final DoubleValuesSource source;

    public FunctionScoreQuery(Query in, DoubleValuesSource source) {
        this.in = in;
        this.source = source;
    }

    public Query getWrappedQuery() {
        return this.in;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        ScoreMode sm = scoreMode.needsScores() && this.source.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        Weight inner = this.in.createWeight(searcher, sm, 1.0f);
        if (!scoreMode.needsScores()) {
            return inner;
        }
        return new FunctionScoreWeight(this, inner, this.source.rewrite(searcher), boost);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.in.rewrite(indexSearcher);
        if (rewritten == this.in) {
            return this;
        }
        return new FunctionScoreQuery(rewritten, this.source);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.in.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public String toString(String field) {
        return "FunctionScoreQuery(" + this.in.toString(field) + ", scored by " + this.source.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery that = (FunctionScoreQuery)o;
        return Objects.equals(this.in, that.in) && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.in, this.source);
    }

    private static class FunctionScoreWeight
    extends Weight {
        final Weight inner;
        final DoubleValuesSource valueSource;
        final float boost;

        FunctionScoreWeight(Query query, Weight inner, DoubleValuesSource valueSource, float boost) {
            super(query);
            this.inner = inner;
            this.valueSource = valueSource;
            this.boost = boost;
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer in = this.inner.scorer(context);
            if (in == null) {
                return null;
            }
            final DoubleValues scores = this.valueSource.getValues(context, DoubleValuesSource.fromScorer(in));
            return new FilterScorer(in){

                @Override
                public float score() throws IOException {
                    double factor;
                    if (scores.advanceExact(this.docID()) && (factor = scores.doubleValue()) >= 0.0) {
                        return (float)(factor * (double)boost);
                    }
                    return 0.0f;
                }

                @Override
                public float getMaxScore(int upTo) throws IOException {
                    return Float.POSITIVE_INFINITY;
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.inner.isCacheable(ctx) && this.valueSource.isCacheable(ctx);
        }
    }
}

