/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.util.IntsRef;
import java.io.IOException;

public abstract class PointValues {
    protected PointValues() {
    }

    public abstract PointTree getPointTree() throws IOException;

    public abstract int getNumDimensions() throws IOException;

    public abstract int getNumIndexDimensions() throws IOException;

    public abstract int getBytesPerDimension() throws IOException;

    public abstract long size();

    public abstract int getDocCount();

    public static interface IntersectVisitor {
        public void visit(int var1) throws IOException;

        default public void visit(DocIdSetIterator iterator) throws IOException {
            int docID;
            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                this.visit(docID);
            }
        }

        default public void visit(IntsRef ref) throws IOException {
            for (int i = ref.offset; i < ref.length + ref.offset; ++i) {
                this.visit(ref.ints[i]);
            }
        }

        public void visit(int var1, byte[] var2) throws IOException;

        default public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            int docID;
            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                this.visit(docID, packedValue);
            }
        }

        public Relation compare(byte[] var1, byte[] var2);

        default public void grow(int count) {
        }
    }

    public static interface PointTree
    extends Cloneable {
        public PointTree clone();

        public boolean moveToChild() throws IOException;

        public boolean moveToSibling() throws IOException;

        public boolean moveToParent() throws IOException;

        public long size();

        public void visitDocIDs(IntersectVisitor var1) throws IOException;

        public void visitDocValues(IntersectVisitor var1) throws IOException;
    }

    public static enum Relation {
        CELL_INSIDE_QUERY,
        CELL_OUTSIDE_QUERY,
        CELL_CROSSES_QUERY;

    }
}

