/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.codecs.Codec;
import guideme.internal.shaded.lucene.index.ConcurrentMergeScheduler;
import guideme.internal.shaded.lucene.index.FlushByRamOrCountsPolicy;
import guideme.internal.shaded.lucene.index.FlushPolicy;
import guideme.internal.shaded.lucene.index.IndexCommit;
import guideme.internal.shaded.lucene.index.IndexDeletionPolicy;
import guideme.internal.shaded.lucene.index.IndexWriter;
import guideme.internal.shaded.lucene.index.IndexWriterConfig;
import guideme.internal.shaded.lucene.index.IndexWriterEventListener;
import guideme.internal.shaded.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.MergePolicy;
import guideme.internal.shaded.lucene.index.MergeScheduler;
import guideme.internal.shaded.lucene.index.TieredMergePolicy;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Sort;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.InfoStream;
import guideme.internal.shaded.lucene.util.Version;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class LiveIndexWriterConfig {
    private final Analyzer analyzer;
    private volatile int maxBufferedDocs;
    private volatile double ramBufferSizeMB;
    private volatile IndexWriter.IndexReaderWarmer mergedSegmentWarmer;
    protected volatile IndexDeletionPolicy delPolicy;
    protected volatile IndexCommit commit;
    protected volatile IndexWriterConfig.OpenMode openMode;
    protected int createdVersionMajor;
    protected volatile Similarity similarity;
    protected volatile MergeScheduler mergeScheduler;
    protected volatile Codec codec;
    protected volatile InfoStream infoStream;
    protected volatile MergePolicy mergePolicy;
    protected volatile boolean readerPooling;
    protected volatile FlushPolicy flushPolicy;
    protected volatile int perThreadHardLimitMB;
    protected volatile boolean useCompoundFile;
    protected boolean commitOnClose;
    protected Sort indexSort;
    protected Comparator<LeafReader> leafSorter;
    protected Set<String> indexSortFields;
    protected String parentField;
    protected volatile boolean checkPendingFlushOnUpdate;
    protected String softDeletesField;
    protected volatile long maxFullFlushMergeWaitMillis;
    protected IndexWriterEventListener eventListener;

    LiveIndexWriterConfig(Analyzer analyzer) {
        this.createdVersionMajor = Version.LATEST.major;
        this.commitOnClose = true;
        this.indexSort = null;
        this.indexSortFields = Collections.emptySet();
        this.parentField = null;
        this.checkPendingFlushOnUpdate = true;
        this.softDeletesField = null;
        this.analyzer = analyzer;
        this.ramBufferSizeMB = 16.0;
        this.maxBufferedDocs = -1;
        this.mergedSegmentWarmer = null;
        this.delPolicy = new KeepOnlyLastCommitDeletionPolicy();
        this.commit = null;
        this.useCompoundFile = true;
        this.openMode = IndexWriterConfig.OpenMode.CREATE_OR_APPEND;
        this.similarity = IndexSearcher.getDefaultSimilarity();
        this.mergeScheduler = new ConcurrentMergeScheduler();
        this.codec = Codec.getDefault();
        if (this.codec == null) {
            throw new NullPointerException();
        }
        this.infoStream = InfoStream.getDefault();
        this.mergePolicy = new TieredMergePolicy();
        this.flushPolicy = new FlushByRamOrCountsPolicy();
        this.readerPooling = true;
        this.perThreadHardLimitMB = 1945;
        this.maxFullFlushMergeWaitMillis = 500L;
        this.eventListener = IndexWriterEventListener.NO_OP_LISTENER;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public double getRAMBufferSizeMB() {
        return this.ramBufferSizeMB;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public IndexWriter.IndexReaderWarmer getMergedSegmentWarmer() {
        return this.mergedSegmentWarmer;
    }

    public IndexWriterConfig.OpenMode getOpenMode() {
        return this.openMode;
    }

    public int getIndexCreatedVersionMajor() {
        return this.createdVersionMajor;
    }

    public IndexDeletionPolicy getIndexDeletionPolicy() {
        return this.delPolicy;
    }

    public IndexCommit getIndexCommit() {
        return this.commit;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public MergeScheduler getMergeScheduler() {
        return this.mergeScheduler;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public boolean getReaderPooling() {
        return this.readerPooling;
    }

    public int getRAMPerThreadHardLimitMB() {
        return this.perThreadHardLimitMB;
    }

    FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    public InfoStream getInfoStream() {
        return this.infoStream;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public boolean getCommitOnClose() {
        return this.commitOnClose;
    }

    public Sort getIndexSort() {
        return this.indexSort;
    }

    public Comparator<LeafReader> getLeafSorter() {
        return this.leafSorter;
    }

    public boolean isCheckPendingFlushOnUpdate() {
        return this.checkPendingFlushOnUpdate;
    }

    public String getSoftDeletesField() {
        return this.softDeletesField;
    }

    public long getMaxFullFlushMergeWaitMillis() {
        return this.maxFullFlushMergeWaitMillis;
    }

    public IndexWriterEventListener getIndexWriterEventListener() {
        return this.eventListener;
    }

    public String getParentField() {
        return this.parentField;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("analyzer=").append(this.analyzer == null ? "null" : this.analyzer.getClass().getName()).append("\n");
        sb.append("ramBufferSizeMB=").append(this.getRAMBufferSizeMB()).append("\n");
        sb.append("maxBufferedDocs=").append(this.getMaxBufferedDocs()).append("\n");
        sb.append("mergedSegmentWarmer=").append(this.getMergedSegmentWarmer()).append("\n");
        sb.append("delPolicy=").append(this.getIndexDeletionPolicy().getClass().getName()).append("\n");
        IndexCommit commit = this.getIndexCommit();
        sb.append("commit=").append(commit == null ? "null" : commit).append("\n");
        sb.append("openMode=").append((Object)this.getOpenMode()).append("\n");
        sb.append("similarity=").append(this.getSimilarity().getClass().getName()).append("\n");
        sb.append("mergeScheduler=").append(this.getMergeScheduler()).append("\n");
        sb.append("codec=").append(this.getCodec()).append("\n");
        sb.append("infoStream=").append(this.getInfoStream().getClass().getName()).append("\n");
        sb.append("mergePolicy=").append(this.getMergePolicy()).append("\n");
        sb.append("readerPooling=").append(this.getReaderPooling()).append("\n");
        sb.append("perThreadHardLimitMB=").append(this.getRAMPerThreadHardLimitMB()).append("\n");
        sb.append("useCompoundFile=").append(this.getUseCompoundFile()).append("\n");
        sb.append("commitOnClose=").append(this.getCommitOnClose()).append("\n");
        sb.append("indexSort=").append(this.getIndexSort()).append("\n");
        sb.append("checkPendingFlushOnUpdate=").append(this.isCheckPendingFlushOnUpdate()).append("\n");
        sb.append("softDeletesField=").append(this.getSoftDeletesField()).append("\n");
        sb.append("maxFullFlushMergeWaitMillis=").append(this.getMaxFullFlushMergeWaitMillis()).append("\n");
        sb.append("leafSorter=").append(this.getLeafSorter()).append("\n");
        sb.append("eventListener=").append(this.getIndexWriterEventListener()).append("\n");
        sb.append("parentField=").append(this.getParentField()).append("\n");
        return sb.toString();
    }
}

