/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.hnsw;

import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsScorer;
import guideme.internal.shaded.lucene.index.VectorSimilarityFunction;
import guideme.internal.shaded.lucene.util.hnsw.RandomAccessVectorValues;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorer;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorerSupplier;
import java.io.IOException;

public class DefaultFlatVectorScorer
implements FlatVectorsScorer {
    public static final DefaultFlatVectorScorer INSTANCE = new DefaultFlatVectorScorer();

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, RandomAccessVectorValues vectorValues) throws IOException {
        if (vectorValues instanceof RandomAccessVectorValues.Floats) {
            return new FloatScoringSupplier((RandomAccessVectorValues.Floats)vectorValues, similarityFunction);
        }
        if (vectorValues instanceof RandomAccessVectorValues.Bytes) {
            return new ByteScoringSupplier((RandomAccessVectorValues.Bytes)vectorValues, similarityFunction);
        }
        throw new IllegalArgumentException("vectorValues must be an instance of RandomAccessVectorValues.Floats or RandomAccessVectorValues.Bytes");
    }

    public String toString() {
        return "DefaultFlatVectorScorer()";
    }

    private static final class FloatScoringSupplier
    implements RandomVectorScorerSupplier {
        private final RandomAccessVectorValues.Floats vectors;
        private final RandomAccessVectorValues.Floats vectors1;
        private final RandomAccessVectorValues.Floats vectors2;
        private final VectorSimilarityFunction similarityFunction;

        private FloatScoringSupplier(RandomAccessVectorValues.Floats vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.vectors1 = vectors.copy();
            this.vectors2 = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(final int ord) {
            return new RandomVectorScorer.AbstractRandomVectorScorer(this.vectors){

                @Override
                public float score(int node) throws IOException {
                    return similarityFunction.compare(vectors1.vectorValue(ord), vectors2.vectorValue(node));
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new FloatScoringSupplier(this.vectors, this.similarityFunction);
        }

        public String toString() {
            return "FloatScoringSupplier(similarityFunction=" + this.similarityFunction + ")";
        }
    }

    private static final class ByteScoringSupplier
    implements RandomVectorScorerSupplier {
        private final RandomAccessVectorValues.Bytes vectors;
        private final RandomAccessVectorValues.Bytes vectors1;
        private final RandomAccessVectorValues.Bytes vectors2;
        private final VectorSimilarityFunction similarityFunction;

        private ByteScoringSupplier(RandomAccessVectorValues.Bytes vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.vectors1 = vectors.copy();
            this.vectors2 = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(final int ord) {
            return new RandomVectorScorer.AbstractRandomVectorScorer(this.vectors){

                @Override
                public float score(int node) throws IOException {
                    return similarityFunction.compare(vectors1.vectorValue(ord), vectors2.vectorValue(node));
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new ByteScoringSupplier(this.vectors, this.similarityFunction);
        }

        public String toString() {
            return "ByteScoringSupplier(similarityFunction=" + this.similarityFunction + ")";
        }
    }
}

