/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import guideme.PageAnchor;
import guideme.internal.GuideMEProxy;
import guideme.internal.command.GuideIdArgument;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PageAnchorArgument
implements ArgumentType<PageAnchor> {
    private static final List<String> EXAMPLES = List.of("index.md", "index.md#anchor");
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.resource_or_id.invalid"));

    public static PageAnchorArgument argument() {
        return new PageAnchorArgument();
    }

    public PageAnchor parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        ResourceLocation pageId = ResourceLocation.m_135818_((StringReader)reader);
        if (PageAnchorArgument.hasConsumedWholeArg(reader)) {
            return PageAnchor.page(pageId);
        }
        if (reader.peek() == '#') {
            reader.read();
            String fragment = reader.readString();
            if (!PageAnchorArgument.hasConsumedWholeArg(reader)) {
                reader.setCursor(i);
                throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
            }
            return new PageAnchor(pageId, fragment);
        }
        reader.setCursor(i);
        throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
    }

    private static boolean hasConsumedWholeArg(StringReader reader) {
        return !reader.canRead() || reader.peek() == ' ';
    }

    public static PageAnchor getPageAnchor(CommandContext<CommandSourceStack> context, String name) {
        return (PageAnchor)context.getArgument(name, PageAnchor.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ResourceLocation guideId = GuideIdArgument.getGuide(context, "guide");
        SharedSuggestionProvider.m_82957_(GuideMEProxy.instance().getAvailablePages(guideId), (SuggestionsBuilder)builder);
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

