/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.interaction;

import com.mojang.blaze3d.vertex.PoseStack;
import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.interaction.GuideTooltip;
import guideme.layout.LayoutContext;
import guideme.layout.MinecraftFontMetrics;
import guideme.render.SimpleRenderContext;
import guideme.siteexport.ExportableResourceProvider;
import guideme.siteexport.ResourceExporter;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ContentTooltip
implements GuideTooltip {
    private final List<ClientTooltipComponent> components;
    @Nullable
    private LytRect layoutViewport;
    @Nullable
    private LytRect layoutBox;
    private final LytBlock content;

    public ContentTooltip(final LytBlock content) {
        this.content = content;
        this.components = List.of(new ClientTooltipComponent(){

            public int getHeight() {
                return ContentTooltip.this.getLayoutBox().height();
            }

            public int getWidth(Font font) {
                return ContentTooltip.this.getLayoutBox().width();
            }

            public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
                ContentTooltip.this.getLayoutBox();
                GuiGraphics guiGraphics = new GuiGraphics(Minecraft.getInstance(), bufferSource);
                PoseStack poseStack = guiGraphics.pose();
                poseStack.mulPoseMatrix(matrix);
                poseStack.translate((float)x, (float)y, 0.0f);
                SimpleRenderContext ctx = new SimpleRenderContext(ContentTooltip.this.layoutViewport, guiGraphics);
                content.renderBatch(ctx, (MultiBufferSource)bufferSource);
            }

            public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
                ContentTooltip.this.getLayoutBox();
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                pose.translate((float)x, (float)y, 0.0f);
                SimpleRenderContext ctx = new SimpleRenderContext(ContentTooltip.this.layoutViewport, guiGraphics);
                content.render(ctx);
                pose.popPose();
            }
        });
    }

    @Override
    public List<ClientTooltipComponent> getLines() {
        return this.components;
    }

    public LytBlock getContent() {
        return this.content;
    }

    private LytRect getLayoutBox() {
        Screen screen = Minecraft.getInstance().screen;
        LytRect currentViewport = new LytRect(0, 0, screen.width, screen.height);
        if (this.layoutBox == null || !currentViewport.equals(this.layoutViewport)) {
            this.layoutViewport = currentViewport;
            LayoutContext layoutContext = new LayoutContext(new MinecraftFontMetrics());
            this.layoutBox = this.content.layout(layoutContext, 0, 0, screen.width / 2);
        }
        return this.layoutBox;
    }

    @Override
    public void exportResources(ResourceExporter exporter) {
        ExportableResourceProvider.visit(this.content, exporter);
    }
}

