/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Map;

public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static final Thread ONE = new Thread("main");
    private Runnable target;
    private String name;
    private volatile UncaughtExceptionHandler uncaughtExceptionHandler;
    private static volatile UncaughtExceptionHandler defaultUncaughtExceptionHandler;

    public static Thread currentThread() {
        return ONE;
    }

    public static void yield() {
    }

    public static native void sleep(long var0) throws InterruptedException;

    public static void sleep(long millis, int nanos) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (nanos >= 500000 || nanos != 0 && millis == 0L) {
            ++millis;
        }
        Thread.sleep(millis);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), 0);
    }

    private static int nextThreadNum() {
        return -1;
    }

    public Thread(Runnable target) {
        this.init(null, target, "Thread-" + Thread.nextThreadNum(), 0);
    }

    public Thread(String name) {
        this.init(null, null, name, 0);
    }

    private void init(Object o1, Runnable trgt, String nm, int i4) {
        this.target = trgt;
        this.name = nm;
    }

    public Thread(Runnable target, String name) {
        this.init(null, target, name, 0);
    }

    public void start() {
        throw new SecurityException();
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    @Deprecated
    public final void stop() {
        this.stop(null);
    }

    @Deprecated
    public final synchronized void stop(Throwable obj) {
        throw new SecurityException();
    }

    public void interrupt() {
        throw new SecurityException();
    }

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public boolean isInterrupted() {
        return false;
    }

    @Deprecated
    public void destroy() {
        throw new SecurityException();
    }

    public final boolean isAlive() {
        return true;
    }

    @Deprecated
    public final void suspend() {
        this.checkAccess();
    }

    @Deprecated
    public final void resume() {
        this.checkAccess();
    }

    public final void setPriority(int newPriority) {
        throw new SecurityException();
    }

    public final int getPriority() {
        return 5;
    }

    public final void setName(String name) {
        throw new SecurityException();
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public static int activeCount() {
        return 1;
    }

    public static int enumerate(Thread[] tarray) {
        throw new SecurityException();
    }

    @Deprecated
    public native int countStackFrames();

    public final synchronized void join(long millis) throws InterruptedException {
        long base = System.currentTimeMillis();
        long now = 0L;
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (millis == 0L) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            long delay;
            while (this.isAlive() && (delay = millis - now) > 0L) {
                this.wait(delay);
                now = System.currentTimeMillis() - base;
            }
        }
    }

    public final synchronized void join(long millis, int nanos) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (nanos >= 500000 || nanos != 0 && millis == 0L) {
            ++millis;
        }
        this.join(millis);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean on) {
        throw new SecurityException();
    }

    public final boolean isDaemon() {
        return false;
    }

    public final void checkAccess() {
        throw new SecurityException();
    }

    public String toString() {
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + "" + "]";
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public void setContextClassLoader(ClassLoader cl) {
        throw new SecurityException();
    }

    public static boolean holdsLock(Object obj) {
        return true;
    }

    public StackTraceElement[] getStackTrace() {
        throw new SecurityException();
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        throw new SecurityException();
    }

    public long getId() {
        return 0L;
    }

    public State getState() {
        return State.RUNNABLE;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        throw new SecurityException();
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler != null ? this.uncaughtExceptionHandler : null;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        this.checkAccess();
        this.uncaughtExceptionHandler = eh;
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }
}

