/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apidesign.bck2brwsr.emul.reflect.TypeProvider;

public final class Constructor<T>
extends AccessibleObject
implements GenericDeclaration,
Member {
    private Class<T> clazz;
    private int slot;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private Constructor<T> root;

    Constructor(Class<T> declaringClass, Class<?>[] parameterTypes, Class<?>[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations) {
        this.clazz = declaringClass;
        this.parameterTypes = parameterTypes;
        this.exceptionTypes = checkedExceptions;
        this.modifiers = modifiers;
        this.slot = slot;
        this.signature = signature;
        this.annotations = annotations;
        this.parameterAnnotations = parameterAnnotations;
    }

    Constructor<T> copy() {
        return this;
    }

    public Class<T> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.getDeclaringClass().getName();
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        return TypeProvider.getDefault().getTypeParameters(this);
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public Type[] getGenericParameterTypes() {
        return TypeProvider.getDefault().getGenericParameterTypes(this);
    }

    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    public Type[] getGenericExceptionTypes() {
        return TypeProvider.getDefault().getGenericExceptionTypes(this);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Constructor) {
            Class<?>[] params2;
            Class<?>[] params1;
            Constructor other = (Constructor)obj;
            if (this.getDeclaringClass() == other.getDeclaringClass() && (params1 = this.parameterTypes).length == (params2 = other.parameterTypes).length) {
                for (int i = 0; i < params1.length; ++i) {
                    if (params1[i] == params2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            int mod = this.getModifiers() & Modifier.constructorModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod) + " ");
            }
            sb.append(Field.getTypeName(this.getDeclaringClass()));
            sb.append("(");
            Class<?>[] params = this.parameterTypes;
            for (int j = 0; j < params.length; ++j) {
                sb.append(Field.getTypeName(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            Class<?>[] exceptions = this.exceptionTypes;
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k].getName());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public String toGenericString() {
        try {
            TypeVariable<Constructor<T>>[] typeparms;
            StringBuilder sb = new StringBuilder();
            int mod = this.getModifiers() & Modifier.constructorModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod) + " ");
            }
            if ((typeparms = this.getTypeParameters()).length > 0) {
                boolean first = true;
                sb.append("<");
                for (TypeVariable<Constructor<T>> typeparm : typeparms) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(typeparm.toString());
                    first = false;
                }
                sb.append("> ");
            }
            sb.append(Field.getTypeName(this.getDeclaringClass()));
            sb.append("(");
            Type[] params = this.getGenericParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                String param;
                String string = param = params[j] instanceof Class ? Field.getTypeName((Class)params[j]) : params[j].toString();
                if (this.isVarArgs() && j == params.length - 1) {
                    param = param.replaceFirst("\\[\\]$", "...");
                }
                sb.append(param);
                if (j >= params.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            Type[] exceptions = this.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k] instanceof Class ? ((Class)exceptions[k]).getName() : exceptions[k].toString());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public T newInstance(Object ... initargs) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        throw new SecurityException();
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    int getSlot() {
        return this.slot;
    }

    String getSignature() {
        return this.signature;
    }

    byte[] getRawAnnotations() {
        return this.annotations;
    }

    byte[] getRawParameterAnnotations() {
        return this.parameterAnnotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[0];
    }

    public Annotation[][] getParameterAnnotations() {
        int numParameters = this.parameterTypes.length;
        if (this.parameterAnnotations == null) {
            return new Annotation[numParameters][0];
        }
        return new Annotation[numParameters][0];
    }
}

