/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.core.JavaScriptOnly;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private transient Object backtrace;
    private String detailMessage;
    private static final StackTraceElement[] UNASSIGNED_STACK = new StackTraceElement[0];
    private Throwable cause = this;
    private StackTraceElement[] stackTrace = UNASSIGNED_STACK;
    private static final String NULL_CAUSE_MESSAGE = "Cannot suppress a null exception.";
    private static final String SELF_SUPPRESSION_MESSAGE = "Self-suppression not permitted";
    private static final String CAUSE_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";
    private static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];

    @JavaScriptOnly(name="toString", value="function() { return this.toString__Ljava_lang_String_2().toString(); }")
    private static void jsToString() {
    }

    @JavaScriptOnly(name="valueOf", value="function() { return this.toString().valueOf(); }")
    private static void jsValudOf() {
    }

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String message) {
        this.fillInStackTrace();
        this.detailMessage = message;
    }

    public Throwable(String message, Throwable cause) {
        this.fillInStackTrace();
        this.detailMessage = message;
        this.cause = cause;
    }

    public Throwable(Throwable cause) {
        this.fillInStackTrace();
        this.detailMessage = cause == null ? null : cause.toString();
        this.cause = cause;
    }

    protected Throwable(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        if (writableStackTrace) {
            this.fillInStackTrace();
        } else {
            this.stackTrace = null;
        }
        this.detailMessage = message;
        this.cause = cause;
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public synchronized Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public synchronized Throwable initCause(Throwable cause) {
        if (this.cause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (cause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.cause = cause;
        return this;
    }

    public String toString() {
        String s = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }

    @JavaScriptBody(args={}, body="console.warn(this.toString());")
    public native void printStackTrace();

    public synchronized Throwable fillInStackTrace() {
        if (this.stackTrace != null || this.backtrace != null) {
            this.fillInStackTrace(0);
            this.stackTrace = UNASSIGNED_STACK;
        }
        return this;
    }

    @JavaScriptBody(args={"dummy"}, body="")
    private native Throwable fillInStackTrace(int var1);

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == UNASSIGNED_STACK || this.stackTrace == null && this.backtrace != null) {
            int depth = this.getStackTraceDepth();
            this.stackTrace = new StackTraceElement[depth];
            for (int i = 0; i < depth; ++i) {
                this.stackTrace[i] = this.getStackTraceElement(i);
            }
        } else if (this.stackTrace == null) {
            return UNASSIGNED_STACK;
        }
        return this.stackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStackTrace(StackTraceElement[] stackTrace) {
        StackTraceElement[] defensiveCopy = (StackTraceElement[])stackTrace.clone();
        for (int i = 0; i < defensiveCopy.length; ++i) {
            if (defensiveCopy[i] != null) continue;
            throw new NullPointerException("stackTrace[" + i + "]");
        }
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.stackTrace == null && this.backtrace == null) {
                return;
            }
            this.stackTrace = defensiveCopy;
        }
    }

    native int getStackTraceDepth();

    native StackTraceElement getStackTraceElement(int var1);

    public final synchronized void addSuppressed(Throwable exception) {
        if (exception == this) {
            throw new IllegalArgumentException(SELF_SUPPRESSION_MESSAGE);
        }
        if (exception == null) {
            throw new NullPointerException(NULL_CAUSE_MESSAGE);
        }
    }

    public final synchronized Throwable[] getSuppressed() {
        return new Throwable[0];
    }

    private static Object bck2BrwsrCnvrt(Object o) {
        if (o instanceof Throwable) {
            return o;
        }
        String msg = Throwable.msg(o);
        if (msg == null || msg.startsWith("TypeError")) {
            return new NullPointerException(msg);
        }
        return new Throwable(msg);
    }

    @JavaScriptBody(args={"o"}, body="return o ? o.toString() : null;")
    private static native String msg(Object var0);

    @JavaScriptOnly(name="bck2BrwsrCnvrt", value="c.bck2BrwsrCnvrt__Ljava_lang_Object_2Ljava_lang_Object_2")
    private static void bck2BrwsrCnvrtVM() {
    }

    private static class SentinelHolder {
        public static final StackTraceElement STACK_TRACE_ELEMENT_SENTINEL = new StackTraceElement("", "", null, Integer.MIN_VALUE);
        public static final StackTraceElement[] STACK_TRACE_SENTINEL = new StackTraceElement[]{STACK_TRACE_ELEMENT_SENTINEL};

        private SentinelHolder() {
        }
    }
}

