/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuffer
extends AbstractStringBuilder
implements Serializable,
CharSequence {
    static final long serialVersionUID = 3388685877147921107L;

    public StringBuffer() {
        super(16);
    }

    public StringBuffer(int capacity) {
        super(capacity);
    }

    public StringBuffer(String str) {
        super(str.length() + 16);
        this.append(str);
    }

    public StringBuffer(CharSequence seq) {
        this(seq.length() + 16);
        this.append(seq);
    }

    @Override
    public synchronized int length() {
        return this.count;
    }

    @Override
    public synchronized int capacity() {
        return this.value.length;
    }

    @Override
    public synchronized void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    @Override
    public synchronized void trimToSize() {
        super.trimToSize();
    }

    @Override
    public synchronized void setLength(int newLength) {
        super.setLength(newLength);
    }

    @Override
    public synchronized char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    @Override
    public synchronized int codePointAt(int index) {
        return super.codePointAt(index);
    }

    @Override
    public synchronized int codePointBefore(int index) {
        return super.codePointBefore(index);
    }

    @Override
    public synchronized int codePointCount(int beginIndex, int endIndex) {
        return super.codePointCount(beginIndex, endIndex);
    }

    @Override
    public synchronized int offsetByCodePoints(int index, int codePointOffset) {
        return super.offsetByCodePoints(index, codePointOffset);
    }

    @Override
    public synchronized void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        super.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    @Override
    public synchronized void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    @Override
    public synchronized StringBuffer append(Object obj) {
        super.append(String.valueOf(obj));
        return this;
    }

    @Override
    public synchronized StringBuffer append(String str) {
        super.append(str);
        return this;
    }

    @Override
    public synchronized StringBuffer append(StringBuffer sb) {
        super.append(sb);
        return this;
    }

    @Override
    public StringBuffer append(CharSequence s) {
        if (s == null) {
            s = "null";
        }
        if (s instanceof String) {
            return this.append((String)s);
        }
        if (s instanceof StringBuffer) {
            return this.append((StringBuffer)s);
        }
        return this.append(s, 0, s.length());
    }

    @Override
    public synchronized StringBuffer append(CharSequence s, int start, int end) {
        super.append(s, start, end);
        return this;
    }

    @Override
    public synchronized StringBuffer append(char[] str) {
        super.append(str);
        return this;
    }

    @Override
    public synchronized StringBuffer append(char[] str, int offset, int len) {
        super.append(str, offset, len);
        return this;
    }

    @Override
    public synchronized StringBuffer append(boolean b) {
        super.append(b);
        return this;
    }

    @Override
    public synchronized StringBuffer append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public synchronized StringBuffer append(int i) {
        super.append(i);
        return this;
    }

    @Override
    public synchronized StringBuffer appendCodePoint(int codePoint) {
        super.appendCodePoint(codePoint);
        return this;
    }

    @Override
    public synchronized StringBuffer append(long lng) {
        super.append(lng);
        return this;
    }

    @Override
    public synchronized StringBuffer append(float f) {
        super.append(f);
        return this;
    }

    @Override
    public synchronized StringBuffer append(double d) {
        super.append(d);
        return this;
    }

    @Override
    public synchronized StringBuffer delete(int start, int end) {
        super.delete(start, end);
        return this;
    }

    @Override
    public synchronized StringBuffer deleteCharAt(int index) {
        super.deleteCharAt(index);
        return this;
    }

    @Override
    public synchronized StringBuffer replace(int start, int end, String str) {
        super.replace(start, end, str);
        return this;
    }

    @Override
    public synchronized String substring(int start) {
        return this.substring(start, this.count);
    }

    @Override
    public synchronized CharSequence subSequence(int start, int end) {
        return super.substring(start, end);
    }

    @Override
    public synchronized String substring(int start, int end) {
        return super.substring(start, end);
    }

    @Override
    public synchronized StringBuffer insert(int index, char[] str, int offset, int len) {
        super.insert(index, str, offset, len);
        return this;
    }

    @Override
    public synchronized StringBuffer insert(int offset, Object obj) {
        super.insert(offset, String.valueOf(obj));
        return this;
    }

    @Override
    public synchronized StringBuffer insert(int offset, String str) {
        super.insert(offset, str);
        return this;
    }

    @Override
    public synchronized StringBuffer insert(int offset, char[] str) {
        super.insert(offset, str);
        return this;
    }

    @Override
    public StringBuffer insert(int dstOffset, CharSequence s) {
        if (s == null) {
            s = "null";
        }
        if (s instanceof String) {
            return this.insert(dstOffset, (String)s);
        }
        return this.insert(dstOffset, s, 0, s.length());
    }

    @Override
    public synchronized StringBuffer insert(int dstOffset, CharSequence s, int start, int end) {
        super.insert(dstOffset, s, start, end);
        return this;
    }

    @Override
    public StringBuffer insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    @Override
    public synchronized StringBuffer insert(int offset, char c) {
        super.insert(offset, c);
        return this;
    }

    @Override
    public StringBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    @Override
    public StringBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    @Override
    public StringBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    @Override
    public StringBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    @Override
    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    @Override
    public synchronized int indexOf(String str, int fromIndex) {
        return super.indexOf(str, fromIndex);
    }

    @Override
    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    @Override
    public synchronized int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    @Override
    public synchronized StringBuffer reverse() {
        super.reverse();
        return this;
    }

    @Override
    public synchronized String toString() {
        return new String(this.value, 0, this.count);
    }
}

