/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import org.apidesign.bck2brwsr.core.JavaScriptBody;

public final class Long
extends Number
implements Comparable<Long> {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = Class.getPrimitiveClass("long");
    private final long value;
    public static final int SIZE = 64;
    private static final long serialVersionUID = 4290774380558885855L;

    public static String toString(long i, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Long.toString(i);
        }
        char[] buf = new char[65];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-radix)) {
            buf[charPos--] = Integer.digits[(int)(-(i % (long)radix))];
            i /= (long)radix;
        }
        buf[charPos] = Integer.digits[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    public static String toHexString(long i) {
        return Long.toUnsignedString(i, 4);
    }

    public static String toOctalString(long i) {
        return Long.toUnsignedString(i, 3);
    }

    public static String toBinaryString(long i) {
        return Long.toUnsignedString(i, 1);
    }

    private static String toUnsignedString(long i, int shift) {
        char[] buf = new char[64];
        int charPos = 64;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = Integer.digits[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        return new String(buf, charPos, 64 - charPos);
    }

    @JavaScriptBody(args={"i"}, body="return i.toExactString();")
    public static String toString(long i) {
        if (i == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        int size = i < 0L ? Long.stringSize(-i) + 1 : Long.stringSize(i);
        char[] buf = new char[size];
        Long.getChars(i, size, buf);
        return new String(buf, 0, size);
    }

    static void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = Integer.DigitOnes[r];
            buf[--charPos] = Integer.DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = Integer.DigitOnes[r];
            buf[--charPos] = Integer.DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = Integer.digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static long parseLong(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw NumberFormatException.forInputString(s);
                }
                if (len == 1) {
                    throw NumberFormatException.forInputString(s);
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw NumberFormatException.forInputString(s);
                }
                if (result < multmin) {
                    throw NumberFormatException.forInputString(s);
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw NumberFormatException.forInputString(s);
                }
                result -= (long)digit;
            }
        } else {
            throw NumberFormatException.forInputString(s);
        }
        return negative ? result : -result;
    }

    public static long parseLong(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    public static Long valueOf(String s, int radix) throws NumberFormatException {
        return Long.parseLong(s, radix);
    }

    public static Long valueOf(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    public static Long valueOf(long l) {
        int offset = 128;
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new Long(l);
    }

    public static Long decode(String nm) throws NumberFormatException {
        Long result;
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (nm.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (nm.startsWith("-", index) || nm.startsWith("+", index)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            result = Long.valueOf(nm.substring(index), radix);
            result = negative ? Long.valueOf(-result.longValue()) : result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            result = Long.valueOf(constant, radix);
        }
        return result;
    }

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) throws NumberFormatException {
        this.value = Long.parseLong(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Long) {
            return this.value == (Long)obj;
        }
        return false;
    }

    public static Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        Long result = Long.getLong(nm, null);
        return result == null ? Long.valueOf(val) : result;
    }

    public static Long getLong(String nm, Long val) {
        String v = null;
        try {
            v = AbstractStringBuilder.getProperty(nm);
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (v != null) {
            try {
                return Long.decode(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return val;
    }

    @Override
    public int compareTo(Long anotherLong) {
        return Long.compare(this.value, anotherLong.value);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static long highestOneBit(long i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        i |= i >> 32;
        return i - (i >>> 1);
    }

    public static long lowestOneBit(long i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(long i) {
        if (i == 0L) {
            return 64;
        }
        int n = 1;
        int x = (int)(i >>> 32);
        if (x == 0) {
            n += 32;
            x = (int)i;
        }
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    public static int numberOfTrailingZeros(long i) {
        int x;
        if (i == 0L) {
            return 64;
        }
        int n = 63;
        int y = (int)i;
        if (y != 0) {
            n -= 32;
            x = y;
        } else {
            x = (int)(i >>> 32);
        }
        y = x << 16;
        if (y != 0) {
            n -= 16;
            x = y;
        }
        if ((y = x << 8) != 0) {
            n -= 8;
            x = y;
        }
        if ((y = x << 4) != 0) {
            n -= 4;
            x = y;
        }
        if ((y = x << 2) != 0) {
            n -= 2;
            x = y;
        }
        return n - (x << 1 >>> 31);
    }

    public static int bitCount(long i) {
        i -= i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
        i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
        i += i >>> 8;
        i += i >>> 16;
        i += i >>> 32;
        return (int)i & 0x7F;
    }

    public static long rotateLeft(long i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static long rotateRight(long i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static long reverse(long i) {
        i = (i & 0x5555555555555555L) << 1 | i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) << 2 | i >>> 2 & 0x3333333333333333L;
        i = (i & 0xF0F0F0F0F0F0F0FL) << 4 | i >>> 4 & 0xF0F0F0F0F0F0F0FL;
        i = (i & 0xFF00FF00FF00FFL) << 8 | i >>> 8 & 0xFF00FF00FF00FFL;
        i = i << 48 | (i & 0xFFFF0000L) << 16 | i >>> 16 & 0xFFFF0000L | i >>> 48;
        return i;
    }

    public static int signum(long i) {
        return (int)(i >> 63 | -i >>> 63);
    }

    public static long reverseBytes(long i) {
        i = (i & 0xFF00FF00FF00FFL) << 8 | i >>> 8 & 0xFF00FF00FF00FFL;
        return i << 48 | (i & 0xFFFF0000L) << 16 | i >>> 16 & 0xFFFF0000L | i >>> 48;
    }

    private static class LongCache {
        static final Long[] cache = new Long[256];

        private LongCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                LongCache.cache[i] = new Long(i - 128);
            }
        }
    }
}

