/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class PrintStream
extends FilterOutputStream
implements Appendable,
Closeable {
    private final boolean autoFlush;
    private boolean trouble = false;
    private Formatter formatter;
    private BufferedWriter textOut;
    private OutputStreamWriter charOut;
    private boolean closing = false;

    private static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    private PrintStream(boolean autoFlush, OutputStream out) {
        super(out);
        this.autoFlush = autoFlush;
        this.charOut = new OutputStreamWriter(this);
        this.textOut = new BufferedWriter(this.charOut);
    }

    static Charset toCharset(String ch) throws UnsupportedEncodingException {
        if (!"UTF-8".equals(ch)) {
            throw new UnsupportedEncodingException();
        }
        return null;
    }

    private PrintStream(boolean autoFlush, OutputStream out, Charset charset) {
        super(out);
        this.autoFlush = autoFlush;
        this.charOut = new OutputStreamWriter(this);
        this.textOut = new BufferedWriter(this.charOut);
    }

    private PrintStream(boolean autoFlush, Charset charset, OutputStream out) throws UnsupportedEncodingException {
        this(autoFlush, out, charset);
    }

    public PrintStream(OutputStream out) {
        this(out, false);
    }

    public PrintStream(OutputStream out, boolean autoFlush) {
        this(autoFlush, PrintStream.requireNonNull(out, "Null output stream"));
    }

    public PrintStream(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        this(autoFlush, PrintStream.requireNonNull(out, "Null output stream"), PrintStream.toCharset(encoding));
    }

    public PrintStream(String fileName) throws FileNotFoundException {
        super(null);
        throw new FileNotFoundException();
    }

    public PrintStream(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(null);
        throw new FileNotFoundException();
    }

    public PrintStream(File file) throws FileNotFoundException {
        super(null);
        throw new FileNotFoundException();
    }

    public PrintStream(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(null);
        throw new FileNotFoundException();
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PrintStream printStream = this;
        synchronized (printStream) {
            try {
                this.ensureOpen();
                this.out.flush();
            }
            catch (IOException x) {
                this.trouble = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PrintStream printStream = this;
        synchronized (printStream) {
            if (!this.closing) {
                this.closing = true;
                try {
                    this.textOut.close();
                    this.out.close();
                }
                catch (IOException x) {
                    this.trouble = true;
                }
                this.textOut = null;
                this.charOut = null;
                this.out = null;
            }
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        if (this.out instanceof PrintStream) {
            PrintStream ps = (PrintStream)this.out;
            return ps.checkError();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    protected void clearError() {
        this.trouble = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.out.write(b);
                if (b == 10 && this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.out.write(buf, off, len);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(char[] buf) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.textOut.write(buf);
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush) {
                    for (int i = 0; i < buf.length; ++i) {
                        if (buf[i] != '\n') continue;
                        this.out.flush();
                    }
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String s) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.textOut.write(s);
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush && s.indexOf(10) >= 0) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.textOut.newLine();
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(s);
    }

    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object x) {
        String s = String.valueOf(x);
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(s);
            this.newLine();
        }
    }

    public PrintStream printf(String format, Object ... args) {
        this.append(format).append(Arrays.toString(args));
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        if (csq == null) {
            this.print("null");
        } else {
            this.print(csq.toString());
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }

    static final class Charset {
        Charset() {
        }
    }

    static final class Formatter {
        Formatter() {
        }
    }
}

