/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.emul.zip;

import java.util.zip.DataFormatException;
import org.apidesign.bck2brwsr.emul.lang.System;
import org.apidesign.bck2brwsr.emul.zip.JzLibInflater;

public class Inflater
extends java.util.zip.Inflater {
    private final boolean nowrap;
    private JzLibInflater impl;

    public Inflater(boolean nowrap) {
        this.nowrap = nowrap;
        this.reset();
    }

    public Inflater() {
        this(false);
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.impl.setInput(b, off, len, false);
    }

    @Override
    public void setInput(byte[] b) {
        this.setInput(b, 0, b.length);
    }

    @Override
    public void setDictionary(byte[] b, int off, int len) {
        byte[] arr;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (off == 0) {
            arr = b;
        } else {
            arr = new byte[len];
            System.arraycopy(b, off, arr, 0, len);
        }
        this.impl.setDictionary(arr, len);
    }

    @Override
    public void setDictionary(byte[] b) {
        this.impl.setDictionary(b, b.length);
    }

    @Override
    public int getRemaining() {
        return this.impl.getAvailIn();
    }

    @Override
    public boolean needsInput() {
        return this.getRemaining() <= 0;
    }

    @Override
    public boolean needsDictionary() {
        return this.impl.needDict();
    }

    @Override
    public boolean finished() {
        return this.impl.finished();
    }

    @Override
    public int inflate(byte[] b, int off, int len) throws DataFormatException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.impl.setOutput(b, off, len);
        int err = this.impl.inflate(0);
        return this.impl.next_out_index - off;
    }

    @Override
    public int inflate(byte[] b) throws DataFormatException {
        return this.inflate(b, 0, b.length);
    }

    @Override
    public int getAdler() {
        return (int)this.impl.getAdler();
    }

    @Override
    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    @Override
    public long getBytesRead() {
        return this.impl.total_in;
    }

    @Override
    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    @Override
    public long getBytesWritten() {
        return this.impl.total_out;
    }

    @Override
    public void reset() {
        this.impl = new JzLibInflater(15, this.nowrap);
    }

    @Override
    public void end() {
        this.impl.end();
    }

    @Override
    protected void finalize() {
        this.end();
    }
}

