/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

public final class JavaScriptProcesor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(JavaScriptBody.class.getName());
        return set;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager msg = this.processingEnv.getMessager();
        for (Element element : roundEnv.getElementsAnnotatedWith(JavaScriptBody.class)) {
            if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR) continue;
            ExecutableElement ee = (ExecutableElement)element;
            List<? extends VariableElement> params = ee.getParameters();
            JavaScriptBody jsb = element.getAnnotation(JavaScriptBody.class);
            if (jsb == null) continue;
            String[] arr = jsb.args();
            if (params.size() != arr.length) {
                msg.printMessage(Diagnostic.Kind.ERROR, "Number of args arguments does not match real arguments!", element);
            }
            if (ee.getReturnType().getKind() != TypeKind.LONG) continue;
            msg.printMessage(Diagnostic.Kind.WARNING, "Don't return long. Return double and convert it to long in Java code.", element);
        }
        return true;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element e, AnnotationMirror annotation, ExecutableElement member, String userText) {
        StringBuilder sb = new StringBuilder();
        if (e.getKind() == ElementKind.METHOD && member.getSimpleName().contentEquals("args")) {
            ExecutableElement ee = (ExecutableElement)e;
            String sep = "";
            sb.append("{ ");
            for (VariableElement variableElement : ee.getParameters()) {
                sb.append(sep).append('\"').append(variableElement.getSimpleName()).append('\"');
                sep = ", ";
            }
            sb.append(" }");
            return Collections.nCopies(1, Completions.of(sb.toString()));
        }
        return null;
    }
}

