/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicLongArray
implements Serializable {
    private static final long serialVersionUID = -2308431214976778248L;
    private final long[] array;

    public AtomicLongArray(int length) {
        this.array = new long[length];
    }

    public AtomicLongArray(long[] array) {
        this.array = (long[])array.clone();
    }

    public final int length() {
        return this.array.length;
    }

    public final long get(int i) {
        return this.array[i];
    }

    public final void set(int i, long newValue) {
        this.array[i] = newValue;
    }

    public final void lazySet(int i, long newValue) {
        this.array[i] = newValue;
    }

    public final long getAndSet(int i, long newValue) {
        long v = this.array[i];
        this.array[i] = newValue;
        return v;
    }

    public final boolean compareAndSet(int i, long expect, long update) {
        if (this.array[i] == expect) {
            this.array[i] = update;
            return true;
        }
        return false;
    }

    public final boolean weakCompareAndSet(int i, long expect, long update) {
        return this.compareAndSet(i, expect, update);
    }

    public final long getAndIncrement(int i) {
        return this.getAndAdd(i, 1L);
    }

    public final long getAndDecrement(int i) {
        return this.getAndAdd(i, -1L);
    }

    public final long getAndAdd(int i, long delta) {
        long v = this.array[i];
        int n = i;
        this.array[n] = this.array[n] + delta;
        return v;
    }

    public final long incrementAndGet(int i) {
        return this.addAndGet(i, 1L);
    }

    public final long decrementAndGet(int i) {
        return this.addAndGet(i, -1L);
    }

    public long addAndGet(int i, long delta) {
        int n = i;
        this.array[n] = this.array[n] + delta;
        return this.array[i];
    }

    public String toString() {
        int iMax = this.array.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.get(i));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i;
        }
    }
}

