/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Locale;
import org.apidesign.bck2brwsr.core.ExtraJavaScript;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.core.JavaScriptPrototype;
import org.apidesign.bck2brwsr.emul.lang.System;

@ExtraJavaScript(resource="/org/apidesign/vm4brwsr/emul/lang/java_lang_String.js", processByteCode=true)
@JavaScriptPrototype(container="String.prototype", prototype="new String")
public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private Object r;
    private static final long serialVersionUID = -6849794470754667710L;
    public static final Comparator<String> CASE_INSENSITIVE_ORDER;

    @JavaScriptBody(args={}, body="var p = vm.java_lang_String(false);\np.toString = function() {\nreturn this._r().toString();\n};\np.valueOf = function() {\nreturn this._r().valueOf();\n}\n")
    private static native void registerToString();

    public String() {
        this.r = "";
    }

    public String(String original) {
        this.r = original.toString();
    }

    @JavaScriptBody(args={"charArr"}, body="for (var i = 0; i < charArr.length; i++) {\n  if (typeof charArr[i] === 'number') charArr[i] = String.fromCharCode(charArr[i]);\n}\nthis._r(charArr.join(''));\n")
    public String(char[] value) {
    }

    public String(char[] value, int offset, int count) {
        this.initFromCharArray(value, offset, count);
    }

    @JavaScriptBody(args={"charArr", "off", "cnt"}, body="var up = off + cnt;\nfor (var i = off; i < up; i++) {\n  if (typeof charArr[i] === 'number') charArr[i] = String.fromCharCode(charArr[i]);\n}\nthis._r(charArr.slice(off, up).join(\"\"));\n")
    private native void initFromCharArray(char[] var1, int var2, int var3);

    public String(int[] codePoints, int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (offset > codePoints.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        int end = offset + count;
        int n = count;
        for (int i = offset; i < end; ++i) {
            int c = codePoints[i];
            if (Character.isBmpCodePoint(c)) continue;
            if (Character.isValidCodePoint(c)) {
                ++n;
                continue;
            }
            throw new IllegalArgumentException(Integer.toString(c));
        }
        char[] v = new char[n];
        int i = offset;
        int j = 0;
        while (i < end) {
            int c = codePoints[i];
            if (Character.isBmpCodePoint(c)) {
                v[j] = (char)c;
            } else {
                Character.toSurrogates(c, v, j++);
            }
            ++i;
            ++j;
        }
        this.r = new String(v, 0, n);
    }

    @Deprecated
    public String(byte[] ascii, int hibyte, int offset, int count) {
        String.checkBounds(ascii, offset, count);
        char[] value = new char[count];
        if (hibyte == 0) {
            int i = count;
            while (i-- > 0) {
                value[i] = (char)(ascii[i + offset] & 0xFF);
            }
        } else {
            hibyte <<= 8;
            int i = count;
            while (i-- > 0) {
                value[i] = (char)(hibyte | ascii[i + offset] & 0xFF);
            }
        }
        this.initFromCharArray(value, offset, count);
    }

    @Deprecated
    public String(byte[] ascii, int hibyte) {
        this(ascii, hibyte, 0, ascii.length);
    }

    private static void checkBounds(byte[] bytes, int offset, int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (offset > bytes.length - length) {
            throw new StringIndexOutOfBoundsException(offset + length);
        }
    }

    public String(byte[] bytes, int offset, int length, String charsetName) throws UnsupportedEncodingException {
        this(String.checkUTF8(bytes, charsetName), offset, length);
    }

    public String(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
        this(bytes, 0, bytes.length, charsetName);
    }

    public String(byte[] bytes, int offset, int length) {
        String.checkBounds(bytes, offset, length);
        char[] v = new char[length];
        int[] at = new int[]{offset};
        int end = offset + length;
        int chlen = 0;
        while (at[0] < end) {
            int ch = String.nextChar(bytes, at);
            v[chlen++] = (char)ch;
        }
        this.initFromCharArray(v, 0, chlen);
    }

    public String(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public String(StringBuffer buffer) {
        this.r = buffer.toString();
    }

    public String(StringBuilder builder) {
        this.r = builder.toString();
    }

    @Override
    @JavaScriptBody(args={}, body="return this.toString().length;")
    public int length() {
        throw new UnsupportedOperationException();
    }

    @JavaScriptBody(args={}, body="return this.toString().length === 0;")
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    @JavaScriptBody(args={"index"}, body="return this.toString().charCodeAt(index);")
    public char charAt(int index) {
        throw new UnsupportedOperationException();
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointAtImpl(this.toCharArray(), String.offset() + index, String.offset() + this.length());
    }

    public int codePointBefore(int index) {
        int i = index - 1;
        if (i < 0 || i >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointBeforeImpl(this.toCharArray(), String.offset() + index, String.offset());
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.length() || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(this.toCharArray(), String.offset() + beginIndex, endIndex - beginIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(this.toCharArray(), String.offset(), this.length(), String.offset() + index, codePointOffset) - String.offset();
    }

    @JavaScriptBody(args={"arr", "to"}, body="var s = this.toString();\nfor (var i = 0; i < s.length; i++) {\n   arr[to++] = s[i];\n}")
    void getChars(char[] dst, int dstBegin) {
        System.arraycopy(this.toCharArray(), String.offset(), dst, dstBegin, this.length());
    }

    @JavaScriptBody(args={"beg", "end", "arr", "dst"}, body="var s = this.toString();\nwhile (beg < end) {\n  arr[dst++] = s.charCodeAt(beg++);\n}\n")
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.length()) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        System.arraycopy(this.toCharArray(), String.offset() + srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    @Deprecated
    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.length()) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        int j = dstBegin;
        int n = String.offset() + srcEnd;
        int i = String.offset() + srcBegin;
        char[] val = this.toCharArray();
        while (i < n) {
            dst[j++] = (byte)val[i++];
        }
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        String.checkUTF8(null, charsetName);
        return this.getBytes();
    }

    public byte[] getBytes() {
        int len = this.length();
        byte[] arr = new byte[len];
        int i = 0;
        for (int j = 0; j < len; ++j) {
            char v = this.charAt(j);
            if (v < '\u0080') {
                arr[i++] = (byte)v;
                continue;
            }
            if (v < '\u0800') {
                arr = System.expandArray(arr, arr.length + 1);
                arr[i++] = (byte)(0xC0 | v >> 6);
                arr[i++] = (byte)(0x80 | 0x3F & v);
                continue;
            }
            arr = System.expandArray(arr, arr.length + 2);
            arr[i++] = (byte)(0xE0 | v >> 12);
            arr[i++] = (byte)(0x80 | v >> 6 & 0x7F);
            arr[i++] = (byte)(0x80 | 0x3F & v);
        }
        return arr;
    }

    @JavaScriptBody(args={"obj"}, body="return obj != null && obj.$instOf_java_lang_String && this.toString() === obj.toString();")
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof String) {
            String anotherString = (String)anObject;
            int n = this.length();
            if (n == anotherString.length()) {
                char[] v1 = this.toCharArray();
                char[] v2 = anotherString.toCharArray();
                int i = String.offset();
                int j = anotherString.offset();
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer sb) {
        StringBuffer stringBuffer = sb;
        synchronized (stringBuffer) {
            return this.contentEquals((CharSequence)sb);
        }
    }

    public boolean contentEquals(CharSequence cs) {
        if (this.length() != cs.length()) {
            return false;
        }
        if (cs instanceof AbstractStringBuilder) {
            char[] v1 = this.toCharArray();
            char[] v2 = ((AbstractStringBuilder)cs).getValue();
            int i = String.offset();
            int j = 0;
            int n = this.length();
            while (n-- != 0) {
                if (v1[i++] == v2[j++]) continue;
                return false;
            }
            return true;
        }
        if (cs.equals(this)) {
            return true;
        }
        char[] v1 = this.toCharArray();
        int i = String.offset();
        int j = 0;
        int n = this.length();
        while (n-- != 0) {
            if (v1[i++] == cs.charAt(j++)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this == anotherString ? true : anotherString != null && anotherString.length() == this.length() && this.regionMatches(true, 0, anotherString, 0, this.length());
    }

    @Override
    public int compareTo(String anotherString) {
        int len1 = this.length();
        int len2 = anotherString.length();
        int n = Math.min(len1, len2);
        char[] v1 = this.toCharArray();
        char[] v2 = anotherString.toCharArray();
        int i = String.offset();
        int j = anotherString.offset();
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                char c1 = v1[k];
                char c2 = v2[k];
                if (c1 == c2) continue;
                return c1 - c2;
            }
        } else {
            while (n-- != 0) {
                char c2;
                char c1;
                if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    private static int offset() {
        return 0;
    }

    public int compareToIgnoreCase(String str) {
        return CASE_INSENSITIVE_ORDER.compare(this, str);
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        char[] ta = this.toCharArray();
        int to = String.offset() + toffset;
        char[] pa = other.toCharArray();
        int po = other.offset() + ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.length() - (long)len || (long)ooffset > (long)other.length() - (long)len) {
            return false;
        }
        while (len-- > 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        char[] ta = this.toCharArray();
        int to = String.offset() + toffset;
        char[] pa = other.toCharArray();
        int po = other.offset() + ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.length() - (long)len || (long)ooffset > (long)other.length() - (long)len) {
            return false;
        }
        while (len-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = ta[to++]) == (c2 = pa[po++]) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
        }
        return true;
    }

    @JavaScriptBody(args={"find", "from"}, body="find = find.toString();\nreturn this.toString().substring(from, from + find.length) === find;\n")
    public boolean startsWith(String prefix, int toffset) {
        char[] ta = this.toCharArray();
        int to = String.offset() + toffset;
        char[] pa = prefix.toCharArray();
        int po = prefix.offset();
        int pc = prefix.length();
        if (toffset < 0 || toffset > this.length() - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public int hashCode() {
        return super.hashCode();
    }

    int computeHashCode() {
        int h = 0;
        if (h == 0 && this.length() > 0) {
            int off = String.offset();
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                h = 31 * h + this.charAt(off++);
            }
        }
        return h;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    @JavaScriptBody(args={"ch", "from"}, body="if (typeof ch === 'number') ch = String.fromCharCode(ch);\nreturn this.toString().indexOf(ch, from);\n")
    public int indexOf(int ch, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.length()) {
            return -1;
        }
        if (ch < 65536) {
            char[] value = this.toCharArray();
            int offset = this.offset();
            int max = offset + this.length();
            for (int i = offset + fromIndex; i < max; ++i) {
                if (value[i] != ch) continue;
                return i - offset;
            }
            return -1;
        }
        return this.indexOfSupplementary(ch, fromIndex);
    }

    private int indexOfSupplementary(int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char[] value = this.toCharArray();
            int offset = this.offset();
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            int max = offset + this.length() - 1;
            for (int i = offset + fromIndex; i < max; ++i) {
                if (value[i] != hi || value[i + 1] != lo) continue;
                return i - offset;
            }
        }
        return -1;
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length() - 1);
    }

    @JavaScriptBody(args={"ch", "from"}, body="if (typeof ch === 'number') ch = String.fromCharCode(ch);\nreturn this.toString().lastIndexOf(ch, from);")
    public int lastIndexOf(int ch, int fromIndex) {
        if (ch < 65536) {
            char[] value = this.toCharArray();
            int offset = this.offset();
            for (int i = offset + Math.min(fromIndex, this.length() - 1); i >= offset; --i) {
                if (value[i] != ch) continue;
                return i - offset;
            }
            return -1;
        }
        return this.lastIndexOfSupplementary(ch, fromIndex);
    }

    private int lastIndexOfSupplementary(int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char[] value = this.toCharArray();
            int offset = this.offset();
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            for (int i = offset + Math.min(fromIndex, this.length() - 2); i >= offset; --i) {
                if (value[i] != hi || value[i + 1] != lo) continue;
                return i - offset;
            }
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    @JavaScriptBody(args={"str", "fromIndex"}, body="return this.toString().indexOf(str.toString(), fromIndex);")
    public native int indexOf(String var1, int var2);

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.length());
    }

    @JavaScriptBody(args={"s", "from"}, body="return this.toString().lastIndexOf(s.toString(), from);")
    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.toCharArray(), String.offset(), this.length(), str.toCharArray(), str.offset(), str.length(), fromIndex);
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public String substring(int beginIndex) {
        return this.substring(beginIndex, this.length());
    }

    @JavaScriptBody(args={"beginIndex", "endIndex"}, body="return this.toString().substring(beginIndex, endIndex);")
    public String substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        return beginIndex == 0 && endIndex == this.length() ? this : new String(this.toCharArray(), String.offset() + beginIndex, endIndex - beginIndex);
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public String concat(String str) {
        int otherLen = str.length();
        if (otherLen == 0) {
            return this;
        }
        char[] buf = new char[this.length() + otherLen];
        this.getChars(0, this.length(), buf, 0);
        str.getChars(0, otherLen, buf, this.length());
        return new String(buf, 0, this.length() + otherLen);
    }

    @JavaScriptBody(args={"arg1", "arg2"}, body="if (typeof arg1 === 'number') arg1 = String.fromCharCode(arg1);\nif (typeof arg2 === 'number') arg2 = String.fromCharCode(arg2);\nvar s = this.toString();\nfor (;;) {\n  var ret = s.replace(arg1, arg2);\n  if (ret === s) {\n    return ret;\n  }\n  s = ret;\n}")
    public String replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            int len = this.length();
            int i = -1;
            char[] val = this.toCharArray();
            int off = String.offset();
            while (++i < len && val[off + i] != oldChar) {
            }
            if (i < len) {
                char[] buf = new char[len];
                for (int j = 0; j < i; ++j) {
                    buf[j] = val[off + j];
                }
                while (i < len) {
                    char c = val[off + i];
                    buf[i] = c == oldChar ? newChar : c;
                    ++i;
                }
                return new String(buf, 0, len);
            }
        }
        return this;
    }

    public boolean matches(String regex) {
        try {
            return this.matchesViaJS(regex);
        }
        catch (Throwable t) {
            try {
                Method m = Class.forName("java.util.regex.Pattern").getMethod("matches", String.class, CharSequence.class);
                return (Boolean)m.invoke(null, regex, this);
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getTargetException();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(t);
        }
    }

    @JavaScriptBody(args={"regex"}, body="var self = this.toString();\nvar re = new RegExp(regex.toString());\nvar r = re.exec(self);\nreturn r != null && r.length > 0 && self.length == r[0].length;")
    private boolean matchesViaJS(String regex) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) > -1;
    }

    @JavaScriptBody(args={"regex", "newText"}, body="var self = this.toString();\nvar re = new RegExp(regex.toString());\nvar r = re.exec(self);\nif (r === null || r.length === 0) return this;\nvar from = self.indexOf(r[0]);\nreturn this.substring(0, from) + newText + this.substring(from + r[0].length);\n")
    public String replaceFirst(String regex, String replacement) {
        throw new UnsupportedOperationException();
    }

    public String replaceAll(String regex, String replacement) {
        String p = this;
        String n;
        while ((n = p.replaceFirst(regex, replacement)) != p) {
            p = n;
        }
        return n;
    }

    @JavaScriptBody(args={"target", "replacement"}, body="var s = this.toString();\ntarget = target.toString();\nreplacement = replacement.toString();\nvar pos = 0;\nfor (;;) {\n  var indx = s.indexOf(target, pos);\n  if (indx === -1) {\n    return s;\n  }\n  pos = indx + replacement.length;\n  s = s.substring(0, indx) + replacement + s.substring(indx + target.length);\n}")
    public native String replace(CharSequence var1, CharSequence var2);

    public String[] split(String regex, int limit) {
        if (limit <= 0) {
            Object[] arr = String.splitImpl(this, regex, Integer.MAX_VALUE);
            int to = arr.length;
            if (limit == 0 && to > 0) {
                while (to > 0 && ((String)arr[--to]).isEmpty()) {
                }
                ++to;
            }
            String[] ret = new String[to];
            System.arraycopy(arr, 0, ret, 0, to);
            return ret;
        }
        Object[] arr = String.splitImpl(this, regex, limit);
        String[] ret = new String[arr.length];
        int pos = 0;
        for (int i = 0; i < arr.length; ++i) {
            String s;
            ret[i] = s = (String)arr[i];
            pos = this.indexOf(s, pos) + s.length();
        }
        int n = arr.length - 1;
        ret[n] = ret[n] + this.substring(pos);
        return ret;
    }

    @JavaScriptBody(args={"str", "regex", "limit"}, body="return str.split(new RegExp(regex), limit);")
    private static native Object[] splitImpl(String var0, String var1, int var2);

    public String[] split(String regex) {
        return this.split(regex, 0);
    }

    public String toLowerCase(Locale locale) {
        return this.toLowerCase();
    }

    @JavaScriptBody(args={}, body="return this.toLowerCase();")
    public String toLowerCase() {
        return null;
    }

    public String toUpperCase(Locale locale) {
        return this.toUpperCase();
    }

    @JavaScriptBody(args={}, body="return this.toUpperCase();")
    public String toUpperCase() {
        return null;
    }

    public String trim() {
        int st;
        int len = this.length();
        int off = String.offset();
        char[] val = this.toCharArray();
        for (st = 0; st < len && val[off + st] <= ' '; ++st) {
        }
        while (st < len && val[off + len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < this.length() ? this.substring(st, len) : this;
    }

    @Override
    @JavaScriptBody(args={}, body="return this.toString();")
    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] result = new char[this.length()];
        this.getChars(0, this.length(), result, 0);
        return result;
    }

    public static String format(String format, Object ... args) {
        return String.format((Locale)null, format, args);
    }

    public static String format(Locale l, String format, Object ... args) {
        String p = format;
        for (int i = 0; i < args.length; ++i) {
            String v = args[i] == null ? "null" : args[i].toString();
            p = p.replaceFirst("%s", v);
        }
        return p;
    }

    public static String valueOf(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static String valueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data) {
        return String.copyValueOf(data, 0, data.length);
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] data = new char[]{c};
        return new String(data, 0, 1);
    }

    public static String valueOf(int i) {
        return Integer.toString(i);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    @JavaScriptBody(args={}, body="var s = this.toString().toString();\nvar i = String.intern || (String.intern = {})\nif (!i[s]) {\n  i[s] = s;\n}\nreturn i[s];")
    public native String intern();

    private static <T> T checkUTF8(T data, String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            throw new NullPointerException("charsetName");
        }
        if (!charsetName.equalsIgnoreCase("UTF-8") && !charsetName.equalsIgnoreCase("UTF8")) {
            throw new UnsupportedEncodingException(charsetName);
        }
        return data;
    }

    private static int nextChar(byte[] arr, int[] index) throws IndexOutOfBoundsException {
        int n = index[0];
        index[0] = n + 1;
        int c = arr[n] & 0xFF;
        switch (c >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return c;
            }
            case 12: 
            case 13: {
                int n2 = index[0];
                index[0] = n2 + 1;
                byte char2 = arr[n2];
                if ((char2 & 0xC0) != 128) {
                    throw new IndexOutOfBoundsException("malformed input");
                }
                return (c & 0x1F) << 6 | char2 & 0x3F;
            }
            case 14: {
                int n3 = index[0];
                index[0] = n3 + 1;
                byte char2 = arr[n3];
                int n4 = index[0];
                index[0] = n4 + 1;
                byte char3 = arr[n4];
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new IndexOutOfBoundsException("malformed input");
                }
                return (c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0;
            }
        }
        throw new IndexOutOfBoundsException("malformed input");
    }

    static {
        String.registerToString();
        CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int n1 = s1.length();
            int n2 = s2.length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }
}

