/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.emul.reflect.AnnotationImpl;
import org.apidesign.bck2brwsr.emul.reflect.MethodImpl;

public final class Class<T>
implements Serializable,
GenericDeclaration,
Type,
AnnotatedElement {
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int SYNTHETIC = 4096;

    private Class() {
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        if (className.startsWith("[")) {
            Class<?> arrType;
            Class<?> c = arrType = Class.defineArray(className);
            while (c != null && c.isArray()) {
                c = super.getComponentType0();
            }
            return arrType;
        }
        try {
            Class<?> c = Class.loadCls(className, className.replace('.', '_'));
            if (c == null) {
                throw new ClassNotFoundException(className);
            }
            return c;
        }
        catch (Throwable ex) {
            throw new ClassNotFoundException(className, ex);
        }
    }

    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(name);
    }

    @JavaScriptBody(args={"n", "c"}, body="if (!vm[c]) {\n  if (vm.loadClass) {\n    vm.loadClass(n);\n  }\n  if (!vm[c]) return null;\n}\nvm[c](false);return vm[c].$class;")
    private static native Class<?> loadCls(String var0, String var1);

    @JavaScriptBody(args={"self", "illegal"}, body="\nvar c = self.cnstr;\nif (c['cons__V']) {\n  if ((c.cons__V.access & 0x1) != 0) {\n    var inst = c();\n    c.cons__V.call(inst);\n    return inst;\n  }\n  return illegal;\n}\nreturn null;")
    private static native Object newInstance0(Class<?> var0, Object var1);

    public T newInstance() throws InstantiationException, IllegalAccessException {
        Object illegal = new Object();
        Object inst = Class.newInstance0(this, illegal);
        if (inst == null) {
            throw new InstantiationException(this.getName());
        }
        if (inst == illegal) {
            throw new IllegalAccessException();
        }
        return (T)inst;
    }

    public boolean isInstance(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.isArray()) {
            return this.isAssignableFrom(obj.getClass());
        }
        String prop = "$instOf_" + this.getName().replace('.', '_');
        return Class.hasProperty(obj, prop);
    }

    @JavaScriptBody(args={"who", "prop"}, body="if (who[prop]) return true; else return false;")
    private static native boolean hasProperty(Object var0, String var1);

    public boolean isAssignableFrom(Class<?> cls) {
        if (this == cls) {
            return true;
        }
        if (this.isArray()) {
            Class<?> cmpType = cls.getComponentType();
            if (this.isPrimitive()) {
                return this == cmpType;
            }
            return cmpType != null && this.getComponentType().isAssignableFrom(cmpType);
        }
        if (this.isPrimitive()) {
            return false;
        }
        if (cls.isPrimitive()) {
            return false;
        }
        String prop = "$instOf_" + this.getName().replace('.', '_');
        return Class.hasCnstrProperty(cls, prop);
    }

    @JavaScriptBody(args={"who", "prop"}, body="if (who.cnstr.prototype[prop]) return true; else return false;")
    private static native boolean hasCnstrProperty(Object var0, String var1);

    public boolean isInterface() {
        return (this.getAccess() & 0x200) != 0;
    }

    @JavaScriptBody(args={}, body="return this.access;")
    private native int getAccess();

    public boolean isArray() {
        return Class.hasProperty(this, "array");
    }

    @JavaScriptBody(args={}, body="if (this.primitive) return true;else return false;")
    public native boolean isPrimitive();

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public String getName() {
        return this.jvmName().replace('/', '.');
    }

    @JavaScriptBody(args={}, body="return this.jvmName;")
    private native String jvmName();

    public TypeVariable<Class<T>>[] getTypeParameters() {
        throw new UnsupportedOperationException();
    }

    @JavaScriptBody(args={}, body="return this.superclass;")
    public native Class<? super T> getSuperclass();

    public int getModifiers() {
        return this.getAccess();
    }

    public Class<?> getDeclaringClass() {
        throw new SecurityException();
    }

    public String getSimpleName() {
        int index;
        if (this.isArray()) {
            return this.getComponentType().getSimpleName() + "[]";
        }
        String simpleName = this.getSimpleBinaryName();
        if (simpleName == null) {
            simpleName = this.getName();
            return simpleName.substring(simpleName.lastIndexOf(".") + 1);
        }
        int length = simpleName.length();
        if (length < 1 || simpleName.charAt(0) != '$') {
            throw new IllegalStateException("Malformed class name");
        }
        for (index = 1; index < length && Class.isAsciiDigit(simpleName.charAt(index)); ++index) {
        }
        return simpleName.substring(index);
    }

    private String getSimpleBinaryName() {
        Class enclosingClass = null;
        if (enclosingClass == null) {
            return null;
        }
        try {
            return this.getName().substring(enclosingClass.getName().length());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException("Malformed class name");
        }
    }

    public Field[] getFields() throws SecurityException {
        throw new SecurityException();
    }

    public Method[] getMethods() throws SecurityException {
        return MethodImpl.findMethods(this, 1);
    }

    public Field getField(String name) throws SecurityException {
        throw new SecurityException();
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Method m = MethodImpl.findMethod(this, name, parameterTypes);
        if (m == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName()).append('.').append(name).append('(');
            String sep = "";
            for (int i = 0; i < parameterTypes.length; ++i) {
                sb.append(sep).append(parameterTypes[i].getName());
                sep = ", ";
            }
            sb.append(')');
            throw new NoSuchMethodException(sb.toString());
        }
        return m;
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        throw new SecurityException();
    }

    public Field[] getDeclaredFields() throws SecurityException {
        throw new SecurityException();
    }

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        try {
            return this.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new SecurityException();
        }
    }

    public Field getDeclaredField(String name) throws SecurityException {
        throw new SecurityException();
    }

    public Constructor<?>[] getConstructors() throws SecurityException {
        return MethodImpl.findConstructors(this, 1);
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Constructor c = MethodImpl.findConstructor(this, parameterTypes);
        if (c == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName()).append('(');
            String sep = "";
            for (int i = 0; i < parameterTypes.length; ++i) {
                sb.append(sep).append(parameterTypes[i].getName());
                sep = ", ";
            }
            sb.append(')');
            throw new NoSuchMethodException(sb.toString());
        }
        return c;
    }

    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        throw new SecurityException();
    }

    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getConstructor(parameterTypes);
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public String getCanonicalName() {
        if (this.isArray()) {
            String canonicalName = this.getComponentType().getCanonicalName();
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        Class enclosingClass = null;
        if (enclosingClass == null) {
            return this.getName();
        }
        String enclosingName = enclosingClass.getCanonicalName();
        if (enclosingName == null) {
            return null;
        }
        return enclosingName + "." + this.getSimpleName();
    }

    public InputStream getResourceAsStream(String name) {
        byte[] arr = ClassLoader.getResourceAsStream0(name = this.resolveName(name), 0);
        return arr == null ? null : new ByteArrayInputStream(arr);
    }

    public URL getResource(String name) {
        return Class.newResourceURL(name, this.getResourceAsStream(name));
    }

    static URL newResourceURL(String name, InputStream is) {
        return is == null ? null : Class.newResourceURL0(URL.class, "res:/" + name, is);
    }

    @JavaScriptBody(args={"url", "spec", "is"}, body="var u = url.cnstr(true);\nu.constructor.cons__VLjava_lang_String_2Ljava_io_InputStream_2.call(u, spec, is);\nreturn u;")
    private static native URL newResourceURL0(Class<URL> var0, String var1, InputStream var2);

    private String resolveName(String name) {
        if (name == null) {
            return name;
        }
        if (!name.startsWith("/")) {
            Class<?> c = this;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + name;
            }
        } else {
            name = name.substring(1);
        }
        return name;
    }

    public ClassLoader getClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public native Class<?>[] getInterfaces();

    public Class<?> getComponentType() {
        if (this.isArray()) {
            try {
                return this.getComponentType0();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException(cnfe);
            }
        }
        return null;
    }

    private Class<?> getComponentType0() throws ClassNotFoundException {
        String n = this.getName().substring(1);
        switch (n.charAt(0)) {
            case 'L': {
                n = n.substring(1, n.length() - 1);
                return Class.forName(n);
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case '[': {
                return Class.defineArray(n);
            }
        }
        throw new ClassNotFoundException("Unknown component type of " + this.getName());
    }

    @JavaScriptBody(args={"sig"}, body="if (!sig) sig = '[Ljava/lang/Object;';\nvar c = Array[sig];\nif (c) return c;\nc = vm.java_lang_Class(true);\nc.jvmName = sig;\nc.superclass = vm.java_lang_Object(false).$class;\nc.array = true;\nArray[sig] = c;\nreturn c;")
    private static native Class<?> defineArray(String var0);

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0 && this.getSuperclass() == Enum.class;
    }

    public T cast(Object obj) {
        if (obj != null && !this.isInstance(obj)) {
            throw new ClassCastException(this.cannotCastMsg(obj));
        }
        return (T)obj;
    }

    private String cannotCastMsg(Object obj) {
        return "Cannot cast " + obj.getClass().getName() + " to " + this.getName();
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (clazz.isAssignableFrom(this)) {
            return this;
        }
        throw new ClassCastException(this.toString());
    }

    @JavaScriptBody(args={"ac"}, body="if (this.anno) {\n  var r = this.anno['L' + ac.jvmName + ';'];\n  if (typeof r === 'undefined') r = null;\n  return r;\n} else return null;\n")
    private Object getAnnotationData(Class<?> annotationClass) {
        throw new UnsupportedOperationException();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Object data = this.getAnnotationData(annotationClass);
        return data == null ? null : (A)AnnotationImpl.create(annotationClass, data);
    }

    @Override
    @JavaScriptBody(args={"ac"}, body="if (this.anno && this.anno['L' + ac.jvmName + ';']) { return true; }else return false;")
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        return this.getAnnotation((Class)annotationClass) != null;
    }

    @JavaScriptBody(args={}, body="return this.anno;")
    private Object getAnnotationData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation[] getAnnotations() {
        Object data = this.getAnnotationData();
        return data == null ? new Annotation[]{} : AnnotationImpl.create(data);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new UnsupportedOperationException();
    }

    @JavaScriptBody(args={"type"}, body="var c = vm.java_lang_Class(true);c.jvmName = type;c.primitive = true;return c;")
    static native Class getPrimitiveClass(String var0);

    @JavaScriptBody(args={}, body="return vm.desiredAssertionStatus ? vm.desiredAssertionStatus : false;")
    public native boolean desiredAssertionStatus();
}

