/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;

public abstract class Reader
implements Readable,
Closeable {
    protected Object lock;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        if (lock == null) {
            throw new NullPointerException();
        }
        this.lock = lock;
    }

    public int read() throws IOException {
        char[] cb = new char[1];
        if (this.read(cb, 0, 1) == -1) {
            return -1;
        }
        return cb[0];
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        int nn = (int)Math.min(n, 8192L);
        Object object = this.lock;
        synchronized (object) {
            long r;
            int nc;
            if (this.skipBuffer == null || this.skipBuffer.length < nn) {
                this.skipBuffer = new char[nn];
            }
            for (r = n; r > 0L && (nc = this.read(this.skipBuffer, 0, (int)Math.min(r, (long)nn))) != -1; r -= (long)nc) {
            }
            return n - r;
        }
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public abstract void close() throws IOException;
}

