/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;

public class OutputStreamWriter
extends Writer {
    public OutputStreamWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        super(out);
        if (charsetName == null) {
            throw new NullPointerException("charsetName");
        }
        if (!charsetName.toUpperCase().equals("UTF-8")) {
            throw new UnsupportedEncodingException(charsetName);
        }
    }

    public OutputStreamWriter(OutputStream out) {
        super(out);
    }

    public OutputStreamWriter(OutputStream out, Charset cs) {
        this(out);
    }

    public String getEncoding() {
        return "UTF-8";
    }

    void flushBuffer() throws IOException {
        this.out().flush();
    }

    @Override
    public void write(int c) throws IOException {
        if (c <= 127) {
            this.out().write(c);
        } else if (c <= 2047) {
            this.out().write(0xC0 | c >> 6);
            this.out().write(0x80 | c & 0x3F);
        } else {
            this.out().write(0xE0 | c >> 12);
            this.out().write(0x80 | c >> 6 & 0x3F);
            this.out().write(0x80 | c & 0x3F);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        while (len-- > 0) {
            this.write(cbuf[off++]);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        while (len-- > 0) {
            this.write(str.charAt(off++));
        }
    }

    @Override
    public void flush() throws IOException {
        this.out().flush();
    }

    @Override
    public void close() throws IOException {
        this.out().close();
    }

    private OutputStream out() {
        return (OutputStream)this.lock;
    }
}

