/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class File
implements Serializable,
Comparable<File> {
    private static FileSystem fs = new FileSystem();
    private String path;
    private transient int prefixLength;
    public static final char separatorChar = FileSystem.access$100(fs);
    public static final String separator = "" + separatorChar;
    public static final char pathSeparatorChar = FileSystem.access$200(fs);
    public static final String pathSeparator = "" + pathSeparatorChar;
    private static final long serialVersionUID = 301077366599181567L;

    int getPrefixLength() {
        return this.prefixLength;
    }

    private File(String pathname, int prefixLength) {
        this.path = pathname;
        this.prefixLength = prefixLength;
    }

    private File(String child, File parent) {
        assert (parent.path != null);
        assert (!parent.path.equals(""));
        this.path = File.fs.resolve(parent.path, child);
        this.prefixLength = parent.prefixLength;
    }

    public File(String pathname) {
        if (pathname == null) {
            throw new NullPointerException();
        }
        this.path = File.fs.normalize(pathname);
        this.prefixLength = File.fs.prefixLength(this.path);
    }

    public File(String parent, String child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.path = parent != null ? (parent.equals("") ? File.fs.resolve(File.fs.getDefaultParent(), File.fs.normalize(child)) : File.fs.resolve(File.fs.normalize(parent), File.fs.normalize(child))) : File.fs.normalize(child);
        this.prefixLength = File.fs.prefixLength(this.path);
    }

    public File(File parent, String child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.path = parent != null ? (parent.path.equals("") ? File.fs.resolve(File.fs.getDefaultParent(), File.fs.normalize(child)) : File.fs.resolve(parent.path, File.fs.normalize(child))) : File.fs.normalize(child);
        this.prefixLength = File.fs.prefixLength(this.path);
    }

    public File(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uri.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uri.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String p = uri.getPath();
        if (p.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        p = File.fs.fromURIPath(p);
        if (separatorChar != '/') {
            p = p.replace('/', separatorChar);
        }
        this.path = File.fs.normalize(p);
        this.prefixLength = File.fs.prefixLength(this.path);
    }

    public String getName() {
        int index = this.path.lastIndexOf(separatorChar);
        if (index < this.prefixLength) {
            return this.path.substring(this.prefixLength);
        }
        return this.path.substring(index + 1);
    }

    public String getParent() {
        int index = this.path.lastIndexOf(separatorChar);
        if (index < this.prefixLength) {
            if (this.prefixLength > 0 && this.path.length() > this.prefixLength) {
                return this.path.substring(0, this.prefixLength);
            }
            return null;
        }
        return this.path.substring(0, index);
    }

    public File getParentFile() {
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        return new File(p, this.prefixLength);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return File.fs.isAbsolute(this);
    }

    public String getAbsolutePath() {
        throw new SecurityException();
    }

    public File getAbsoluteFile() {
        String absPath = this.getAbsolutePath();
        return new File(absPath, File.fs.prefixLength(absPath));
    }

    public String getCanonicalPath() throws IOException {
        throw new SecurityException();
    }

    public File getCanonicalFile() throws IOException {
        String canonPath = this.getCanonicalPath();
        return new File(canonPath, File.fs.prefixLength(canonPath));
    }

    private static String slashify(String path, boolean isDirectory) {
        String p = path;
        if (separatorChar != '/') {
            p = p.replace(separatorChar, '/');
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.endsWith("/") && isDirectory) {
            p = p + "/";
        }
        return p;
    }

    @Deprecated
    public URL toURL() throws MalformedURLException {
        return new URL("file", "", File.slashify(this.getAbsolutePath(), this.isDirectory()));
    }

    public URI toURI() {
        try {
            File f = this.getAbsoluteFile();
            String sp = File.slashify(f.getPath(), f.isDirectory());
            if (sp.startsWith("//")) {
                sp = "//" + sp;
            }
            return new URI("file", null, sp, null);
        }
        catch (URISyntaxException x) {
            throw new Error(x);
        }
    }

    public boolean canRead() {
        throw new SecurityException();
    }

    public boolean canWrite() {
        throw new SecurityException();
    }

    public boolean exists() {
        throw new SecurityException();
    }

    public boolean isDirectory() {
        throw new SecurityException();
    }

    public boolean isFile() {
        throw new SecurityException();
    }

    public boolean isHidden() {
        throw new SecurityException();
    }

    public long lastModified() {
        throw new SecurityException();
    }

    public long length() {
        throw new SecurityException();
    }

    public boolean createNewFile() throws IOException {
        throw new SecurityException();
    }

    public boolean delete() {
        throw new SecurityException();
    }

    public void deleteOnExit() {
        throw new SecurityException();
    }

    public String[] list() {
        throw new SecurityException();
    }

    public String[] list(FilenameFilter filter) {
        throw new SecurityException();
    }

    public File[] listFiles() {
        throw new SecurityException();
    }

    public File[] listFiles(FilenameFilter filter) {
        throw new SecurityException();
    }

    public File[] listFiles(FileFilter filter) {
        throw new SecurityException();
    }

    public boolean mkdir() {
        throw new SecurityException();
    }

    public boolean mkdirs() {
        throw new SecurityException();
    }

    public boolean renameTo(File dest) {
        throw new SecurityException();
    }

    public boolean setLastModified(long time) {
        throw new SecurityException();
    }

    public boolean setReadOnly() {
        throw new SecurityException();
    }

    public boolean setWritable(boolean writable, boolean ownerOnly) {
        throw new SecurityException();
    }

    public boolean setWritable(boolean writable) {
        return this.setWritable(writable, true);
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) {
        throw new SecurityException();
    }

    public boolean setReadable(boolean readable) {
        return this.setReadable(readable, true);
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        throw new SecurityException();
    }

    public boolean setExecutable(boolean executable) {
        return this.setExecutable(executable, true);
    }

    public boolean canExecute() {
        throw new SecurityException();
    }

    public static File[] listRoots() {
        throw new SecurityException();
    }

    public long getTotalSpace() {
        throw new SecurityException();
    }

    public long getFreeSpace() {
        throw new SecurityException();
    }

    public long getUsableSpace() {
        throw new SecurityException();
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        throw new SecurityException();
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }

    @Override
    public int compareTo(File pathname) {
        return File.fs.compare(this, pathname);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof File) {
            return this.compareTo((File)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return File.fs.hashCode(this);
    }

    public String toString() {
        return this.getPath();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeChar(separatorChar);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        String pathField = (String)fields.get("path", null);
        char sep = s.readChar();
        if (sep != separatorChar) {
            pathField = pathField.replace(sep, separatorChar);
        }
        this.path = File.fs.normalize(pathField);
        this.prefixLength = File.fs.prefixLength(this.path);
    }

    private static class FileSystem {
        private FileSystem() {
        }

        private char getSeparator() {
            return '/';
        }

        private String resolve(String path, String child) {
            return path + '/' + child;
        }

        private String normalize(String pathname) {
            return pathname;
        }

        private int prefixLength(String path) {
            return 0;
        }

        private String getDefaultParent() {
            return "/";
        }

        private String fromURIPath(String p) {
            return p;
        }

        private boolean isAbsolute(File aThis) {
            return aThis.getPath().startsWith("/");
        }

        private int compare(File one, File two) {
            return one.getPath().compareTo(two.getPath());
        }

        private int hashCode(File aThis) {
            return aThis.getPath().hashCode();
        }

        private char getPathSeparator() {
            return ':';
        }

        static /* synthetic */ char access$100(FileSystem x0) {
            return x0.getSeparator();
        }

        static /* synthetic */ char access$200(FileSystem x0) {
            return x0.getPathSeparator();
        }
    }
}

