/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Enumeration;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.emul.reflect.AnnotationImpl;
import org.apidesign.bck2brwsr.emul.reflect.MethodImpl;

public final class Method
extends AccessibleObject
implements GenericDeclaration,
Member {
    private final Class<?> clazz;
    private final String name;
    private final Object data;
    private final String sig;

    private String getGenericSignature() {
        return null;
    }

    Method(Class<?> declaringClass, String name, Object data, String sig) {
        this.clazz = declaringClass;
        this.name = name;
        this.data = data;
        this.sig = sig;
    }

    Method copy() {
        return this;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return Method.getAccess(this.data);
    }

    @JavaScriptBody(args={"self"}, body="return self.access;")
    private static native int getAccess(Object var0);

    public TypeVariable<Method>[] getTypeParameters() {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnType() {
        return MethodImpl.signatureParser(this.sig).nextElement();
    }

    public Type getGenericReturnType() {
        throw new UnsupportedOperationException();
    }

    public Class<?>[] getParameterTypes() {
        Class[] arr = new Class[MethodImpl.signatureElements(this.sig) - 1];
        Enumeration<Class> en = MethodImpl.signatureParser(this.sig);
        en.nextElement();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = en.nextElement();
        }
        return arr;
    }

    public Type[] getGenericParameterTypes() {
        throw new UnsupportedOperationException();
    }

    public Class<?>[] getExceptionTypes() {
        throw new UnsupportedOperationException();
    }

    public Type[] getGenericExceptionTypes() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Method) {
            Method other = (Method)obj;
            return this.data == other.data;
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            int mod = this.getModifiers() & Modifier.methodModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod)).append(' ');
            }
            sb.append(Field.getTypeName(this.getReturnType())).append(' ');
            sb.append(Field.getTypeName(this.getDeclaringClass())).append('.');
            sb.append(this.getName()).append('(');
            Class<?>[] params = this.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(Field.getTypeName(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public String toGenericString() {
        try {
            Type genRetType;
            TypeVariable<Method>[] typeparms;
            StringBuilder sb = new StringBuilder();
            int mod = this.getModifiers() & Modifier.methodModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod)).append(' ');
            }
            if ((typeparms = this.getTypeParameters()).length > 0) {
                boolean first = true;
                sb.append('<');
                for (TypeVariable<Method> typeparm : typeparms) {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append(typeparm.toString());
                    first = false;
                }
                sb.append("> ");
            }
            sb.append((genRetType = this.getGenericReturnType()) instanceof Class ? Field.getTypeName((Class)genRetType) : genRetType.toString()).append(' ');
            sb.append(Field.getTypeName(this.getDeclaringClass())).append('.');
            sb.append(this.getName()).append('(');
            Type[] params = this.getGenericParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                String param;
                String string = param = params[j] instanceof Class ? Field.getTypeName((Class)params[j]) : params[j].toString();
                if (this.isVarArgs() && j == params.length - 1) {
                    param = param.replaceFirst("\\[\\]$", "...");
                }
                sb.append(param);
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            Type[] exceptions = this.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k] instanceof Class ? ((Class)exceptions[k]).getName() : exceptions[k].toString());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(',');
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public Object invoke(Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean nonStatic;
        boolean bl = nonStatic = (this.getModifiers() & 8) == 0;
        if (nonStatic && obj == null) {
            throw new NullPointerException();
        }
        Class<?>[] types = this.getParameterTypes();
        if (types.length != args.length) {
            throw new IllegalArgumentException("Types len " + types.length + " args: " + args.length);
        }
        args = (Object[])args.clone();
        for (int i = 0; i < types.length; ++i) {
            Class<?> c = types[i];
            if (!c.isPrimitive() || args[i] == null) continue;
            args[i] = Method.toPrimitive(args[i]);
        }
        Object res = Method.invokeTry(nonStatic, this, obj, args);
        if (this.getReturnType().isPrimitive()) {
            res = Method.fromPrimitive(this.getReturnType(), res);
        }
        return res;
    }

    @JavaScriptBody(args={"st", "method", "self", "args"}, body="var p;\nif (st) {\n  p = new Array(1);\n  p[0] = self;\n  p = p.concat(args);\n} else {\n  p = args;\n}\nreturn method._data().apply(self, p);\n")
    private static native Object invoke0(boolean var0, Method var1, Object var2, Object[] var3);

    private static Object invokeTry(boolean isStatic, Method m, Object self, Object[] args) throws InvocationTargetException {
        try {
            return Method.invoke0(isStatic, m, self, args);
        }
        catch (Throwable ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
    }

    static Object fromPrimitive(Class<?> type, Object o) {
        if (type == Integer.TYPE) {
            return Method.fromRaw(Integer.class, "valueOf__Ljava_lang_Integer_2I", o);
        }
        if (type == Long.TYPE) {
            return Method.fromRaw(Long.class, "valueOf__Ljava_lang_Long_2J", o);
        }
        if (type == Double.TYPE) {
            return Method.fromRaw(Double.class, "valueOf__Ljava_lang_Double_2D", o);
        }
        if (type == Float.TYPE) {
            return Method.fromRaw(Float.class, "valueOf__Ljava_lang_Float_2F", o);
        }
        if (type == Byte.TYPE) {
            return Method.fromRaw(Byte.class, "valueOf__Ljava_lang_Byte_2B", o);
        }
        if (type == Boolean.TYPE) {
            return Method.fromRaw(Boolean.class, "valueOf__Ljava_lang_Boolean_2Z", o);
        }
        if (type == Short.TYPE) {
            return Method.fromRaw(Short.class, "valueOf__Ljava_lang_Short_2S", o);
        }
        if (type == Character.TYPE) {
            return Method.fromRaw(Character.class, "valueOf__Ljava_lang_Character_2C", o);
        }
        if (type.getName().equals("void")) {
            return null;
        }
        throw new IllegalStateException("Can't convert " + o);
    }

    @JavaScriptBody(args={"cls", "m", "o"}, body="return cls.cnstr(false)[m](o);")
    private static native Integer fromRaw(Class<?> var0, String var1, Object var2);

    @JavaScriptBody(args={"o"}, body="return o.valueOf();")
    private static native Object toPrimitive(Object var0);

    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    @JavaScriptBody(args={"ac"}, body="var a = this._data().anno;if (a) {  return a['L' + ac.jvmName + ';'];} else return null;")
    private Object getAnnotationData(Class<?> annotationClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Object data = this.getAnnotationData(annotationClass);
        return data == null ? null : (T)AnnotationImpl.create(annotationClass, data);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new UnsupportedOperationException();
    }

    public Object getDefaultValue() {
        throw new UnsupportedOperationException();
    }

    public Annotation[][] getParameterAnnotations() {
        throw new UnsupportedOperationException();
    }

    static {
        MethodImpl.INSTANCE = new MethodImpl(){

            @Override
            protected Method create(Class<?> declaringClass, String name, Object data, String sig) {
                return new Method(declaringClass, name, data, sig);
            }
        };
    }
}

