/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.Method;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.core.JavaScriptPrototype;

@JavaScriptPrototype(prototype="new Array", container="Array.prototype")
public final class Array {
    private Array() {
    }

    public static Object newInstance(Class<?> componentType, int length) throws NegativeArraySizeException {
        if (length < 0) {
            throw new NegativeArraySizeException();
        }
        String sig = Array.findSignature(componentType);
        return Array.newArray(componentType.isPrimitive(), sig, length);
    }

    private static String findSignature(Class<?> type) {
        if (type == Integer.TYPE) {
            return "[I";
        }
        if (type == Long.TYPE) {
            return "[J";
        }
        if (type == Double.TYPE) {
            return "[D";
        }
        if (type == Float.TYPE) {
            return "[F";
        }
        if (type == Byte.TYPE) {
            return "[B";
        }
        if (type == Boolean.TYPE) {
            return "[Z";
        }
        if (type == Short.TYPE) {
            return "[S";
        }
        if (type == Character.TYPE) {
            return "[C";
        }
        if (type.getName().equals("void")) {
            throw new IllegalStateException("Can't create array for " + type);
        }
        return "[L" + type.getName() + ";";
    }

    public static Object newInstance(Class<?> componentType, int ... dimensions) throws IllegalArgumentException, NegativeArraySizeException {
        StringBuilder sig = new StringBuilder();
        for (int i = 1; i < dimensions.length; ++i) {
            sig.append('[');
        }
        sig.append(Array.findSignature(componentType));
        return Array.multiNewArray(sig.toString(), dimensions, 0);
    }

    public static int getLength(Object array) throws IllegalArgumentException {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Argument is not an array");
        }
        return Array.length(array);
    }

    @JavaScriptBody(args={"arr"}, body="return arr.length;")
    private static native int length(Object var0);

    public static Object get(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t.isPrimitive()) {
            return Array.fromPrimitive(t, array, index);
        }
        return ((Object[])array)[index];
    }

    public static native boolean getBoolean(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static byte getByte(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass().getComponentType() != Byte.TYPE) {
            throw new IllegalArgumentException();
        }
        byte[] arr = (byte[])array;
        return arr[index];
    }

    public static native char getChar(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static short getShort(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Short.TYPE) {
            short[] arr = (short[])array;
            return arr[index];
        }
        return Array.getByte(array, index);
    }

    public static int getInt(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Integer.TYPE) {
            int[] arr = (int[])array;
            return arr[index];
        }
        return Array.getShort(array, index);
    }

    public static long getLong(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Long.TYPE) {
            long[] arr = (long[])array;
            return arr[index];
        }
        return Array.getInt(array, index);
    }

    public static float getFloat(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Float.TYPE) {
            float[] arr = (float[])array;
            return arr[index];
        }
        return Array.getLong(array, index);
    }

    public static double getDouble(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Double.TYPE) {
            double[] arr = (double[])array;
            return arr[index];
        }
        return Array.getFloat(array, index);
    }

    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass().getComponentType().isPrimitive()) {
            throw new IllegalArgumentException();
        }
        Object[] arr = (Object[])array;
        arr[index] = value;
    }

    public static native void setBoolean(Object var0, int var1, boolean var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static void setByte(Object array, int index, byte b) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Byte.TYPE) {
            byte[] arr = (byte[])array;
            arr[index] = b;
        } else {
            Array.setShort(array, index, b);
        }
    }

    public static native void setChar(Object var0, int var1, char var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static void setShort(Object array, int index, short s) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Short.TYPE) {
            short[] arr = (short[])array;
            arr[index] = s;
        } else {
            Array.setInt(array, index, s);
        }
    }

    public static void setInt(Object array, int index, int i) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Integer.TYPE) {
            int[] arr = (int[])array;
            arr[index] = i;
        } else {
            Array.setLong(array, index, i);
        }
    }

    public static void setLong(Object array, int index, long l) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Long.TYPE) {
            long[] arr = (long[])array;
            arr[index] = l;
        } else {
            Array.setFloat(array, index, l);
        }
    }

    public static void setFloat(Object array, int index, float f) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t == Float.TYPE) {
            float[] arr = (float[])array;
            arr[index] = f;
        } else {
            Array.setDouble(array, index, f);
        }
    }

    public static void setDouble(Object array, int index, double d) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> t = array.getClass().getComponentType();
        if (t != Double.TYPE) {
            throw new IllegalArgumentException("argument type mismatch");
        }
        double[] arr = (double[])array;
        arr[index] = d;
    }

    @JavaScriptBody(args={"primitive", "sig", "length"}, body="var arr = new Array(length);\nvar value = primitive ? 0 : null;\nfor(var i = 0; i < length; i++) arr[i] = value;\narr.jvmName = sig;\nreturn arr;")
    static native Object newArray(boolean var0, String var1, int var2);

    static Object multiNewArray(String sig, int[] dims, int index) throws IllegalArgumentException, NegativeArraySizeException {
        if (dims.length == index + 1) {
            return Array.newArray(sig.length() == 2, sig, dims[index]);
        }
        Object arr = Array.newArray(false, sig, dims[index]);
        String compsig = sig.substring(1);
        int len = Array.getLength(arr);
        for (int i = 0; i < len; ++i) {
            Array.setArray(arr, i, Array.multiNewArray(compsig, dims, index + 1));
        }
        return arr;
    }

    private static Object fromPrimitive(Class<?> t, Object array, int index) {
        return Method.fromPrimitive(t, Array.atArray(array, index));
    }

    @JavaScriptBody(args={"array", "index"}, body="return array[index];")
    private static native Object atArray(Object var0, int var1);

    @JavaScriptBody(args={"array", "index", "v"}, body="array[index] = v;")
    private static native Object setArray(Object var0, int var1, Object var2);
}

