/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import org.apidesign.bck2brwsr.core.JavaScriptBody;

public final class Double
extends Number
implements Comparable<Double> {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_NORMAL = 2.2250738585072014E-308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_EXPONENT = -1022;
    public static final int SIZE = 64;
    public static final Class<Double> TYPE = Class.getPrimitiveClass("double");
    private final double value;
    private static final long serialVersionUID = -9172774392245257468L;

    @JavaScriptBody(args={"d"}, body="var f = Math.floor(d);\nvar r = d.toString();if (f === d && isFinite(d) && r.indexOf('e') === -1) return r + '.0';\n else return r;")
    public static native String toString(double var0);

    public static String toHexString(double d) {
        throw new UnsupportedOperationException();
    }

    @JavaScriptBody(args={"s"}, body="return parseFloat(s);")
    public static Double valueOf(String s) throws NumberFormatException {
        throw new UnsupportedOperationException();
    }

    public static Double valueOf(double d) {
        return new Double(d);
    }

    @JavaScriptBody(args={"s"}, body="return parseFloat(s);")
    public static double parseDouble(String s) throws NumberFormatException {
        throw new UnsupportedOperationException();
    }

    public static boolean isNaN(double v) {
        return v != v;
    }

    public static boolean isInfinite(double v) {
        return v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY;
    }

    public Double(double value) {
        this.value = value;
    }

    public Double(String s) throws NumberFormatException {
        this(Double.valueOf(s));
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof Double && ((Double)obj).value == this.value;
    }

    public static long doubleToLongBits(double value) {
        long EXP_BIT_MASK = 0x7FF0000000000000L;
        long SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
        long result = Double.doubleToRawLongBits(value);
        if ((result & 0x7FF0000000000000L) == 0x7FF0000000000000L && (result & 0xFFFFFFFFFFFFFL) != 0L) {
            result = 9221120237041090560L;
        }
        return result;
    }

    public static long doubleToRawLongBits(double value) {
        int[] arr = new int[]{0, 0};
        Double.doubleToRawLongBits(value, arr);
        long l = arr[1];
        return l << 32 | (long)arr[0];
    }

    @JavaScriptBody(args={"value", "arr"}, body="var a = new ArrayBuffer(8);new Float64Array(a)[0] = value;var out = new Int32Array(a);arr[0] = out[0];arr[1] = out[1];")
    private static native void doubleToRawLongBits(double var0, int[] var2);

    @JavaScriptBody(args={"bits"}, body="var hi = bits.high32();\nvar s = (hi & 0x80000000) === 0 ? 1 : -1;\nvar e = (hi >> 20) & 0x7ff;\nif (e === 0x7ff) {\n  if ((bits == 0) && ((hi & 0xfffff) === 0)) {\n    return (s > 0) ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;\n  }\n  return Number.NaN;\n}\nvar m = (hi & 0xfffff).next32(bits);\nif (e === 0) {\n  m = m.shl64(1);\n} else {\n  m.hi = m.high32() | 0x100000;\n}\nreturn s * m.toFP() * Math.pow(2.0, e - 1075);\n")
    public static native double longBitsToDouble(long var0);

    @Override
    public int compareTo(Double anotherDouble) {
        return Double.compare(this.value, anotherDouble.value);
    }

    public static int compare(double d1, double d2) {
        long anotherBits;
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        long thisBits = Double.doubleToLongBits(d1);
        return thisBits == (anotherBits = Double.doubleToLongBits(d2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }
}

