/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

public final class Character
implements Serializable,
Comparable<Character> {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final Class<Character> TYPE = Class.getPrimitiveClass("char");
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    static final int ERROR = -1;
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    private final char value;
    private static final long serialVersionUID = 3786198910865385080L;
    public static final int SIZE = 16;

    public Character(char value) {
        this.value = value;
    }

    public static Character valueOf(char c) {
        if (c <= '\u007f') {
            return CharacterCache.cache[c];
        }
        return new Character(c);
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Character) {
            return this.value == ((Character)obj).charValue();
        }
        return false;
    }

    public String toString() {
        char[] buf = new char[]{this.value};
        return String.valueOf(buf);
    }

    public static String toString(char c) {
        return String.valueOf(c);
    }

    public static boolean isValidCodePoint(int codePoint) {
        int plane = codePoint >>> 16;
        return plane < 17;
    }

    public static boolean isBmpCodePoint(int codePoint) {
        return codePoint >>> 16 == 0;
    }

    public static boolean isSupplementaryCodePoint(int codePoint) {
        return codePoint >= 65536 && codePoint < 0x110000;
    }

    public static boolean isHighSurrogate(char ch) {
        return ch >= '\ud800' && ch < '\udc00';
    }

    public static boolean isLowSurrogate(char ch) {
        return ch >= '\udc00' && ch < '\ue000';
    }

    public static boolean isSurrogate(char ch) {
        return ch >= '\ud800' && ch < '\ue000';
    }

    public static boolean isSurrogatePair(char high, char low) {
        return Character.isHighSurrogate(high) && Character.isLowSurrogate(low);
    }

    public static int charCount(int codePoint) {
        return codePoint >= 65536 ? 2 : 1;
    }

    public static int toCodePoint(char high, char low) {
        return (high << 10) + low + -56613888;
    }

    public static int codePointAt(CharSequence seq, int index) {
        char c2;
        char c1;
        if (Character.isHighSurrogate(c1 = seq.charAt(index++)) && index < seq.length() && Character.isLowSurrogate(c2 = seq.charAt(index))) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    public static int codePointAt(char[] a, int index) {
        return Character.codePointAtImpl(a, index, a.length);
    }

    public static int codePointAt(char[] a, int index, int limit) {
        if (index >= limit || limit < 0 || limit > a.length) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointAtImpl(a, index, limit);
    }

    static int codePointAtImpl(char[] a, int index, int limit) {
        char c2;
        char c1;
        if (Character.isHighSurrogate(c1 = a[index++]) && index < limit && Character.isLowSurrogate(c2 = a[index])) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    public static int codePointBefore(CharSequence seq, int index) {
        char c1;
        char c2;
        if (Character.isLowSurrogate(c2 = seq.charAt(--index)) && index > 0 && Character.isHighSurrogate(c1 = seq.charAt(--index))) {
            return Character.toCodePoint(c1, c2);
        }
        return c2;
    }

    public static int codePointBefore(char[] a, int index) {
        return Character.codePointBeforeImpl(a, index, 0);
    }

    public static int codePointBefore(char[] a, int index, int start) {
        if (index <= start || start < 0 || start >= a.length) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointBeforeImpl(a, index, start);
    }

    static int codePointBeforeImpl(char[] a, int index, int start) {
        char c1;
        char c2;
        if (Character.isLowSurrogate(c2 = a[--index]) && index > start && Character.isHighSurrogate(c1 = a[--index])) {
            return Character.toCodePoint(c1, c2);
        }
        return c2;
    }

    public static char highSurrogate(int codePoint) {
        return (char)((codePoint >>> 10) + 55232);
    }

    public static char lowSurrogate(int codePoint) {
        return (char)((codePoint & 0x3FF) + 56320);
    }

    public static int toChars(int codePoint, char[] dst, int dstIndex) {
        if (Character.isBmpCodePoint(codePoint)) {
            dst[dstIndex] = (char)codePoint;
            return 1;
        }
        if (Character.isValidCodePoint(codePoint)) {
            Character.toSurrogates(codePoint, dst, dstIndex);
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static char[] toChars(int codePoint) {
        if (Character.isBmpCodePoint(codePoint)) {
            return new char[]{(char)codePoint};
        }
        if (Character.isValidCodePoint(codePoint)) {
            char[] result = new char[2];
            Character.toSurrogates(codePoint, result, 0);
            return result;
        }
        throw new IllegalArgumentException();
    }

    static void toSurrogates(int codePoint, char[] dst, int index) {
        dst[index + 1] = Character.lowSurrogate(codePoint);
        dst[index] = Character.highSurrogate(codePoint);
    }

    public static int codePointCount(CharSequence seq, int beginIndex, int endIndex) {
        int length = seq.length();
        if (beginIndex < 0 || endIndex > length || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        int n = endIndex - beginIndex;
        int i = beginIndex;
        while (i < endIndex) {
            if (!Character.isHighSurrogate(seq.charAt(i++)) || i >= endIndex || !Character.isLowSurrogate(seq.charAt(i))) continue;
            --n;
            ++i;
        }
        return n;
    }

    public static int codePointCount(char[] a, int offset, int count) {
        if (count > a.length - offset || offset < 0 || count < 0) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(a, offset, count);
    }

    static int codePointCountImpl(char[] a, int offset, int count) {
        int endIndex = offset + count;
        int n = count;
        int i = offset;
        while (i < endIndex) {
            if (!Character.isHighSurrogate(a[i++]) || i >= endIndex || !Character.isLowSurrogate(a[i])) continue;
            --n;
            ++i;
        }
        return n;
    }

    public static int offsetByCodePoints(CharSequence seq, int index, int codePointOffset) {
        int length = seq.length();
        if (index < 0 || index > length) {
            throw new IndexOutOfBoundsException();
        }
        int x = index;
        if (codePointOffset >= 0) {
            int i;
            for (i = 0; x < length && i < codePointOffset; ++i) {
                if (!Character.isHighSurrogate(seq.charAt(x++)) || x >= length || !Character.isLowSurrogate(seq.charAt(x))) continue;
                ++x;
            }
            if (i < codePointOffset) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            int i;
            for (i = codePointOffset; x > 0 && i < 0; ++i) {
                if (!Character.isLowSurrogate(seq.charAt(--x)) || x <= 0 || !Character.isHighSurrogate(seq.charAt(x - 1))) continue;
                --x;
            }
            if (i < 0) {
                throw new IndexOutOfBoundsException();
            }
        }
        return x;
    }

    public static int offsetByCodePoints(char[] a, int start, int count, int index, int codePointOffset) {
        if (count > a.length - start || start < 0 || count < 0 || index < start || index > start + count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(a, start, count, index, codePointOffset);
    }

    static int offsetByCodePointsImpl(char[] a, int start, int count, int index, int codePointOffset) {
        int x = index;
        if (codePointOffset >= 0) {
            int i;
            int limit = start + count;
            for (i = 0; x < limit && i < codePointOffset; ++i) {
                if (!Character.isHighSurrogate(a[x++]) || x >= limit || !Character.isLowSurrogate(a[x])) continue;
                ++x;
            }
            if (i < codePointOffset) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            int i;
            for (i = codePointOffset; x > start && i < 0; ++i) {
                if (!Character.isLowSurrogate(a[--x]) || x <= start || !Character.isHighSurrogate(a[x - 1])) continue;
                --x;
            }
            if (i < 0) {
                throw new IndexOutOfBoundsException();
            }
        }
        return x;
    }

    public static boolean isLowerCase(char ch) {
        return ch == Character.toLowerCase(ch);
    }

    public static boolean isUpperCase(char ch) {
        return ch == Character.toUpperCase(ch);
    }

    public static boolean isTitleCase(char ch) {
        return Character.isTitleCase((int)ch);
    }

    public static boolean isTitleCase(int codePoint) {
        return Character.getType(codePoint) == 3;
    }

    public static boolean isDigit(char ch) {
        return String.valueOf(ch).matches("\\d");
    }

    public static boolean isDigit(int codePoint) {
        return Character.fromCodeChars(codePoint).matches("\\d");
    }

    @JavaScriptBody(args={"c"}, body="return String.fromCharCode(c);")
    private static native String fromCodeChars(int var0);

    public static boolean isDefined(char ch) {
        return Character.isDefined((int)ch);
    }

    public static boolean isDefined(int codePoint) {
        return Character.getType(codePoint) != 0;
    }

    public static boolean isLetter(char ch) {
        return String.valueOf(ch).matches("\\w") && !Character.isDigit(ch);
    }

    public static boolean isLetter(int codePoint) {
        return Character.fromCodeChars(codePoint).matches("\\w") && !Character.isDigit(codePoint);
    }

    public static boolean isLetterOrDigit(char ch) {
        return String.valueOf(ch).matches("\\w");
    }

    public static boolean isLetterOrDigit(int codePoint) {
        return Character.fromCodeChars(codePoint).matches("\\w");
    }

    static int getType(int x) {
        throw new UnsupportedOperationException();
    }

    public static boolean isJavaIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart((int)ch);
    }

    public static boolean isJavaIdentifierStart(int codePoint) {
        return 65 <= codePoint && codePoint <= 90 || 97 <= codePoint && codePoint <= 122;
    }

    public static boolean isJavaIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart((int)ch);
    }

    public static boolean isJavaIdentifierPart(int codePoint) {
        return Character.isJavaIdentifierStart(codePoint) || 48 <= codePoint && codePoint <= 57 || codePoint == 36;
    }

    public static char toLowerCase(char ch) {
        return String.valueOf(ch).toLowerCase().charAt(0);
    }

    public static char toUpperCase(char ch) {
        return String.valueOf(ch).toUpperCase().charAt(0);
    }

    public static int digit(char ch, int radix) {
        return Character.digit((int)ch, radix);
    }

    @JavaScriptBody(args={"codePoint", "radix"}, body="var x = parseInt(String.fromCharCode(codePoint), radix);\nreturn isNaN(x) ? -1 : x;")
    public static int digit(int codePoint, int radix) {
        throw new UnsupportedOperationException();
    }

    public static int getNumericValue(char ch) {
        return Character.getNumericValue((int)ch);
    }

    public static int getNumericValue(int codePoint) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static boolean isSpace(char ch) {
        return ch <= ' ' && (4294981120L >> ch & 1L) != 0L;
    }

    public static boolean isWhitespace(char ch) {
        return Character.isWhitespace((int)ch);
    }

    public static boolean isWhitespace(int codePoint) {
        throw new UnsupportedOperationException();
    }

    public static boolean isISOControl(char ch) {
        return Character.isISOControl((int)ch);
    }

    public static boolean isISOControl(int codePoint) {
        return codePoint <= 159 && (codePoint >= 127 || codePoint >>> 5 == 0);
    }

    public static char forDigit(int digit, int radix) {
        if (digit >= radix || digit < 0) {
            return '\u0000';
        }
        if (radix < 2 || radix > 36) {
            return '\u0000';
        }
        if (digit < 10) {
            return (char)(48 + digit);
        }
        return (char)(87 + digit);
    }

    @Override
    public int compareTo(Character anotherCharacter) {
        return Character.compare(this.value, anotherCharacter.value);
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static char reverseBytes(char ch) {
        return (char)((ch & 0xFF00) >> 8 | ch << 8);
    }

    @JavaScriptBody(args={}, body="vm.java_lang_Character(false).valueOf = function() { return this._value(); };")
    private static native void initValueOf();

    static {
        Character.initValueOf();
    }

    private static class CharacterCache {
        static final Character[] cache = new Character[128];

        private CharacterCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                CharacterCache.cache[i] = new Character((char)i);
            }
        }
    }

    public static class Subset {
        private String name;

        protected Subset(String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.name = name;
        }

        public final boolean equals(Object obj) {
            return this == obj;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

