/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;

public abstract class InputStream
implements Closeable {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static byte[] skipBuffer;

    public abstract int read() throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException ee) {
            // empty catch block
        }
        return i;
    }

    public long skip(long n) throws IOException {
        int nr;
        long remaining = n;
        if (skipBuffer == null) {
            skipBuffer = new byte[2048];
        }
        byte[] localSkipBuffer = skipBuffer;
        if (n <= 0L) {
            return 0L;
        }
        while (remaining > 0L && (nr = this.read(localSkipBuffer, 0, (int)Math.min(2048L, remaining))) >= 0) {
            remaining -= (long)nr;
        }
        return n - remaining;
    }

    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }
}

