/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private final Object[] array;

    public AtomicReferenceArray(int length) {
        this.array = new Object[length];
    }

    public AtomicReferenceArray(E[] array) {
        this.array = (Object[])array.clone();
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int i) {
        return (E)this.array[i];
    }

    public final void set(int i, E newValue) {
        this.array[i] = newValue;
    }

    public final void lazySet(int i, E newValue) {
        this.array[i] = newValue;
    }

    public final E getAndSet(int i, E newValue) {
        Object v = this.array[i];
        this.array[i] = newValue;
        return (E)v;
    }

    public final boolean compareAndSet(int i, E expect, E update) {
        if (this.array[i] == expect) {
            this.array[i] = update;
            return true;
        }
        return false;
    }

    public final boolean weakCompareAndSet(int i, E expect, E update) {
        return this.compareAndSet(i, expect, update);
    }

    public String toString() {
        int iMax = this.array.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.get(i));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i;
        }
    }
}

